/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.Acl;
import com.google.cloud.storage.contrib.nio.CloudStorageOption;
import com.google.cloud.storage.contrib.nio.OptionAcl;
import com.google.cloud.storage.contrib.nio.OptionAllowTrailingSlash;
import com.google.cloud.storage.contrib.nio.OptionBlockSize;
import com.google.cloud.storage.contrib.nio.OptionCacheControl;
import com.google.cloud.storage.contrib.nio.OptionContentDisposition;
import com.google.cloud.storage.contrib.nio.OptionContentEncoding;
import com.google.cloud.storage.contrib.nio.OptionMaxChannelReopens;
import com.google.cloud.storage.contrib.nio.OptionMimeType;
import com.google.cloud.storage.contrib.nio.OptionUserMetadata;

public final class CloudStorageOptions {
    public static CloudStorageOption.OpenCopy withMimeType(String mimeType) {
        return OptionMimeType.create(mimeType);
    }

    public static CloudStorageOption.OpenCopy withoutCaching() {
        return CloudStorageOptions.withCacheControl("no-cache");
    }

    public static CloudStorageOption.OpenCopy withCacheControl(String cacheControl) {
        return OptionCacheControl.create(cacheControl);
    }

    public static CloudStorageOption.OpenCopy withContentDisposition(String contentDisposition) {
        return OptionContentDisposition.create(contentDisposition);
    }

    public static CloudStorageOption.OpenCopy withContentEncoding(String contentEncoding) {
        return OptionContentEncoding.create(contentEncoding);
    }

    public static CloudStorageOption.OpenCopy withAcl(Acl acl) {
        return OptionAcl.create(acl);
    }

    public static CloudStorageOption.OpenCopy withUserMetadata(String key, String value) {
        return OptionUserMetadata.create(key, value);
    }

    public static CloudStorageOption.OpenCopy withBlockSize(int size) {
        return OptionBlockSize.create(size);
    }

    public static CloudStorageOption.OpenCopy withChannelReopen(int count) {
        return OptionMaxChannelReopens.create(count);
    }

    static CloudStorageOption.Open allowTrailingSlash() {
        return OptionAllowTrailingSlash.getInstance();
    }

    private CloudStorageOptions() {
    }
}

