/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import java.io.Closeable;
import java.io.IOException;
import org.apache.pinot.shaded.com.google.common.base.MoreObjects;

@FunctionalInterface
@InternalApi
@InternalExtensionOnly
interface IOAutoCloseable
extends AutoCloseable,
Closeable {
    @Override
    public void close() throws IOException;

    @InternalApi
    default public IOAutoCloseable andThen(IOAutoCloseable then) {
        if (NoOpIOAutoCloseable.INSTANCE.equals(this)) {
            return then;
        }
        if (NoOpIOAutoCloseable.INSTANCE.equals(then)) {
            return this;
        }
        return new AndThenIOAutoClosable(this, then);
    }

    @InternalApi
    public static IOAutoCloseable noOp() {
        return NoOpIOAutoCloseable.INSTANCE;
    }

    public static final class NoOpIOAutoCloseable
    implements IOAutoCloseable {
        private static final NoOpIOAutoCloseable INSTANCE = new NoOpIOAutoCloseable();

        private NoOpIOAutoCloseable() {
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static final class AndThenIOAutoClosable
    implements IOAutoCloseable {
        private final IOAutoCloseable first;
        private final IOAutoCloseable second;

        private AndThenIOAutoClosable(IOAutoCloseable first, IOAutoCloseable second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void close() throws IOException {
            try (IOAutoCloseable ignore2 = this.second;){
                IOAutoCloseable ignore1 = this.first;
                if (ignore1 != null) {
                    ignore1.close();
                }
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("first", this.first).add("second", this.second).toString();
        }
    }
}

