/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiClock;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StateCheckingResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.WatchdogTimeoutException;
import com.google.api.gax.util.TimeConversionUtils;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.threeten.bp.Duration;

public final class Watchdog
implements Runnable,
BackgroundResource {
    private static final Logger LOG = Logger.getLogger(Watchdog.class.getName());
    private static Object PRESENT = new Object();
    private final ConcurrentHashMap<WatchdogStream, Object> openStreams = new ConcurrentHashMap();
    private final ApiClock clock;
    private final java.time.Duration scheduleInterval;
    private final ScheduledExecutorService executor;
    private ScheduledFuture<?> future;

    @ObsoleteApi(value="Use create(ApiClock, java.time.Duration, ScheduledExecutorService) instead")
    public static Watchdog create(ApiClock clock, Duration scheduleInterval, ScheduledExecutorService executor) {
        return Watchdog.createDuration(clock, TimeConversionUtils.toJavaTimeDuration(scheduleInterval), executor);
    }

    public static Watchdog createDuration(ApiClock clock, java.time.Duration scheduleInterval, ScheduledExecutorService executor) {
        Watchdog watchdog = new Watchdog(clock, scheduleInterval, executor);
        watchdog.start();
        return watchdog;
    }

    private Watchdog(ApiClock clock, java.time.Duration scheduleInterval, ScheduledExecutorService executor) {
        this.clock = Preconditions.checkNotNull(clock, "clock can't be null");
        this.scheduleInterval = scheduleInterval;
        this.executor = executor;
    }

    private void start() {
        this.future = this.executor.scheduleAtFixedRate(this, this.scheduleInterval.toMillis(), this.scheduleInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    @ObsoleteApi(value="Use watchDuration(ResponseObserver, java.time.Duration, java.time.Duration) instead")
    public <ResponseT> ResponseObserver<ResponseT> watch(ResponseObserver<ResponseT> innerObserver, @Nonnull Duration waitTimeout, @Nonnull Duration idleTimeout) {
        return this.watchDuration(innerObserver, TimeConversionUtils.toJavaTimeDuration(waitTimeout), TimeConversionUtils.toJavaTimeDuration(idleTimeout));
    }

    public <ResponseT> ResponseObserver<ResponseT> watchDuration(ResponseObserver<ResponseT> innerObserver, @Nonnull java.time.Duration waitTimeout, @Nonnull java.time.Duration idleTimeout) {
        Preconditions.checkNotNull(innerObserver, "innerObserver can't be null");
        Preconditions.checkNotNull(waitTimeout, "waitTimeout can't be null");
        Preconditions.checkNotNull(idleTimeout, "idleTimeout can't be null");
        if (waitTimeout.isZero() && idleTimeout.isZero()) {
            return innerObserver;
        }
        WatchdogStream<ResponseT> stream = new WatchdogStream<ResponseT>(innerObserver, waitTimeout, idleTimeout);
        this.openStreams.put(stream, PRESENT);
        return stream;
    }

    @Override
    public void run() {
        try {
            this.runUnsafe();
        }
        catch (Throwable t2) {
            LOG.log(Level.SEVERE, "Caught throwable in periodic Watchdog run. Continuing.", t2);
        }
    }

    private void runUnsafe() {
        Iterator<Map.Entry<WatchdogStream, Object>> it = this.openStreams.entrySet().iterator();
        while (it.hasNext()) {
            WatchdogStream stream = it.next().getKey();
            if (!stream.cancelIfStale()) continue;
            it.remove();
        }
    }

    @Override
    public void shutdown() {
        this.future.cancel(false);
    }

    @Override
    public boolean isShutdown() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isTerminated() {
        return this.future.isDone();
    }

    @Override
    public void shutdownNow() {
        this.future.cancel(true);
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        try {
            this.future.get(duration, unit);
            return true;
        }
        catch (CancellationException | ExecutionException e) {
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    @VisibleForTesting
    java.time.Duration getScheduleIntervalDuration() {
        return this.scheduleInterval;
    }

    @VisibleForTesting
    Duration getScheduleInterval() {
        return TimeConversionUtils.toThreetenDuration(this.scheduleInterval);
    }

    class WatchdogStream<ResponseT>
    extends StateCheckingResponseObserver<ResponseT> {
        private final Object lock = new Object();
        private final java.time.Duration waitTimeout;
        private final java.time.Duration idleTimeout;
        private boolean hasStarted;
        private boolean autoAutoFlowControl = true;
        private final ResponseObserver<ResponseT> outerResponseObserver;
        private volatile StreamController innerController;
        @GuardedBy(value="lock")
        private State state = State.WAITING;
        @GuardedBy(value="lock")
        private int pendingCount = 0;
        @GuardedBy(value="lock")
        private long lastActivityAt = Watchdog.access$000(Watchdog.this).millisTime();
        private volatile Throwable error;

        WatchdogStream(ResponseObserver<ResponseT> responseObserver, java.time.Duration waitTimeout, java.time.Duration idleTimeout) {
            this.waitTimeout = waitTimeout;
            this.idleTimeout = idleTimeout;
            this.outerResponseObserver = responseObserver;
        }

        @Override
        public void onStartImpl(StreamController controller) {
            this.innerController = controller;
            this.outerResponseObserver.onStart(new StreamController(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void disableAutoInboundFlowControl() {
                    Preconditions.checkState(!WatchdogStream.this.hasStarted, "Can't disable automatic flow control after the stream has started");
                    Object object = WatchdogStream.this.lock;
                    synchronized (object) {
                        WatchdogStream.this.state = State.IDLE;
                    }
                    WatchdogStream.this.autoAutoFlowControl = false;
                    WatchdogStream.this.innerController.disableAutoInboundFlowControl();
                }

                @Override
                public void request(int count) {
                    WatchdogStream.this.onRequest(count);
                }

                @Override
                public void cancel() {
                    WatchdogStream.this.onCancel();
                }
            });
            this.hasStarted = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onRequest(int count) {
            Preconditions.checkArgument(count > 0, "count must be > 0");
            Preconditions.checkState(!this.autoAutoFlowControl, "Auto flow control is enabled");
            Object object = this.lock;
            synchronized (object) {
                if (this.state == State.IDLE) {
                    this.state = State.WAITING;
                    this.lastActivityAt = Watchdog.this.clock.millisTime();
                }
                int maxIncrement = Integer.MAX_VALUE - this.pendingCount;
                count = Math.min(maxIncrement, count);
                this.pendingCount += count;
            }
            this.innerController.request(count);
        }

        private void onCancel() {
            this.error = new CancellationException("User cancelled stream");
            this.innerController.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResponseImpl(ResponseT response) {
            Object object = this.lock;
            synchronized (object) {
                this.state = State.DELIVERING;
            }
            this.outerResponseObserver.onResponse(response);
            object = this.lock;
            synchronized (object) {
                --this.pendingCount;
                this.lastActivityAt = Watchdog.this.clock.millisTime();
                this.state = this.autoAutoFlowControl || this.pendingCount > 0 ? State.WAITING : State.IDLE;
            }
        }

        @Override
        public void onErrorImpl(Throwable t2) {
            if (this.error != null) {
                t2 = this.error;
            }
            Watchdog.this.openStreams.remove(this);
            this.outerResponseObserver.onError(t2);
        }

        @Override
        public void onCompleteImpl() {
            Watchdog.this.openStreams.remove(this);
            this.outerResponseObserver.onComplete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cancelIfStale() {
            if (this.innerController == null) {
                return false;
            }
            WatchdogTimeoutException myError = null;
            Object object = this.lock;
            synchronized (object) {
                long waitTime = Watchdog.this.clock.millisTime() - this.lastActivityAt;
                switch (this.state) {
                    case IDLE: {
                        if (this.idleTimeout.isZero() || waitTime < this.idleTimeout.toMillis()) break;
                        myError = new WatchdogTimeoutException("Canceled due to idle connection", false);
                        break;
                    }
                    case WAITING: {
                        if (this.waitTimeout.isZero() || waitTime < this.waitTimeout.toMillis()) break;
                        myError = new WatchdogTimeoutException("Canceled due to timeout waiting for next response", true);
                    }
                }
            }
            if (myError != null) {
                this.error = myError;
                this.innerController.cancel();
                return true;
            }
            return false;
        }
    }

    static enum State {
        IDLE,
        WAITING,
        DELIVERING;

    }
}

