/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class PageRange
implements XmlSerializable<PageRange> {
    private long start;
    private long end;

    public long getStart() {
        return this.start;
    }

    public PageRange setStart(long start) {
        this.start = start;
        return this;
    }

    public long getEnd() {
        return this.end;
    }

    public PageRange setEnd(long end) {
        this.end = end;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "PageRange" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeLongElement("Start", this.start);
        xmlWriter.writeLongElement("End", this.end);
        return xmlWriter.writeEndElement();
    }

    public static PageRange fromXml(XmlReader xmlReader) throws XMLStreamException {
        return PageRange.fromXml(xmlReader, null);
    }

    public static PageRange fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "PageRange" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            PageRange deserializedPageRange = new PageRange();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Start".equals(elementName.getLocalPart())) {
                    deserializedPageRange.start = reader.getLongElement();
                    continue;
                }
                if ("End".equals(elementName.getLocalPart())) {
                    deserializedPageRange.end = reader.getLongElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedPageRange;
        });
    }
}

