/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.implementation.models.ArrowField;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ArrowConfiguration
implements XmlSerializable<ArrowConfiguration> {
    private List<ArrowField> schema;

    public List<ArrowField> getSchema() {
        if (this.schema == null) {
            this.schema = new ArrayList<ArrowField>();
        }
        return this.schema;
    }

    public ArrowConfiguration setSchema(List<ArrowField> schema) {
        this.schema = schema;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "ArrowConfiguration" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.schema != null) {
            xmlWriter.writeStartElement("Schema");
            for (ArrowField element : this.schema) {
                xmlWriter.writeXml(element, "Field");
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    public static ArrowConfiguration fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ArrowConfiguration.fromXml(xmlReader, null);
    }

    public static ArrowConfiguration fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "ArrowConfiguration" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            ArrowConfiguration deserializedArrowConfiguration = new ArrowConfiguration();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Schema".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("Field".equals(elementName.getLocalPart())) {
                            if (deserializedArrowConfiguration.schema == null) {
                                deserializedArrowConfiguration.schema = new ArrayList<ArrowField>();
                            }
                            deserializedArrowConfiguration.schema.add(ArrowField.fromXml(reader, "Field"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                reader.skipElement();
            }
            return deserializedArrowConfiguration;
        });
    }
}

