/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import reactor.core.publisher.Mono;

public final class AuthenticationRecord {
    static final ClientLogger LOGGER = new ClientLogger(AuthenticationRecord.class);
    private String authority;
    private String homeAccountId;
    private String tenantId;
    private String username;
    private String clientId;

    AuthenticationRecord() {
    }

    AuthenticationRecord(IAuthenticationResult authenticationResult, String tenantId, String clientId) {
        this(authenticationResult.account().environment(), authenticationResult.account().homeAccountId(), authenticationResult.account().username(), tenantId, clientId);
    }

    AuthenticationRecord(String authority, String homeAccountId, String userName, String tenantId, String clientId) {
        this.authority = authority;
        this.homeAccountId = homeAccountId;
        this.tenantId = tenantId;
        this.username = userName;
        this.clientId = clientId;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getHomeAccountId() {
        return this.homeAccountId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUsername() {
        return this.username;
    }

    public Mono<OutputStream> serializeAsync(OutputStream outputStream) {
        return Mono.fromCallable(() -> {
            this.serialize(outputStream);
            return outputStream;
        });
    }

    public void serialize(OutputStream outputStream) {
        try (JsonWriter writer = JsonProviders.createWriter(outputStream);){
            writer.writeStartObject();
            writer.writeStringField("authority", this.authority);
            writer.writeStringField("homeAccountId", this.homeAccountId);
            writer.writeStringField("tenantId", this.tenantId);
            writer.writeStringField("username", this.username);
            writer.writeStringField("clientId", this.clientId);
            writer.writeEndObject();
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    public static Mono<AuthenticationRecord> deserializeAsync(InputStream inputStream) {
        return Mono.fromCallable(() -> AuthenticationRecord.deserialize(inputStream));
    }

    public static AuthenticationRecord deserialize(InputStream inputStream) {
        AuthenticationRecord authenticationRecord;
        block8: {
            JsonReader jsonReader = JsonProviders.createReader(inputStream);
            try {
                authenticationRecord = jsonReader.readObject(reader -> {
                    String authority = null;
                    String homeAccountId = null;
                    String tenantId = null;
                    String username = null;
                    String clientId = null;
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("authority".equals(fieldName)) {
                            authority = reader.getString();
                            continue;
                        }
                        if ("homeAccountId".equals(fieldName)) {
                            homeAccountId = reader.getString();
                            continue;
                        }
                        if ("tenantId".equals(fieldName)) {
                            tenantId = reader.getString();
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            username = reader.getString();
                            continue;
                        }
                        if ("clientId".equals(fieldName)) {
                            clientId = reader.getString();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    return new AuthenticationRecord(authority, homeAccountId, username, tenantId, clientId);
                });
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw LOGGER.logExceptionAsError(new RuntimeException(e));
                }
            }
            jsonReader.close();
        }
        return authenticationRecord;
    }
}

