/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.tsdb.m3ql.plan;

import java.util.List;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableList;
import org.apache.pinot.tsdb.m3ql.operator.TransformNullOperator;
import org.apache.pinot.tsdb.spi.operator.BaseTimeSeriesOperator;
import org.apache.pinot.tsdb.spi.plan.BaseTimeSeriesPlanNode;

public class TransformNullPlanNode
extends BaseTimeSeriesPlanNode {
    public static final Double DEFAULT_VALUE = 0.0;
    private final Double _defaultValue;

    @JsonCreator
    public TransformNullPlanNode(@JsonProperty(value="id") String id, @JsonProperty(value="defaultValue") Double defaultValue, @JsonProperty(value="inputs") List<BaseTimeSeriesPlanNode> inputs) {
        super(id, inputs);
        this._defaultValue = defaultValue;
    }

    public Double getDefaultValue() {
        return this._defaultValue;
    }

    public BaseTimeSeriesPlanNode withInputs(List<BaseTimeSeriesPlanNode> newInputs) {
        return new TransformNullPlanNode(this._id, this._defaultValue, newInputs);
    }

    public String getKlass() {
        return TransformNullPlanNode.class.getName();
    }

    public String getExplainName() {
        return "TRANSFORM_NULL";
    }

    public BaseTimeSeriesOperator run() {
        Preconditions.checkState(this._inputs.size() == 1, "TransformNullPlanNode should have only 1 child, got: %s", this._inputs.size());
        BaseTimeSeriesOperator childOperator = ((BaseTimeSeriesPlanNode)this._inputs.get(0)).run();
        return new TransformNullOperator(this._defaultValue, ImmutableList.of(childOperator));
    }
}

