/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.avro;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericRecord;
import org.apache.pinot.plugin.inputformat.avro.AvroUtils;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.IngestionSchemaValidator;
import org.apache.pinot.spi.data.SchemaValidatorResult;

public class AvroIngestionSchemaValidator
implements IngestionSchemaValidator {
    private Schema _avroSchema;
    private org.apache.pinot.spi.data.Schema _pinotSchema;
    private SchemaValidatorResult _dataTypeMismatch = new SchemaValidatorResult();
    private SchemaValidatorResult _singleValueMultiValueFieldMismatch = new SchemaValidatorResult();
    private SchemaValidatorResult _multiValueStructureMismatch = new SchemaValidatorResult();
    private SchemaValidatorResult _missingPinotColumn = new SchemaValidatorResult();

    public void init(org.apache.pinot.spi.data.Schema pinotSchema, String inputFilePath) {
        this._pinotSchema = pinotSchema;
        this._avroSchema = this.extractAvroSchemaFromFile(inputFilePath);
        this.validateSchemas();
    }

    public String getInputSchemaType() {
        return "AVRO";
    }

    public SchemaValidatorResult getDataTypeMismatchResult() {
        return this._dataTypeMismatch;
    }

    public SchemaValidatorResult getSingleValueMultiValueFieldMismatchResult() {
        return this._singleValueMultiValueFieldMismatch;
    }

    public SchemaValidatorResult getMultiValueStructureMismatchResult() {
        return this._multiValueStructureMismatch;
    }

    public SchemaValidatorResult getMissingPinotColumnResult() {
        return this._missingPinotColumn;
    }

    private Schema extractAvroSchemaFromFile(String inputPath) {
        try {
            DataFileStream<GenericRecord> dataStreamReader = AvroUtils.getAvroReader(new File(inputPath));
            Schema avroSchema = dataStreamReader.getSchema();
            dataStreamReader.close();
            return avroSchema;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException when extracting avro schema from input path: " + inputPath, e);
        }
    }

    private void validateSchemas() {
        for (FieldSpec fieldSpec : this._pinotSchema.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn()) continue;
            String columnName = fieldSpec.getName();
            Schema.Field avroColumnField = this._avroSchema.getField(columnName);
            if (avroColumnField == null) {
                this._missingPinotColumn.addMismatchReason(String.format("The Pinot column: (%s: %s) is missing in the %s schema of input data.", columnName, fieldSpec.getDataType().name(), this.getInputSchemaType()));
                continue;
            }
            if (fieldSpec.getDataType() == FieldSpec.DataType.JSON) continue;
            String avroColumnName = avroColumnField.schema().getName();
            Schema avroColumnSchema = avroColumnField.schema();
            Schema.Type avroColumnType = avroColumnSchema.getType();
            if (avroColumnType == Schema.Type.UNION) {
                Schema nonNullSchema = null;
                for (Schema childFieldSchema : avroColumnSchema.getTypes()) {
                    if (childFieldSchema.getType() == Schema.Type.NULL) continue;
                    if (nonNullSchema == null) {
                        nonNullSchema = childFieldSchema;
                        continue;
                    }
                    throw new IllegalStateException("More than one non-null schema in UNION schema");
                }
                if (nonNullSchema != null) {
                    avroColumnSchema = nonNullSchema;
                    avroColumnType = nonNullSchema.getType();
                }
            }
            if (fieldSpec.isSingleValueField()) {
                if (avroColumnType.ordinal() < Schema.Type.STRING.ordinal()) {
                    this._singleValueMultiValueFieldMismatch.addMismatchReason(String.format("The Pinot column: %s is 'single-value' column but the column: %s from input %s is 'multi-value' column.", columnName, avroColumnName, this.getInputSchemaType()));
                }
                FieldSpec.DataType dataTypeForSVColumn = AvroUtils.extractFieldDataType(avroColumnField);
                if (fieldSpec.getDataType() == dataTypeForSVColumn) continue;
                this._dataTypeMismatch.addMismatchReason(String.format("The Pinot column: (%s: %s) doesn't match with the column (%s: %s) in input %s schema.", columnName, fieldSpec.getDataType().name(), avroColumnName, avroColumnType.name(), this.getInputSchemaType()));
                continue;
            }
            if (avroColumnType.ordinal() >= Schema.Type.STRING.ordinal()) {
                this._singleValueMultiValueFieldMismatch.addMismatchReason(String.format("The Pinot column: %s is 'multi-value' column but the column: %s from input %s schema is 'single-value' column.", columnName, avroColumnName, this.getInputSchemaType()));
            }
            FieldSpec.DataType dataTypeForMVColumn = AvroUtils.extractFieldDataType(avroColumnField);
            if (fieldSpec.getDataType() != dataTypeForMVColumn) {
                this._dataTypeMismatch.addMismatchReason(String.format("The Pinot column: (%s: %s) doesn't match with the column (%s: %s) in input %s schema.", columnName, fieldSpec.getDataType().name(), avroColumnName, dataTypeForMVColumn.name(), this.getInputSchemaType()));
            }
            if (avroColumnType != Schema.Type.ARRAY) {
                this._multiValueStructureMismatch.addMismatchReason(String.format("The Pinot column: %s is 'multi-value' column but the column: %s from input %s schema is of '%s' type, which should have been of 'array' type.", columnName, avroColumnName, this.getInputSchemaType(), avroColumnType.getName()));
                continue;
            }
            Schema.Type elementType = avroColumnSchema.getElementType().getType();
            if (elementType.ordinal() >= Schema.Type.STRING.ordinal()) continue;
            this._multiValueStructureMismatch.addMismatchReason(String.format("The Pinot column: %s is 'multi-value' column and it's of 'array' type in input %s schema, but the element type is of '%s' type, which should have been of 'primitive' type.", new Object[]{columnName, this.getInputSchemaType(), avroColumnSchema.getElementType().getType()}));
        }
    }
}

