/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities;

import io.confluent.kafka.schemaregistry.client.rest.entities.RuleKind;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import io.swagger.v3.oas.annotations.media.Schema;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="Rule")
public class Rule {
    public static final int NAME_MAX_LENGTH = 64;
    private final String name;
    private final String doc;
    private final RuleKind kind;
    private final RuleMode mode;
    private final String type;
    private final SortedSet<String> tags;
    @JsonPropertyOrder(alphabetic=true)
    private final SortedMap<String, String> params;
    private final String expr;
    private final String onSuccess;
    private final String onFailure;
    private final boolean disabled;

    @JsonCreator
    public Rule(@JsonProperty(value="name") String name, @JsonProperty(value="doc") String doc, @JsonProperty(value="kind") RuleKind kind, @JsonProperty(value="mode") RuleMode mode, @JsonProperty(value="type") String type, @JsonProperty(value="tags") Set<String> tags, @JsonProperty(value="params") Map<String, String> params, @JsonProperty(value="expr") String expr, @JsonProperty(value="onSuccess") String onSuccess, @JsonProperty(value="onFailure") String onFailure, @JsonProperty(value="disabled") boolean disabled) {
        this.name = name;
        this.doc = doc;
        this.kind = kind != null ? kind : RuleKind.TRANSFORM;
        this.mode = mode != null ? mode : RuleMode.WRITEREAD;
        this.type = type;
        SortedSet sortedTags = tags != null ? (SortedSet)tags.stream().sorted().collect(Collectors.toCollection(TreeSet::new)) : Collections.emptySortedSet();
        TreeMap<String, String> sortedParams = params != null ? new TreeMap<String, String>(params) : Collections.emptySortedMap();
        this.tags = Collections.unmodifiableSortedSet(sortedTags);
        this.params = Collections.unmodifiableSortedMap(sortedParams);
        this.expr = expr;
        this.onSuccess = onSuccess;
        this.onFailure = onFailure;
        this.disabled = disabled;
    }

    @Schema(description="Rule name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Schema(description="Rule doc")
    @JsonProperty(value="doc")
    public String getDoc() {
        return this.doc;
    }

    @Schema(description="Rule kind")
    @JsonProperty(value="kind")
    public RuleKind getKind() {
        return this.kind;
    }

    @Schema(description="Rule mode")
    @JsonProperty(value="mode")
    public RuleMode getMode() {
        return this.mode;
    }

    @Schema(description="Rule type")
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @Schema(description="The tags to which this rule applies")
    @JsonProperty(value="tags")
    public SortedSet<String> getTags() {
        return this.tags;
    }

    @Schema(description="Optional params for the rule")
    @JsonProperty(value="params")
    public SortedMap<String, String> getParams() {
        return this.params;
    }

    @Schema(description="Rule expression")
    @JsonProperty(value="expr")
    public String getExpr() {
        return this.expr;
    }

    @Schema(description="Rule action on success")
    @JsonProperty(value="onSuccess")
    public String getOnSuccess() {
        return this.onSuccess;
    }

    @Schema(description="Rule action on failure")
    @JsonProperty(value="onFailure")
    public String getOnFailure() {
        return this.onFailure;
    }

    @Schema(description="Whether the rule is disabled")
    @JsonProperty(value="disabled")
    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return Objects.equals(this.name, rule.name) && Objects.equals(this.doc, rule.doc) && this.kind == rule.kind && this.mode == rule.mode && Objects.equals(this.type, rule.type) && Objects.equals(this.tags, rule.tags) && Objects.equals(this.params, rule.params) && Objects.equals(this.expr, rule.expr) && Objects.equals(this.onSuccess, rule.onSuccess) && Objects.equals(this.onFailure, rule.onFailure) && this.disabled == rule.disabled;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.doc, this.kind, this.mode, this.type, this.tags, this.params, this.expr, this.onSuccess, this.onFailure, this.disabled});
    }

    public String toString() {
        return "Rule{name=" + this.name + ", doc=" + this.doc + ", kind=" + (Object)((Object)this.kind) + ", mode=" + (Object)((Object)this.mode) + ", type='" + this.type + '\'' + ", tags='" + this.tags + '\'' + ", params='" + this.params + '\'' + ", expr='" + this.expr + '\'' + ", onSuccess='" + this.onSuccess + '\'' + ", onFailure='" + this.onFailure + '\'' + ", disabled='" + this.disabled + '\'' + '}';
    }

    public void updateHash(MessageDigest md) {
        if (this.name != null) {
            md.update(this.name.getBytes(StandardCharsets.UTF_8));
        }
        if (this.doc != null) {
            md.update(this.doc.getBytes(StandardCharsets.UTF_8));
        }
        if (this.kind != null) {
            md.update(this.kind.name().getBytes(StandardCharsets.UTF_8));
        }
        if (this.mode != null) {
            md.update(this.mode.name().getBytes(StandardCharsets.UTF_8));
        }
        if (this.type != null) {
            md.update(this.type.getBytes(StandardCharsets.UTF_8));
        }
        if (this.tags != null) {
            this.tags.forEach(s2 -> md.update(s2.getBytes(StandardCharsets.UTF_8)));
        }
        if (this.params != null) {
            this.params.forEach((key, value) -> {
                md.update(key.getBytes(StandardCharsets.UTF_8));
                md.update(value.getBytes(StandardCharsets.UTF_8));
            });
        }
        if (this.expr != null) {
            md.update(this.expr.getBytes(StandardCharsets.UTF_8));
        }
        if (this.onSuccess != null) {
            md.update(this.onSuccess.getBytes(StandardCharsets.UTF_8));
        }
        if (this.onFailure != null) {
            md.update(this.onFailure.getBytes(StandardCharsets.UTF_8));
        }
        if (this.disabled) {
            md.update((byte)1);
        }
    }

    public void validate() throws RuleException {
        Rule.validateName(this.name);
        if (this.type == null) {
            throw new RuleException("Missing rule type");
        }
        Rule.validateAction(this.mode, this.onSuccess);
        Rule.validateAction(this.mode, this.onFailure);
    }

    private static void validateName(String name) throws RuleException {
        if (name == null) {
            throw new RuleException("Missing rule name");
        }
        int length = name.length();
        if (length == 0) {
            throw new RuleException("Empty rule name");
        }
        if (length > 64) {
            throw new RuleException("Rule name too long");
        }
        char first = name.charAt(0);
        if (!Character.isLetter(first) && first != '_') {
            throw new RuleException("Illegal initial character in rule name: " + name);
        }
        for (int i = 1; i < length; ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-') continue;
            throw new RuleException("Illegal character in rule name: " + name);
        }
    }

    private static void validateAction(RuleMode mode, String action) throws RuleException {
        if (mode != null && mode != RuleMode.WRITEREAD && mode != RuleMode.UPDOWN && action != null && action.indexOf(44) >= 0) {
            throw new RuleException("Multiple actions only valid with WRITEREAD and UPDOWN");
        }
    }
}

