/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YarnClientUtils {
    private static final Logger LOG = LoggerFactory.getLogger(YarnClientUtils.class);
    private static final Base64 BASE_64_CODEC = new Base64(0);
    private static final String ADD_LABEL_FORMAT_ERR_MSG = "Input format for adding node-labels is not correct, it should be labelName1[(exclusive=true/false)],LabelName2[] ..";
    public static final String NO_LABEL_ERR_MSG = "No cluster node-labels are specified";

    public static String getRmPrincipal(Configuration conf) throws IOException {
        String principal = conf.get("yarn.resourcemanager.principal");
        String prepared = null;
        if (principal != null) {
            prepared = YarnClientUtils.getRmPrincipal(principal, conf);
        }
        return prepared;
    }

    public static String getRmPrincipal(String rmPrincipal, Configuration conf) throws IOException {
        if (rmPrincipal == null) {
            throw new IllegalArgumentException("RM principal string is null");
        }
        if (HAUtil.isHAEnabled(conf)) {
            conf = YarnClientUtils.getYarnConfWithRmHaId(conf);
        }
        String hostname = conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032).getHostName();
        return SecurityUtil.getServerPrincipal((String)rmPrincipal, (String)hostname);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<NodeLabel> buildNodeLabelsFromStr(String args) {
        ArrayList<NodeLabel> nodeLabels = new ArrayList<NodeLabel>();
        for (String p : args.split(",")) {
            if (p.trim().isEmpty()) continue;
            String labelName = p;
            boolean exclusive = true;
            int leftParenthesisIdx = p.indexOf("(");
            int rightParenthesisIdx = p.indexOf(")");
            if (leftParenthesisIdx == -1 && rightParenthesisIdx != -1 || leftParenthesisIdx != -1 && rightParenthesisIdx == -1) {
                throw new IllegalArgumentException(ADD_LABEL_FORMAT_ERR_MSG);
            }
            if (leftParenthesisIdx > 0 && rightParenthesisIdx > 0) {
                if (leftParenthesisIdx > rightParenthesisIdx) {
                    throw new IllegalArgumentException(ADD_LABEL_FORMAT_ERR_MSG);
                }
                String property = p.substring(p.indexOf("(") + 1, p.indexOf(")"));
                if (property.contains("=")) {
                    String key = property.substring(0, property.indexOf("=")).trim();
                    String value = property.substring(property.indexOf("=") + 1, property.length()).trim();
                    if (!"exclusive".equals(key) || !ImmutableSet.of("true", "false").contains(value)) throw new IllegalArgumentException(ADD_LABEL_FORMAT_ERR_MSG);
                    exclusive = Boolean.parseBoolean(value);
                } else if (!property.trim().isEmpty()) {
                    throw new IllegalArgumentException(ADD_LABEL_FORMAT_ERR_MSG);
                }
            }
            if (labelName.contains("(")) {
                labelName = labelName.substring(0, labelName.indexOf("(")).trim();
            }
            nodeLabels.add(NodeLabel.newInstance(labelName, exclusive));
        }
        if (!nodeLabels.isEmpty()) return nodeLabels;
        throw new IllegalArgumentException(NO_LABEL_ERR_MSG);
    }

    @VisibleForTesting
    static YarnConfiguration getYarnConfWithRmHaId(Configuration conf) throws IOException {
        YarnConfiguration yarnConf = new YarnConfiguration(conf);
        if (yarnConf.get("yarn.resourcemanager.ha.id") == null) {
            String[] rmIds = yarnConf.getStrings("yarn.resourcemanager.ha.rm-ids");
            if (rmIds != null && rmIds.length > 0) {
                yarnConf.set("yarn.resourcemanager.ha.id", rmIds[0]);
            } else {
                throw new IOException("RM_HA_IDS property is not set for HA resource manager");
            }
        }
        return yarnConf;
    }

    public static String generateToken(final String server) throws IOException, InterruptedException {
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        LOG.debug("The user credential is {}", (Object)currentUser);
        String challenge = (String)currentUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                try {
                    GSSManager manager = GSSManager.getInstance();
                    GSSName serverName = manager.createName("HTTP@" + server, GSSName.NT_HOSTBASED_SERVICE);
                    GSSContext gssContext = manager.createContext(serverName.canonicalize(null), null, null, 0);
                    gssContext.requestMutualAuth(true);
                    gssContext.requestCredDeleg(true);
                    byte[] inToken = new byte[]{};
                    byte[] outToken = gssContext.initSecContext(inToken, 0, inToken.length);
                    gssContext.dispose();
                    LOG.debug("Got valid challenge for host {}", (Object)serverName);
                    return new String(BASE_64_CODEC.encode(outToken), StandardCharsets.US_ASCII);
                }
                catch (GSSException e) {
                    LOG.error("Error: ", e);
                    throw new AuthenticationException(e);
                }
            }
        });
        return challenge;
    }

    public static boolean isYarnFederationEnabled(Configuration conf) {
        boolean isEnabled = conf.getBoolean("yarn.federation.enabled", false);
        return isEnabled;
    }
}

