/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Collection;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRowDynBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class VectorReduceSinkOperator
extends ReduceSinkOperator {
    private static final long serialVersionUID = 1L;
    private VectorizationContext vContext;
    private transient boolean firstBatch;
    private transient VectorExtractRowDynBatch vectorExtractRowDynBatch;
    protected transient Object[] singleRow;

    public VectorReduceSinkOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        this();
        ReduceSinkDesc desc = (ReduceSinkDesc)conf;
        this.conf = desc;
        this.vContext = vContext;
    }

    public VectorReduceSinkOperator() {
    }

    @Override
    protected Collection<Future<?>> initializeOp(Configuration hconf) throws HiveException {
        this.inputObjInspectors[0] = VectorizedBatchUtil.convertToStandardStructObjectInspector((StructObjectInspector)this.inputObjInspectors[0]);
        Collection<Future<?>> result = super.initializeOp(hconf);
        assert (result.isEmpty());
        this.firstBatch = true;
        return result;
    }

    @Override
    public void process(Object data, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)data;
        if (this.firstBatch) {
            this.vectorExtractRowDynBatch = new VectorExtractRowDynBatch();
            this.vectorExtractRowDynBatch.init((StructObjectInspector)this.inputObjInspectors[0], this.vContext.getProjectedColumns());
            this.singleRow = new Object[this.vectorExtractRowDynBatch.getCount()];
            this.firstBatch = false;
        }
        this.vectorExtractRowDynBatch.setBatchOnEntry(batch);
        if (batch.selectedInUse) {
            int[] selected = batch.selected;
            for (int logical = 0; logical < batch.size; ++logical) {
                int batchIndex = selected[logical];
                this.vectorExtractRowDynBatch.extractRow(batchIndex, this.singleRow);
                super.process(this.singleRow, tag);
            }
        } else {
            for (int batchIndex = 0; batchIndex < batch.size; ++batchIndex) {
                this.vectorExtractRowDynBatch.extractRow(batchIndex, this.singleRow);
                super.process(this.singleRow, tag);
            }
        }
        this.vectorExtractRowDynBatch.forgetBatchOnExit();
    }
}

