/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metanalysis;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import org.apache.accumulo.server.logger.LogFileKey;
import org.apache.accumulo.server.logger.LogFileValue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class LogFileInputFormat
extends FileInputFormat<LogFileKey, LogFileValue> {
    public RecordReader<LogFileKey, LogFileValue> createRecordReader(InputSplit arg0, TaskAttemptContext arg1) throws IOException, InterruptedException {
        return new LogFileRecordReader();
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        return false;
    }

    private static class LogFileRecordReader
    extends RecordReader<LogFileKey, LogFileValue> {
        private FSDataInputStream fsdis;
        private LogFileKey key;
        private LogFileValue value;
        private long length;

        private LogFileRecordReader() {
        }

        public void close() throws IOException {
            this.fsdis.close();
        }

        public LogFileKey getCurrentKey() throws IOException, InterruptedException {
            return this.key;
        }

        public LogFileValue getCurrentValue() throws IOException, InterruptedException {
            return this.value;
        }

        public float getProgress() throws IOException, InterruptedException {
            float progress = (float)(this.length - this.fsdis.getPos()) / (float)this.length;
            if (progress < 0.0f) {
                return 0.0f;
            }
            return progress;
        }

        public void initialize(InputSplit is, TaskAttemptContext context) throws IOException, InterruptedException {
            FileSplit fileSplit = (FileSplit)is;
            Configuration conf = new Configuration();
            FileSystem fs = FileSystem.get((Configuration)conf);
            this.key = new LogFileKey();
            this.value = new LogFileValue();
            this.fsdis = fs.open(fileSplit.getPath());
            FileStatus status = fs.getFileStatus(fileSplit.getPath());
            this.length = status.getLen();
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (this.key == null) {
                return false;
            }
            try {
                this.key.readFields((DataInput)this.fsdis);
                this.value.readFields((DataInput)this.fsdis);
                return true;
            }
            catch (EOFException ex) {
                this.key = null;
                this.value = null;
                return false;
            }
        }
    }
}

