/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.state.tables.TableManager;
import org.apache.accumulo.server.master.tableOps.CreateDir;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.TableInfo;
import org.apache.accumulo.server.master.tableOps.Utils;
import org.apache.accumulo.server.util.TablePropUtil;

class PopulateZookeeper
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private TableInfo tableInfo;

    PopulateZookeeper(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveTable(this.tableInfo.tableId, tid, true, false, TableOperation.CREATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Utils.tableNameLock.lock();
        try {
            Instance instance = master.getInstance();
            Utils.checkTableDoesNotExist(instance, this.tableInfo.tableName, this.tableInfo.tableId, TableOperation.CREATE);
            TableManager.getInstance().addTable(this.tableInfo.tableId, this.tableInfo.tableName, ZooUtil.NodeExistsPolicy.OVERWRITE);
            for (Map.Entry<String, String> entry : this.tableInfo.props.entrySet()) {
                TablePropUtil.setTableProperty(this.tableInfo.tableId, entry.getKey(), entry.getValue());
            }
            Tables.clearCache((Instance)instance);
            CreateDir createDir = new CreateDir(this.tableInfo);
            return createDir;
        }
        finally {
            Utils.tableNameLock.unlock();
        }
    }

    @Override
    public void undo(long tid, Master master) throws Exception {
        Instance instance = master.getInstance();
        TableManager.getInstance().removeTable(this.tableInfo.tableId);
        Utils.unreserveTable(this.tableInfo.tableId, tid, true);
        Tables.clearCache((Instance)instance);
    }
}

