/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.FinishCancelCompaction;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.Utils;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;

public class CancelCompactions
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private String tableId;

    public CancelCompactions(String tableId) {
        this.tableId = tableId;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveTable(this.tableId, tid, false, true, TableOperation.COMPACT_CANCEL);
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        String zCompactID = "/accumulo/" + HdfsZooInstance.getInstance().getInstanceID() + "/tables" + "/" + this.tableId + "/compact-id";
        String zCancelID = "/accumulo/" + HdfsZooInstance.getInstance().getInstanceID() + "/tables" + "/" + this.tableId + "/compact-cancel-id";
        IZooReaderWriter zoo = ZooReaderWriter.getRetryingInstance();
        byte[] currentValue = zoo.getData(zCompactID, null);
        String cvs = new String(currentValue);
        String[] tokens = cvs.split(",");
        final long flushID = Long.parseLong(new String(tokens[0]));
        zoo.mutate(zCancelID, null, null, new ZooReaderWriter.Mutator(){

            public byte[] mutate(byte[] currentValue) throws Exception {
                long cid = Long.parseLong(new String(currentValue));
                if (cid < flushID) {
                    return (flushID + "").getBytes();
                }
                return (cid + "").getBytes();
            }
        });
        return new FinishCancelCompaction(this.tableId);
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        Utils.unreserveTable(this.tableId, tid, false);
    }
}

