/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.logger;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.file.FileUtil;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.logger.LogEvents;
import org.apache.accumulo.server.logger.LogFileKey;
import org.apache.accumulo.server.logger.LogFileValue;
import org.apache.accumulo.server.tabletserver.log.DfsLogger;
import org.apache.accumulo.server.tabletserver.log.MultiReader;
import org.apache.accumulo.server.trace.TraceFileSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class LogReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Opts opts = new Opts();
        opts.parseArgs(LogReader.class.getName(), args, new Object[0]);
        Configuration conf = CachedConfiguration.getInstance();
        FileSystem fs = TraceFileSystem.wrap(FileUtil.getFileSystem((Configuration)conf, (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration()));
        FileSystem local = TraceFileSystem.wrap((FileSystem)FileSystem.getLocal((Configuration)conf));
        Matcher rowMatcher = null;
        KeyExtent ke = null;
        Text row = null;
        if (opts.files.isEmpty()) {
            new JCommander((Object)opts).usage();
            return;
        }
        if (opts.row != null) {
            row = new Text(opts.row);
        }
        if (opts.extent != null) {
            String[] sa = opts.extent.split(";");
            ke = new KeyExtent(new Text(sa[0]), new Text(sa[1]), new Text(sa[2]));
        }
        if (opts.regexp != null) {
            Pattern pattern = Pattern.compile(opts.regexp);
            rowMatcher = pattern.matcher("");
        }
        HashSet<Integer> tabletIds = new HashSet<Integer>();
        block10: for (String file : opts.files) {
            FSDataInputStream f;
            HashMap<String, String> meta = new HashMap<String, String>();
            Path path = new Path(file);
            LogFileKey key = new LogFileKey();
            LogFileValue value = new LogFileValue();
            if (fs.isFile(path)) {
                f = DfsLogger.readHeader(fs, path, meta);
                try {
                    while (true) {
                        try {
                            key.readFields((DataInput)f);
                            value.readFields((DataInput)f);
                        }
                        catch (EOFException ex) {
                            continue block10;
                        }
                        LogReader.printLogEvent(key, value, row, rowMatcher, ke, tabletIds, opts.maxMutations);
                    }
                }
                finally {
                    f.close();
                    continue;
                }
            }
            if (local.isFile(path)) {
                f = DfsLogger.readHeader(fs, path, meta);
                try {
                    while (true) {
                        try {
                            key.readFields((DataInput)f);
                            value.readFields((DataInput)f);
                        }
                        catch (EOFException ex) {
                            continue block10;
                        }
                        LogReader.printLogEvent(key, value, row, rowMatcher, ke, tabletIds, opts.maxMutations);
                    }
                }
                finally {
                    f.close();
                    continue;
                }
            }
            MultiReader input = new MultiReader(fs, conf, file);
            while (input.next(key, value)) {
                LogReader.printLogEvent(key, value, row, rowMatcher, ke, tabletIds, opts.maxMutations);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void printLogEvent(LogFileKey key, LogFileValue value, Text row, Matcher rowMatcher, KeyExtent ke, Set<Integer> tabletIds, int maxMutations) {
        if (ke != null) {
            if (key.event == LogEvents.DEFINE_TABLET) {
                if (!key.tablet.equals((Object)ke)) return;
                tabletIds.add(key.tid);
            } else if (!tabletIds.contains(key.tid)) {
                return;
            }
        }
        if (row != null || rowMatcher != null) {
            if (key.event != LogEvents.MUTATION && key.event != LogEvents.MANY_MUTATIONS) return;
            boolean found = false;
            for (Mutation m : value.mutations) {
                if (row != null && new Text(m.getRow()).equals((Object)row)) {
                    found = true;
                    break;
                }
                if (rowMatcher == null) continue;
                rowMatcher.reset(new String(m.getRow()));
                if (!rowMatcher.matches()) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
        }
        System.out.println(key);
        System.out.println(LogFileValue.format(value, maxMutations));
    }

    static class Opts
    extends Help {
        @Parameter(names={"-r"}, description="print only mutations associated with the given row")
        String row;
        @Parameter(names={"-m"}, description="limit the number of mutations printed per row")
        int maxMutations = 5;
        @Parameter(names={"-t"}, description="print only mutations that fall within the given key extent")
        String extent;
        @Parameter(names={"-p"}, description="search for a row that matches the given regex")
        String regexp;
        @Parameter(description="<logfile> { <logfile> ... }")
        List<String> files = new ArrayList<String>();

        Opts() {
        }
    }
}

