/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public class PigAvroDatumWriter
extends GenericDatumWriter<Object> {
    public PigAvroDatumWriter(Schema schema) {
        this.setSchema(schema);
    }

    protected void write(Schema schema, Object datum, Encoder out) throws IOException {
        try {
            if (!schema.getType().equals((Object)Schema.Type.RECORD) && !schema.getType().equals((Object)Schema.Type.UNION) && datum instanceof Tuple && this.unwrappedInstanceOf(schema, datum)) {
                Tuple t = (Tuple)datum;
                if (t.size() > 1) {
                    throw new IOException("Incompatible schema:" + schema + " \n for data " + datum);
                }
                this.write(schema, t.get(0), out);
                return;
            }
            switch (schema.getType()) {
                case FIXED: {
                    this.writeFixed(schema, datum, out);
                    break;
                }
                case ENUM: {
                    this.writeEnum(schema, datum, out);
                    break;
                }
                case STRING: {
                    this.writeString(schema, datum, out);
                    break;
                }
                case BYTES: {
                    this.writeBytes(datum, out);
                    break;
                }
                case BOOLEAN: {
                    this.writeBoolean(datum, out);
                    break;
                }
                case UNION: {
                    this.writeUnion(schema, datum, out);
                    break;
                }
                case LONG: {
                    this.writeLong(datum, out);
                    break;
                }
                case FLOAT: {
                    this.writeFloat(datum, out);
                    break;
                }
                case DOUBLE: {
                    this.writeDouble(datum, out);
                    break;
                }
                default: {
                    super.write(schema, datum, out);
                    break;
                }
            }
        }
        catch (NullPointerException e) {
            throw this.npe(e, " of " + schema.getName());
        }
    }

    protected void writeUnion(Schema schema, Object datum, Encoder out) throws IOException {
        int index = this.resolveUnionSchema(schema, datum);
        out.writeIndex(index);
        this.write((Schema)schema.getTypes().get(index), datum, out);
    }

    protected int resolveUnionSchema(Schema union, Object datum) throws IOException {
        int i = 0;
        for (Schema type : union.getTypes()) {
            if (type.getType().equals((Object)Schema.Type.UNION)) {
                throw new IOException("A union cannot immediately contain other unions.");
            }
            if (this.instanceOf(type, datum)) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("Datum " + datum + " is not in union " + union);
    }

    protected boolean instanceOf(Schema schema, Object datum) throws IOException {
        try {
            switch (schema.getType()) {
                case RECORD: {
                    if (datum instanceof Tuple) {
                        Tuple tuple = (Tuple)datum;
                        List fields = schema.getFields();
                        if (fields.size() != tuple.size()) {
                            return false;
                        }
                        for (int i = 0; i < fields.size(); ++i) {
                            if (this.instanceOf(((Schema.Field)fields.get(i)).schema(), tuple.get(i))) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                case UNION: {
                    int index = this.resolveUnionSchema(schema, datum);
                    return true;
                }
                case ENUM: {
                    return datum instanceof String && schema.hasEnumSymbol((String)datum) || this.unwrappedInstanceOf(schema, datum);
                }
                case ARRAY: {
                    return datum instanceof DataBag || this.unwrappedInstanceOf(schema, datum);
                }
                case MAP: {
                    return datum instanceof Map || this.unwrappedInstanceOf(schema, datum);
                }
                case FIXED: {
                    return datum instanceof DataByteArray && ((DataByteArray)datum).size() == schema.getFixedSize() || this.unwrappedInstanceOf(schema, datum);
                }
                case STRING: {
                    return datum instanceof String || this.unwrappedInstanceOf(schema, datum);
                }
                case BYTES: {
                    return datum instanceof DataByteArray || this.unwrappedInstanceOf(schema, datum);
                }
                case INT: {
                    return datum instanceof Integer || this.unwrappedInstanceOf(schema, datum);
                }
                case LONG: {
                    return datum instanceof Long || datum instanceof Integer || this.unwrappedInstanceOf(schema, datum);
                }
                case FLOAT: {
                    return datum instanceof Float || datum instanceof Integer || datum instanceof Long || this.unwrappedInstanceOf(schema, datum);
                }
                case DOUBLE: {
                    return datum instanceof Double || datum instanceof Float || datum instanceof Integer || datum instanceof Long || this.unwrappedInstanceOf(schema, datum);
                }
                case BOOLEAN: {
                    return datum instanceof Boolean || datum instanceof Integer || this.unwrappedInstanceOf(schema, datum);
                }
                case NULL: {
                    return datum == null;
                }
            }
            throw new RuntimeException("Unexpected type: " + schema);
        }
        catch (ExecException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    private boolean unwrappedInstanceOf(Schema schema, Object datum) throws IOException {
        try {
            if (!(datum instanceof Tuple)) {
                return false;
            }
            Tuple tuple = (Tuple)datum;
            if (tuple.size() != 1) {
                return false;
            }
            switch (schema.getType()) {
                case FIXED: 
                case ENUM: 
                case STRING: 
                case BYTES: 
                case BOOLEAN: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case ARRAY: 
                case MAP: 
                case INT: {
                    return this.instanceOf(schema, tuple.get(0));
                }
            }
            throw new IOException("Invalid type:" + schema.getType());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new IOException(e);
        }
    }

    protected void writeDouble(Object datum, Encoder out) throws IOException {
        double num;
        if (datum instanceof Integer) {
            num = ((Integer)datum).doubleValue();
        } else if (datum instanceof Long) {
            num = ((Long)datum).doubleValue();
        } else if (datum instanceof Float) {
            num = ((Float)datum).doubleValue();
        } else if (datum instanceof Double) {
            num = (Double)datum;
        } else {
            throw new IOException("Cannot convert to double:" + datum.getClass());
        }
        out.writeDouble(num);
    }

    protected void writeFloat(Object datum, Encoder out) throws IOException {
        float num;
        if (datum instanceof Integer) {
            num = ((Integer)datum).floatValue();
        } else if (datum instanceof Long) {
            num = ((Long)datum).floatValue();
        } else if (datum instanceof Float) {
            num = ((Float)datum).floatValue();
        } else {
            throw new IOException("Cannot convert to float:" + datum.getClass());
        }
        out.writeFloat(num);
    }

    protected void writeLong(Object datum, Encoder out) throws IOException {
        long num;
        if (datum instanceof Integer) {
            num = ((Integer)datum).longValue();
        } else if (datum instanceof Long) {
            num = (Long)datum;
        } else {
            throw new IOException("Cannot convert to long:" + datum.getClass());
        }
        out.writeLong(num);
    }

    protected void writeBoolean(Object datum, Encoder out) throws IOException {
        if (datum instanceof Boolean) {
            out.writeBoolean(((Boolean)datum).booleanValue());
        } else if (datum instanceof Integer) {
            out.writeBoolean((Integer)datum != 0);
        } else {
            throw new RuntimeException("Unsupported type boolean:" + datum.getClass());
        }
    }

    protected NullPointerException npe(NullPointerException e, String s) {
        NullPointerException result = new NullPointerException(e.getMessage() + s);
        result.initCause(e.getCause() == null ? e : e.getCause());
        return result;
    }

    protected void writeBytes(Object datum, Encoder out) throws IOException {
        if (!(datum instanceof DataByteArray)) {
            throw new RuntimeException("Unsupported type bytes:" + datum.getClass());
        }
        out.writeBytes(((DataByteArray)datum).get());
    }

    protected void writeFixed(Schema schema, Object datum, Encoder out) throws IOException {
        if (!(datum instanceof DataByteArray)) {
            throw new RuntimeException("Unsupported type fixed:" + datum.getClass());
        }
        byte[] bytes = ((DataByteArray)datum).get();
        out.writeFixed(bytes, 0, bytes.length);
    }

    protected void writeRecord(Schema schema, Object datum, Encoder out) throws IOException {
        for (Schema.Field f : schema.getFields()) {
            Object value = this.getField(datum, f.name(), f.pos());
            try {
                this.write(f.schema(), value, out);
            }
            catch (NullPointerException e) {
                throw this.npe(e, " in field " + f.name());
            }
        }
    }

    protected Object getField(Object record, String name, int pos) {
        if (record instanceof Tuple) {
            try {
                return ((Tuple)record).get(pos);
            }
            catch (ExecException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Unsupported type in record:" + record.getClass());
    }

    protected long getArraySize(Object array) {
        if (array instanceof DataBag) {
            return ((DataBag)array).size();
        }
        throw new RuntimeException("Unsupported type in array:" + array.getClass());
    }

    protected Iterator<? extends Object> getArrayElements(Object array) {
        if (array instanceof DataBag) {
            return ((DataBag)array).iterator();
        }
        throw new RuntimeException("Unsupported type in array:" + array.getClass());
    }
}

