/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.DelimitedKeyPrefixRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.IncreasingToUpperBoundRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.KeyPrefixRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRegionSplitPolicy {
    private Configuration conf;
    private HTableDescriptor htd;
    private HRegion mockRegion;
    private List<Store> stores;
    private static final TableName TABLENAME = TableName.valueOf((String)"t");

    @Before
    public void setupMocks() {
        this.conf = HBaseConfiguration.create();
        HRegionInfo hri = new HRegionInfo(TABLENAME);
        this.htd = new HTableDescriptor(TABLENAME);
        this.mockRegion = (HRegion)Mockito.mock(HRegion.class);
        ((HRegion)Mockito.doReturn((Object)this.htd).when((Object)this.mockRegion)).getTableDesc();
        ((HRegion)Mockito.doReturn((Object)hri).when((Object)this.mockRegion)).getRegionInfo();
        this.stores = new ArrayList<Store>();
        ((HRegion)Mockito.doReturn(this.stores).when((Object)this.mockRegion)).getStores();
    }

    @Test
    public void testForceSplitRegionWithReference() throws IOException {
        this.htd.setMaxFileSize(1024L);
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)false).when((Object)mockStore)).canSplit();
        this.stores.add((Store)mockStore);
        this.conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        ConstantSizeRegionSplitPolicy policy = (ConstantSizeRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        Assert.assertFalse((boolean)policy.shouldSplit());
        ((HRegion)Mockito.doReturn((Object)true).when((Object)this.mockRegion)).shouldForceSplit();
        Assert.assertFalse((boolean)policy.shouldSplit());
        ((HRegion)Mockito.doReturn((Object)false).when((Object)this.mockRegion)).shouldForceSplit();
        this.conf.set("hbase.regionserver.region.split.policy", IncreasingToUpperBoundRegionSplitPolicy.class.getName());
        policy = (IncreasingToUpperBoundRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        Assert.assertFalse((boolean)policy.shouldSplit());
        ((HRegion)Mockito.doReturn((Object)true).when((Object)this.mockRegion)).shouldForceSplit();
        Assert.assertFalse((boolean)policy.shouldSplit());
    }

    @Test
    public void testIncreasingToUpperBoundRegionSplitPolicy() throws IOException {
        this.conf.set("hbase.regionserver.region.split.policy", IncreasingToUpperBoundRegionSplitPolicy.class.getName());
        RegionServerServices rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        ArrayList<HRegion> regions = new ArrayList<HRegion>();
        Mockito.when((Object)rss.getOnlineRegions(TABLENAME)).thenReturn(regions);
        Mockito.when((Object)this.mockRegion.getRegionServerServices()).thenReturn((Object)rss);
        long maxSplitSize = 1024L;
        this.htd.setMaxFileSize(maxSplitSize);
        long flushSize = maxSplitSize / 8L;
        this.conf.setLong("hbase.hregion.memstore.flush.size", flushSize);
        this.htd.setMemStoreFlushSize(flushSize);
        IncreasingToUpperBoundRegionSplitPolicy policy = (IncreasingToUpperBoundRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        this.doConstantSizePolicyTests((ConstantSizeRegionSplitPolicy)policy);
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        this.stores.add((Store)mockStore);
        Assert.assertTrue((boolean)policy.shouldSplit());
        regions.add(this.mockRegion);
        ((HStore)Mockito.doReturn((Object)flushSize).when((Object)mockStore)).getSize();
        Assert.assertFalse((boolean)policy.shouldSplit());
        ((HStore)Mockito.doReturn((Object)(flushSize * 2L + 1L)).when((Object)mockStore)).getSize();
        Assert.assertTrue((boolean)policy.shouldSplit());
        regions.add(this.mockRegion);
        Assert.assertFalse((boolean)policy.shouldSplit());
        ((HStore)Mockito.doReturn((Object)((long)((double)maxSplitSize * 1.25 + 1.0))).when((Object)mockStore)).getSize();
        Assert.assertTrue((boolean)policy.shouldSplit());
        this.assertWithinJitter(maxSplitSize, policy.getSizeToCheck(1000));
        this.assertWithinJitter(maxSplitSize, policy.getSizeToCheck(0));
    }

    private void assertWithinJitter(long maxSplitSize, long sizeToCheck) {
        Assert.assertTrue((String)"Size greater than lower bound of jitter", ((long)((double)maxSplitSize * 0.75) <= sizeToCheck ? 1 : 0) != 0);
        Assert.assertTrue((String)"Size less than upper bound of jitter", ((long)((double)maxSplitSize * 1.25) >= sizeToCheck ? 1 : 0) != 0);
    }

    @Test
    public void testCreateDefault() throws IOException {
        this.conf.setLong("hbase.hregion.max.filesize", 1234L);
        ConstantSizeRegionSplitPolicy policy = (ConstantSizeRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        this.assertWithinJitter(1234L, policy.getDesiredMaxFileSize());
        this.htd.setMaxFileSize(9999L);
        policy = (ConstantSizeRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        this.assertWithinJitter(9999L, policy.getDesiredMaxFileSize());
    }

    @Test
    public void testCustomPolicy() throws IOException {
        HTableDescriptor myHtd = new HTableDescriptor();
        myHtd.setValue("SPLIT_POLICY", KeyPrefixRegionSplitPolicy.class.getName());
        myHtd.setValue("KeyPrefixRegionSplitPolicy.prefix_length", String.valueOf(2));
        HRegion myMockRegion = (HRegion)Mockito.mock(HRegion.class);
        ((HRegion)Mockito.doReturn((Object)myHtd).when((Object)myMockRegion)).getTableDesc();
        ((HRegion)Mockito.doReturn(this.stores).when((Object)myMockRegion)).getStores();
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        ((HStore)Mockito.doReturn((Object)Bytes.toBytes((String)"abcd")).when((Object)mockStore)).getSplitPoint();
        this.stores.add((Store)mockStore);
        KeyPrefixRegionSplitPolicy policy = (KeyPrefixRegionSplitPolicy)RegionSplitPolicy.create((HRegion)myMockRegion, (Configuration)this.conf);
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])policy.getSplitPoint()));
        ((HRegion)Mockito.doReturn((Object)true).when((Object)myMockRegion)).shouldForceSplit();
        ((HRegion)Mockito.doReturn((Object)Bytes.toBytes((String)"efgh")).when((Object)myMockRegion)).getExplicitSplitPoint();
        policy = (KeyPrefixRegionSplitPolicy)RegionSplitPolicy.create((HRegion)myMockRegion, (Configuration)this.conf);
        Assert.assertEquals((Object)"ef", (Object)Bytes.toString((byte[])policy.getSplitPoint()));
    }

    @Test
    public void testConstantSizePolicy() throws IOException {
        this.htd.setMaxFileSize(1024L);
        ConstantSizeRegionSplitPolicy policy = (ConstantSizeRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        this.doConstantSizePolicyTests(policy);
    }

    private void doConstantSizePolicyTests(ConstantSizeRegionSplitPolicy policy) {
        Assert.assertFalse((boolean)policy.shouldSplit());
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        this.stores.add((Store)mockStore);
        Assert.assertTrue((boolean)policy.shouldSplit());
        ((HStore)Mockito.doReturn((Object)false).when((Object)mockStore)).canSplit();
        Assert.assertFalse((boolean)policy.shouldSplit());
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        ((HRegion)Mockito.doReturn((Object)true).when((Object)this.mockRegion)).shouldForceSplit();
        ((HStore)Mockito.doReturn((Object)100L).when((Object)mockStore)).getSize();
        Assert.assertTrue((boolean)policy.shouldSplit());
        ((HRegion)Mockito.doReturn((Object)false).when((Object)this.mockRegion)).shouldForceSplit();
        Assert.assertFalse((boolean)policy.shouldSplit());
        this.stores.clear();
    }

    @Test
    public void testGetSplitPoint() throws IOException {
        ConstantSizeRegionSplitPolicy policy = (ConstantSizeRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        Assert.assertFalse((boolean)policy.shouldSplit());
        Assert.assertNull((Object)policy.getSplitPoint());
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        ((HStore)Mockito.doReturn((Object)Bytes.toBytes((String)"store 1 split")).when((Object)mockStore)).getSplitPoint();
        this.stores.add((Store)mockStore);
        Assert.assertEquals((Object)"store 1 split", (Object)Bytes.toString((byte[])policy.getSplitPoint()));
        HStore mockStore2 = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)4000L).when((Object)mockStore2)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore2)).canSplit();
        ((HStore)Mockito.doReturn((Object)Bytes.toBytes((String)"store 2 split")).when((Object)mockStore2)).getSplitPoint();
        this.stores.add((Store)mockStore2);
        Assert.assertEquals((Object)"store 2 split", (Object)Bytes.toString((byte[])policy.getSplitPoint()));
    }

    @Test
    public void testDelimitedKeyPrefixRegionSplitPolicy() throws IOException {
        HTableDescriptor myHtd = new HTableDescriptor();
        myHtd.setValue("SPLIT_POLICY", DelimitedKeyPrefixRegionSplitPolicy.class.getName());
        myHtd.setValue("DelimitedKeyPrefixRegionSplitPolicy.delimiter", ",");
        HRegion myMockRegion = (HRegion)Mockito.mock(HRegion.class);
        ((HRegion)Mockito.doReturn((Object)myHtd).when((Object)myMockRegion)).getTableDesc();
        ((HRegion)Mockito.doReturn(this.stores).when((Object)myMockRegion)).getStores();
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        ((HStore)Mockito.doReturn((Object)Bytes.toBytes((String)"ab,cd")).when((Object)mockStore)).getSplitPoint();
        this.stores.add((Store)mockStore);
        DelimitedKeyPrefixRegionSplitPolicy policy = (DelimitedKeyPrefixRegionSplitPolicy)RegionSplitPolicy.create((HRegion)myMockRegion, (Configuration)this.conf);
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])policy.getSplitPoint()));
        ((HRegion)Mockito.doReturn((Object)true).when((Object)myMockRegion)).shouldForceSplit();
        ((HRegion)Mockito.doReturn((Object)Bytes.toBytes((String)"efg,h")).when((Object)myMockRegion)).getExplicitSplitPoint();
        policy = (DelimitedKeyPrefixRegionSplitPolicy)RegionSplitPolicy.create((HRegion)myMockRegion, (Configuration)this.conf);
        Assert.assertEquals((Object)"efg", (Object)Bytes.toString((byte[])policy.getSplitPoint()));
        ((HRegion)Mockito.doReturn((Object)Bytes.toBytes((String)"ijk")).when((Object)myMockRegion)).getExplicitSplitPoint();
        Assert.assertEquals((Object)"ijk", (Object)Bytes.toString((byte[])policy.getSplitPoint()));
    }
}

