/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public abstract class TestConfigurationFieldsBase {
    protected String xmlFilename = null;
    protected Class[] configurationClasses = null;
    protected boolean errorIfMissingConfigProps = false;
    protected boolean errorIfMissingXmlProps = false;
    protected Set<String> configurationPropsToSkipCompare = null;
    protected Set<String> configurationPrefixToSkipCompare = null;
    protected Set<String> xmlPropsToSkipCompare = null;
    protected Set<String> xmlPrefixToSkipCompare = null;
    private Map<String, String> configurationMemberVariables = null;
    private Map<String, String> configurationDefaultVariables = null;
    private Map<String, String> xmlKeyValueMap = null;
    private Set<String> configurationFieldsMissingInXmlFile = null;
    private Set<String> xmlFieldsMissingInConfiguration = null;
    protected Set<String> filtersForDefaultValueCollisionCheck = new HashSet<String>();
    protected boolean configDebug = false;
    protected boolean xmlDebug = false;
    protected boolean defaultDebug = false;

    public abstract void initializeMemberVariables();

    private HashMap<String, String> extractMemberVariablesFromConfigurationFields(Field[] fields) {
        if (fields == null) {
            return null;
        }
        HashMap<String, String> retVal = new HashMap<String, String>();
        String propRegex = "^[A-Za-z][A-Za-z0-9_-]+(\\.[A-Za-z0-9_-]+)+$";
        Pattern p = Pattern.compile(propRegex);
        boolean totalFields = false;
        for (Field f : fields) {
            String value;
            if (this.configDebug) {
                System.out.println("Field: " + f);
            }
            if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !f.getType().getName().equals("java.lang.String") || TestConfigurationFieldsBase.isFieldADefaultValue(f)) continue;
            try {
                value = (String)f.get(null);
            }
            catch (IllegalAccessException iaException) {
                continue;
            }
            if (this.configDebug) {
                System.out.println("  Value: " + value);
            }
            if (value.endsWith(".xml") || value.endsWith(".") || value.endsWith("-") || this.configurationPropsToSkipCompare != null && this.configurationPropsToSkipCompare.contains(value)) continue;
            boolean skipPrefix = false;
            if (this.configurationPrefixToSkipCompare != null) {
                for (String cfgPrefix : this.configurationPrefixToSkipCompare) {
                    if (!value.startsWith(cfgPrefix)) continue;
                    skipPrefix = true;
                    break;
                }
            }
            if (skipPrefix) continue;
            Matcher m = p.matcher(value);
            if (!m.find()) {
                if (!this.configDebug) continue;
                System.out.println("  Passes Regex: false");
                continue;
            }
            if (this.configDebug) {
                System.out.println("  Passes Regex: true");
            }
            if (!retVal.containsKey(value)) {
                retVal.put(value, f.getName());
                continue;
            }
            if (!this.configDebug) continue;
            System.out.println("ERROR: Already found key for property " + value);
        }
        return retVal;
    }

    private HashMap<String, String> extractPropertiesFromXml(String filename) {
        if (filename == null) {
            return null;
        }
        Configuration conf = new Configuration(false);
        conf.setAllowNullValueProperties(true);
        conf.addResource(filename);
        HashMap<String, String> retVal = new HashMap<String, String>();
        Iterator kvItr = conf.iterator();
        while (kvItr.hasNext()) {
            Map.Entry entry = (Map.Entry)kvItr.next();
            String key = (String)entry.getKey();
            if (this.xmlPropsToSkipCompare != null && this.xmlPropsToSkipCompare.contains(key)) {
                if (!this.xmlDebug) continue;
                System.out.println("  Skipping Full Key: " + key);
                continue;
            }
            boolean skipPrefix = false;
            if (this.xmlPrefixToSkipCompare != null) {
                for (String xmlPrefix : this.xmlPrefixToSkipCompare) {
                    if (!key.startsWith(xmlPrefix)) continue;
                    skipPrefix = true;
                    break;
                }
            }
            if (skipPrefix) {
                if (!this.xmlDebug) continue;
                System.out.println("  Skipping Prefix Key: " + key);
                continue;
            }
            if (conf.onlyKeyExists(key)) {
                retVal.put(key, null);
                if (this.xmlDebug) {
                    System.out.println("  XML Key,Null Value: " + key);
                }
            } else {
                String value = conf.get(key);
                if (value != null) {
                    retVal.put(key, (String)entry.getValue());
                    if (this.xmlDebug) {
                        System.out.println("  XML Key,Valid Value: " + key);
                    }
                }
            }
            kvItr.remove();
        }
        return retVal;
    }

    private static boolean isFieldADefaultValue(Field field) {
        return field.getName().startsWith("DEFAULT_") || field.getName().endsWith("_DEFAULT");
    }

    private HashMap<String, String> extractDefaultVariablesFromConfigurationFields(Field[] fields) {
        if (fields == null) {
            return null;
        }
        HashMap<String, String> retVal = new HashMap<String, String>();
        String propRegex = "^[A-Za-z][A-Za-z0-9_-]+(\\.[A-Za-z0-9_-]+)+$";
        Pattern p = Pattern.compile(propRegex);
        boolean totalFields = false;
        for (Field f : fields) {
            if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !TestConfigurationFieldsBase.isFieldADefaultValue(f) || retVal.containsKey(f.getName())) continue;
            try {
                if (f.getType().getName().equals("java.lang.String")) {
                    String sValue = (String)f.get(null);
                    retVal.put(f.getName(), sValue);
                    continue;
                }
                if (f.getType().getName().equals("short")) {
                    short shValue = (Short)f.get(null);
                    retVal.put(f.getName(), Integer.toString(shValue));
                    continue;
                }
                if (f.getType().getName().equals("int")) {
                    int iValue = (Integer)f.get(null);
                    retVal.put(f.getName(), Integer.toString(iValue));
                    continue;
                }
                if (f.getType().getName().equals("long")) {
                    long lValue = (Long)f.get(null);
                    retVal.put(f.getName(), Long.toString(lValue));
                    continue;
                }
                if (f.getType().getName().equals("float")) {
                    float fValue = ((Float)f.get(null)).floatValue();
                    retVal.put(f.getName(), Float.toString(fValue));
                    continue;
                }
                if (f.getType().getName().equals("double")) {
                    double dValue = (Double)f.get(null);
                    retVal.put(f.getName(), Double.toString(dValue));
                    continue;
                }
                if (f.getType().getName().equals("boolean")) {
                    boolean bValue = (Boolean)f.get(null);
                    retVal.put(f.getName(), Boolean.toString(bValue));
                    continue;
                }
                if (!this.defaultDebug) continue;
                System.out.println("Config variable " + f.getName() + " has unknown type " + f.getType().getName());
            }
            catch (IllegalAccessException iaException) {
                iaException.printStackTrace();
            }
        }
        return retVal;
    }

    private static Set<String> compareConfigurationToXmlFields(Map<String, String> keyMap1, Map<String, String> keyMap2) {
        HashSet<String> retVal = new HashSet<String>(keyMap1.keySet());
        retVal.removeAll(keyMap2.keySet());
        return retVal;
    }

    @Before
    public void setupTestConfigurationFields() throws Exception {
        Field[] fields;
        this.initializeMemberVariables();
        Assert.assertTrue((this.xmlFilename != null ? 1 : 0) != 0);
        Assert.assertTrue((this.configurationClasses != null ? 1 : 0) != 0);
        this.configurationMemberVariables = new HashMap<String, String>();
        if (this.configDebug) {
            System.out.println("Reading configuration classes");
            System.out.println("");
        }
        for (Class c : this.configurationClasses) {
            fields = c.getDeclaredFields();
            HashMap<String, String> memberMap = this.extractMemberVariablesFromConfigurationFields(fields);
            if (memberMap == null) continue;
            this.configurationMemberVariables.putAll(memberMap);
        }
        if (this.configDebug) {
            System.out.println("");
            System.out.println("=====");
            System.out.println("");
        }
        if (this.xmlDebug) {
            System.out.println("Reading XML property files");
            System.out.println("");
        }
        this.xmlKeyValueMap = this.extractPropertiesFromXml(this.xmlFilename);
        if (this.xmlDebug) {
            System.out.println("");
            System.out.println("=====");
            System.out.println("");
        }
        if (this.defaultDebug) {
            System.out.println("Reading Config property files for defaults");
            System.out.println("");
        }
        this.configurationDefaultVariables = new HashMap<String, String>();
        for (Class c : this.configurationClasses) {
            fields = c.getDeclaredFields();
            HashMap<String, String> defaultMap = this.extractDefaultVariablesFromConfigurationFields(fields);
            if (defaultMap == null) continue;
            this.configurationDefaultVariables.putAll(defaultMap);
        }
        if (this.defaultDebug) {
            System.out.println("");
            System.out.println("=====");
            System.out.println("");
        }
        this.configurationFieldsMissingInXmlFile = TestConfigurationFieldsBase.compareConfigurationToXmlFields(this.configurationMemberVariables, this.xmlKeyValueMap);
        this.xmlFieldsMissingInConfiguration = TestConfigurationFieldsBase.compareConfigurationToXmlFields(this.xmlKeyValueMap, this.configurationMemberVariables);
    }

    @Test
    public void testCompareConfigurationClassAgainstXml() {
        Assert.assertTrue((this.xmlFilename != null ? 1 : 0) != 0);
        Assert.assertTrue((this.configurationClasses != null ? 1 : 0) != 0);
        int missingXmlSize = this.configurationFieldsMissingInXmlFile.size();
        for (Class c : this.configurationClasses) {
            System.out.println(c);
        }
        System.out.println("  (" + this.configurationMemberVariables.size() + " member variables)");
        System.out.println();
        StringBuffer xmlErrorMsg = new StringBuffer();
        for (Class c : this.configurationClasses) {
            xmlErrorMsg.append(c);
            xmlErrorMsg.append(" ");
        }
        xmlErrorMsg.append("has ");
        xmlErrorMsg.append(missingXmlSize);
        xmlErrorMsg.append(" variables missing in ");
        xmlErrorMsg.append(this.xmlFilename);
        System.out.println(xmlErrorMsg.toString());
        System.out.println();
        if (missingXmlSize == 0) {
            System.out.println("  (None)");
        } else {
            for (String missingField : this.configurationFieldsMissingInXmlFile) {
                System.out.println("  " + missingField);
            }
        }
        System.out.println();
        System.out.println("=====");
        System.out.println();
        if (this.errorIfMissingXmlProps) {
            Assert.assertTrue((String)xmlErrorMsg.toString(), (missingXmlSize == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareXmlAgainstConfigurationClass() {
        Assert.assertTrue((this.xmlFilename != null ? 1 : 0) != 0);
        Assert.assertTrue((this.configurationClasses != null ? 1 : 0) != 0);
        int missingConfigSize = this.xmlFieldsMissingInConfiguration.size();
        System.out.println("File " + this.xmlFilename + " (" + this.xmlKeyValueMap.size() + " properties)");
        System.out.println();
        StringBuffer configErrorMsg = new StringBuffer();
        configErrorMsg.append(this.xmlFilename);
        configErrorMsg.append(" has ");
        configErrorMsg.append(missingConfigSize);
        configErrorMsg.append(" properties missing in");
        for (Class c : this.configurationClasses) {
            configErrorMsg.append("  " + c);
        }
        System.out.println(configErrorMsg.toString());
        System.out.println();
        if (missingConfigSize == 0) {
            System.out.println("  (None)");
        } else {
            for (String missingField : this.xmlFieldsMissingInConfiguration) {
                System.out.println("  " + missingField);
            }
        }
        System.out.println();
        System.out.println("=====");
        System.out.println();
        if (this.errorIfMissingConfigProps) {
            Assert.assertTrue((String)configErrorMsg.toString(), (missingConfigSize == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testXmlAgainstDefaultValuesInConfigurationClass() {
        Assert.assertTrue((this.xmlFilename != null ? 1 : 0) != 0);
        Assert.assertTrue((this.configurationMemberVariables != null ? 1 : 0) != 0);
        Assert.assertTrue((this.configurationDefaultVariables != null ? 1 : 0) != 0);
        HashSet<String> xmlPropertiesWithEmptyValue = new HashSet<String>();
        HashSet<String> configPropertiesWithNoDefaultConfig = new HashSet<String>();
        HashMap<String, String> xmlPropertiesMatchingConfigDefault = new HashMap<String, String>();
        HashMap mismatchingXmlConfig = new HashMap();
        for (Map.Entry<String, String> entry : this.xmlKeyValueMap.entrySet()) {
            String xmlProperty = entry.getKey();
            String xmlDefaultValue = entry.getValue();
            String configProperty = this.configurationMemberVariables.get(xmlProperty);
            if (configProperty == null) continue;
            String defaultConfigName = null;
            String defaultConfigValue = null;
            String defaultNameCheck1 = "DEFAULT_" + configProperty;
            String defaultValueCheck1 = this.configurationDefaultVariables.get(defaultNameCheck1);
            String defaultNameCheck2 = null;
            if (configProperty.endsWith("_KEY")) {
                defaultNameCheck2 = configProperty.substring(0, configProperty.length() - 4) + "_DEFAULT";
            }
            String defaultValueCheck2 = this.configurationDefaultVariables.get(defaultNameCheck2);
            String defaultNameCheck3 = configProperty + "_DEFAULT";
            String defaultValueCheck3 = this.configurationDefaultVariables.get(defaultNameCheck3);
            if (defaultValueCheck1 != null) {
                defaultConfigName = defaultNameCheck1;
                defaultConfigValue = defaultValueCheck1;
            } else if (defaultValueCheck2 != null) {
                defaultConfigName = defaultNameCheck2;
                defaultConfigValue = defaultValueCheck2;
            } else if (defaultValueCheck3 != null) {
                defaultConfigName = defaultNameCheck3;
                defaultConfigValue = defaultValueCheck3;
            }
            if (defaultConfigValue != null) {
                if (xmlDefaultValue == null) {
                    xmlPropertiesWithEmptyValue.add(xmlProperty);
                    continue;
                }
                if (!xmlDefaultValue.equals(defaultConfigValue)) {
                    HashMap<String, String> xmlEntry = new HashMap<String, String>();
                    xmlEntry.put(xmlProperty, xmlDefaultValue);
                    HashMap<String, String> configEntry = new HashMap<String, String>();
                    configEntry.put(defaultConfigName, defaultConfigValue);
                    mismatchingXmlConfig.put(xmlEntry, configEntry);
                    continue;
                }
                xmlPropertiesMatchingConfigDefault.put(xmlProperty, defaultConfigName);
                continue;
            }
            configPropertiesWithNoDefaultConfig.add(configProperty);
        }
        System.out.println(this.xmlFilename + " has " + mismatchingXmlConfig.size() + " properties that do not match the default Config value");
        if (mismatchingXmlConfig.size() == 0) {
            System.out.println("  (None)");
        } else {
            for (Map.Entry<String, String> entry : mismatchingXmlConfig.entrySet()) {
                HashMap xmlMap = (HashMap)((Object)entry.getKey());
                HashMap configMap = (HashMap)((Object)entry.getValue());
                for (Map.Entry xmlEntry : xmlMap.entrySet()) {
                    System.out.println("  XML Property: " + (String)xmlEntry.getKey());
                    System.out.println("  XML Value:    " + (String)xmlEntry.getValue());
                }
                for (Map.Entry configEntry : configMap.entrySet()) {
                    System.out.println("  Config Name:  " + (String)configEntry.getKey());
                    System.out.println("  Config Value: " + (String)configEntry.getValue());
                }
                System.out.println("");
            }
        }
        System.out.println();
        System.out.println("Configuration(s) have " + configPropertiesWithNoDefaultConfig.size() + " properties with no corresponding default member variable.  These" + " will need to be verified manually.");
        if (configPropertiesWithNoDefaultConfig.size() == 0) {
            System.out.println("  (None)");
        } else {
            Iterator cItr = configPropertiesWithNoDefaultConfig.iterator();
            while (cItr.hasNext()) {
                System.out.println("  " + (String)cItr.next());
            }
        }
        System.out.println();
        System.out.println(this.xmlFilename + " has " + xmlPropertiesWithEmptyValue.size() + " properties with empty values");
        if (xmlPropertiesWithEmptyValue.size() == 0) {
            System.out.println("  (None)");
        } else {
            Iterator xItr = xmlPropertiesWithEmptyValue.iterator();
            while (xItr.hasNext()) {
                System.out.println("  " + (String)xItr.next());
            }
        }
        System.out.println();
        System.out.println(this.xmlFilename + " has " + xmlPropertiesMatchingConfigDefault.size() + " properties which match a corresponding Config variable");
        if (xmlPropertiesMatchingConfigDefault.size() == 0) {
            System.out.println("  (None)");
        } else {
            for (Map.Entry<String, String> entry : xmlPropertiesMatchingConfigDefault.entrySet()) {
                System.out.println("  " + entry.getKey() + " / " + entry.getValue());
            }
        }
        System.out.println();
        System.out.println();
        System.out.println("=====");
        System.out.println();
    }

    @Test
    public void testDefaultValueCollision() {
        for (String filter : this.filtersForDefaultValueCollisionCheck) {
            System.out.println("Checking if any of the default values whose name contains string \"" + filter + "\" collide.");
            HashMap<String, String> filteredValues = new HashMap<String, String>();
            int valuesChecked = 0;
            for (Map.Entry<String, String> ent : this.configurationDefaultVariables.entrySet()) {
                if (!ent.getKey().contains(filter)) continue;
                if (StringUtils.isNumeric((String)ent.getValue())) {
                    String crtValue = filteredValues.put(ent.getValue(), ent.getKey());
                    Assert.assertTrue((String)("Parameters " + ent.getKey() + " and " + crtValue + " are using the same default value!"), (crtValue == null ? 1 : 0) != 0);
                }
                ++valuesChecked;
            }
            System.out.println("Checked " + valuesChecked + " default values for collision.");
        }
    }
}

