/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;
import org.apache.tez.common.annotation.ConfigurationClass;
import org.apache.tez.common.annotation.ConfigurationProperty;
import org.apache.tez.dag.api.ConfigurationScope;
import org.apache.tez.dag.api.Scope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@ConfigurationClass(templateFileName="tez-default-template.xml")
public class TezConfiguration
extends Configuration {
    public static final String TEZ_SITE_XML = "tez-site.xml";
    private static final Logger LOG = LoggerFactory.getLogger(TezConfiguration.class);
    private static Map<String, Scope> PropertyScope = new HashMap<String, Scope>();
    @InterfaceAudience.Private
    public static final String TEZ_PREFIX = "tez.";
    @InterfaceAudience.Private
    public static final String TEZ_AM_PREFIX = "tez.am.";
    @InterfaceAudience.Private
    public static final String TEZ_TASK_PREFIX = "tez.task.";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_STAGING_SCRATCH_DATA_AUTO_DELETE = "tez.am.staging.scratch-data.auto-delete";
    public static final boolean TEZ_AM_STAGING_SCRATCH_DATA_AUTO_DELETE_DEFAULT = true;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_AM_SHUFFLE_AUXILIARY_SERVICE_ID = "tez.am.shuffle.auxiliary-service.id";
    public static final String TEZ_AM_SHUFFLE_AUXILIARY_SERVICE_ID_DEFAULT = "mapreduce_shuffle";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_AM_STAGING_DIR = "tez.staging-dir";
    public static final String TEZ_AM_STAGING_DIR_DEFAULT;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_CREDENTIALS_PATH = "tez.credentials.path";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_CREDENTIALS_MERGE = "tez.am.credentials-merge";
    public static boolean TEZ_AM_CREDENTIALS_MERGE_DEFAULT;
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.AM)
    public static final String TEZ_AM_USE_CONCURRENT_DISPATCHER = "tez.am.use.concurrent-dispatcher";
    @InterfaceAudience.Private
    public static boolean TEZ_AM_USE_CONCURRENT_DISPATCHER_DEFAULT;
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.AM)
    public static final String TEZ_AM_CONCURRENT_DISPATCHER_CONCURRENCY = "tez.am.concurrent-dispatcher.concurrency";
    @InterfaceAudience.Private
    public static final int TEZ_AM_CONCURRENT_DISPATCHER_CONCURRENCY_DEFAULT = 10;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_SESSION_MODE = "tez.am.mode.session";
    public static final boolean TEZ_AM_SESSION_MODE_DEFAULT = false;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_AM_LOG_LEVEL = "tez.am.log.level";
    public static final String TEZ_AM_LOG_LEVEL_DEFAULT = "INFO";
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty
    public static final String TEZ_TASK_LOG_LEVEL = "tez.task.log.level";
    public static final String TEZ_TASK_LOG_LEVEL_DEFAULT = "INFO";
    @ConfigurationScope(value=Scope.AM)
    public static final String TEZ_TASK_MAX_ALLOWED_OUTPUT_FAILURES_FRACTION = "tez.task.max.allowed.output.failures.fraction";
    public static final double TEZ_TASK_MAX_ALLOWED_OUTPUT_FAILURES_FRACTION_DEFAULT = 0.1;
    @ConfigurationScope(value=Scope.AM)
    public static final String TEZ_TASK_MAX_ALLOWED_OUTPUT_FAILURES = "tez.task.max.allowed.output.failures";
    public static final int TEZ_TASK_MAX_ALLOWED_OUTPUT_FAILURES_DEFAULT = 10;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_MAX_ALLOWED_TIME_FOR_TASK_READ_ERROR_SEC = "tez.am.max.allowed.time-sec.for-read-error";
    public static final int TEZ_AM_MAX_ALLOWED_TIME_FOR_TASK_READ_ERROR_SEC_DEFAULT = 300;
    @ConfigurationScope(value=Scope.DAG)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_COMMIT_ALL_OUTPUTS_ON_DAG_SUCCESS = "tez.am.commit-all-outputs-on-dag-success";
    public static final boolean TEZ_AM_COMMIT_ALL_OUTPUTS_ON_DAG_SUCCESS_DEFAULT = true;
    @ConfigurationScope(value=Scope.DAG)
    @InterfaceAudience.Private
    public static final String TEZ_DAG_HISTORY_LOGGING_ENABLED = "tez.dag.history.logging.enabled";
    public static final boolean TEZ_DAG_HISTORY_LOGGING_ENABLED_DEFAULT = true;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_AM_LAUNCH_CLUSTER_DEFAULT_CMD_OPTS = "tez.am.launch.cluster-default.cmd-opts";
    public static final String TEZ_AM_LAUNCH_CLUSTER_DEFAULT_CMD_OPTS_DEFAULT = "-server -Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_AM_LAUNCH_CMD_OPTS = "tez.am.launch.cmd-opts";
    public static final String TEZ_AM_LAUNCH_CMD_OPTS_DEFAULT = "-XX:+PrintGCDetails -verbose:gc -XX:+PrintGCTimeStamps -XX:+UseNUMA -XX:+UseParallelGC";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_TASK_LAUNCH_CLUSTER_DEFAULT_CMD_OPTS = "tez.task.launch.cluster-default.cmd-opts";
    public static final String TEZ_TASK_LAUNCH_CLUSTER_DEFAULT_CMD_OPTS_DEFAULT = "-server -Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_TASK_LAUNCH_CMD_OPTS = "tez.task.launch.cmd-opts";
    public static final String TEZ_TASK_LAUNCH_CMD_OPTS_DEFAULT = "-XX:+PrintGCDetails -verbose:gc -XX:+PrintGCTimeStamps -XX:+UseNUMA -XX:+UseParallelGC";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="float")
    public static final String TEZ_CONTAINER_MAX_JAVA_HEAP_FRACTION = "tez.container.max.java.heap.fraction";
    public static final double TEZ_CONTAINER_MAX_JAVA_HEAP_FRACTION_DEFAULT = 0.8;
    private static final String NATIVE_LIB_PARAM_DEFAULT;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_AM_LAUNCH_CLUSTER_DEFAULT_ENV = "tez.am.launch.cluster-default.env";
    public static final String TEZ_AM_LAUNCH_CLUSTER_DEFAULT_ENV_DEFAULT;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_AM_LAUNCH_ENV = "tez.am.launch.env";
    public static final String TEZ_AM_LAUNCH_ENV_DEFAULT = "";
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty
    public static final String TEZ_TASK_LAUNCH_CLUSTER_DEFAULT_ENV = "tez.task.launch.cluster-default.env";
    public static final String TEZ_TASK_LAUNCH_CLUSTER_DEFAULT_ENV_DEFAULT;
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty
    public static final String TEZ_TASK_LAUNCH_ENV = "tez.task.launch.env";
    public static final String TEZ_TASK_LAUNCH_ENV_DEFAULT = "";
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.DAG)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_CANCEL_DELEGATION_TOKENS_ON_COMPLETION = "tez.cancel.delegation.tokens.on.completion";
    public static final boolean TEZ_CANCEL_DELEGATION_TOKENS_ON_COMPLETION_DEFAULT = true;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.DAG)
    public static final String TEZ_AM_ONE_TO_ONE_ROUTING_USE_ON_DEMAND_ROUTING = "tez.am.one-to-one.routing.use.on-demand-routing";
    public static final boolean TEZ_AM_ONE_TO_ONE_ROUTING_USE_ON_DEMAND_ROUTING_DEFAULT = false;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_TASK_LISTENER_THREAD_COUNT = "tez.am.task.listener.thread-count";
    public static final int TEZ_AM_TASK_LISTENER_THREAD_COUNT_DEFAULT = 30;
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_COUNTERS_MAX = "tez.counters.max";
    public static final int TEZ_COUNTERS_MAX_DEFAULT = 1200;
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_COUNTERS_MAX_GROUPS = "tez.counters.max.groups";
    public static final int TEZ_COUNTERS_MAX_GROUPS_DEFAULT = 500;
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_COUNTERS_COUNTER_NAME_MAX_LENGTH = "tez.counters.counter-name.max-length";
    public static final int TEZ_COUNTERS_COUNTER_NAME_MAX_LENGTH_DEFAULT = 64;
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_COUNTERS_GROUP_NAME_MAX_LENGTH = "tez.counters.group-name.max-length";
    public static final int TEZ_COUNTERS_GROUP_NAME_MAX_LENGTH_DEFAULT = 256;
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_SPECULATION_ENABLED = "tez.am.speculation.enabled";
    public static final boolean TEZ_AM_SPECULATION_ENABLED_DEFAULT = false;
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="float")
    public static final String TEZ_AM_LEGACY_SPECULATIVE_SLOWTASK_THRESHOLD = "tez.am.legacy.speculative.slowtask.threshold";
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="long")
    public static final String TEZ_AM_LEGACY_SPECULATIVE_SINGLE_TASK_VERTEX_TIMEOUT = "tez.am.legacy.speculative.single.task.vertex.timeout";
    public static final long TEZ_AM_LEGACY_SPECULATIVE_SINGLE_TASK_VERTEX_TIMEOUT_DEFAULT = -1L;
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty(type="long")
    public static final String TEZ_AM_SOONEST_RETRY_AFTER_NO_SPECULATE = "tez.am.soonest.retry.after.no.speculate";
    public static final long TEZ_AM_SOONEST_RETRY_AFTER_NO_SPECULATE_DEFAULT = 1000L;
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty(type="long")
    public static final String TEZ_AM_SOONEST_RETRY_AFTER_SPECULATE = "tez.am.soonest.retry.after.speculate";
    public static final long TEZ_AM_SOONEST_RETRY_AFTER_SPECULATE_DEFAULT = 15000L;
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty(type="double")
    public static final String TEZ_AM_PROPORTION_RUNNING_TASKS_SPECULATABLE = "tez.am.proportion.running.tasks.speculatable";
    public static final double TEZ_AM_PROPORTION_RUNNING_TASKS_SPECULATABLE_DEFAULT = 0.1;
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty(type="double")
    public static final String TEZ_AM_PROPORTION_TOTAL_TASKS_SPECULATABLE = "tez.am.proportion.total.tasks.speculatable";
    public static final double TEZ_AM_PROPORTION_TOTAL_TASKS_SPECULATABLE_DEFAULT = 0.01;
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_MINIMUM_ALLOWED_SPECULATIVE_TASKS = "tez.am.minimum.allowed.speculative.tasks";
    public static final int TEZ_AM_MINIMUM_ALLOWED_SPECULATIVE_TASKS_DEFAULT = 10;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_CONTAINERLAUNCHER_THREAD_COUNT_LIMIT = "tez.am.containerlauncher.thread-count-limit";
    public static final int TEZ_AM_CONTAINERLAUNCHER_THREAD_COUNT_LIMIT_DEFAULT = 500;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_MAX_TASK_FAILURES_PER_NODE = "tez.am.maxtaskfailures.per.node";
    public static final int TEZ_AM_MAX_TASK_FAILURES_PER_NODE_DEFAULT = 10;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_MAX_APP_ATTEMPTS = "tez.am.max.app.attempts";
    public static final int TEZ_AM_MAX_APP_ATTEMPTS_DEFAULT = 2;
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_VERTEX_MAX_TASK_CONCURRENCY = "tez.am.vertex.max-task-concurrency";
    public static final int TEZ_AM_VERTEX_MAX_TASK_CONCURRENCY_DEFAULT = -1;
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_TASK_MAX_FAILED_ATTEMPTS = "tez.am.task.max.failed.attempts";
    public static final int TEZ_AM_TASK_MAX_FAILED_ATTEMPTS_DEFAULT = 4;
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_TASK_RESCHEDULE_HIGHER_PRIORITY = "tez.am.task.reschedule.higher.priority";
    public static final boolean TEZ_AM_TASK_RESCHEDULE_HIGHER_PRIORITY_DEFAULT = true;
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_TASK_RESCHEDULE_RELAXED_LOCALITY = "tez.am.task.reschedule.relaxed.locality";
    public static final boolean TEZ_AM_TASK_RESCHEDULE_RELAXED_LOCALITY_DEFAULT = true;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_NODE_BLACKLISTING_ENABLED = "tez.am.node-blacklisting.enabled";
    public static final boolean TEZ_AM_NODE_BLACKLISTING_ENABLED_DEFAULT = true;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_NODE_BLACKLISTING_IGNORE_THRESHOLD = "tez.am.node-blacklisting.ignore-threshold-node-percent";
    public static final int TEZ_AM_NODE_BLACKLISTING_IGNORE_THRESHOLD_DEFAULT = 33;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_NODE_UNHEALTHY_RESCHEDULE_TASKS = "tez.am.node-unhealthy-reschedule-tasks";
    public static final boolean TEZ_AM_NODE_UNHEALTHY_RESCHEDULE_TASKS_DEFAULT = false;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_CLIENT_THREAD_COUNT = "tez.am.client.am.thread-count";
    public static final int TEZ_AM_CLIENT_THREAD_COUNT_DEFAULT = 2;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_AM_CLIENT_AM_PORT_RANGE = "tez.am.client.am.port-range";
    @ConfigurationScope(value=Scope.AM)
    public static final String TEZ_AM_TASK_AM_PORT_RANGE = "tez.am.task.am.port-range";
    @ConfigurationScope(value=Scope.DAG)
    @ConfigurationProperty
    public static final String TEZ_AM_DAG_SCHEDULER_CLASS = "tez.am.dag.scheduler.class";
    public static final String TEZ_AM_DAG_SCHEDULER_CLASS_DEFAULT = "org.apache.tez.dag.app.dag.impl.DAGSchedulerNaturalOrder";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_AM_YARN_SCHEDULER_CLASS = "tez.am.yarn.scheduler.class";
    public static final String TEZ_AM_YARN_SCHEDULER_CLASS_DEFAULT = "org.apache.tez.dag.app.rm.YarnTaskSchedulerService";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_RESOURCE_MEMORY_MB = "tez.am.resource.memory.mb";
    public static final int TEZ_AM_RESOURCE_MEMORY_MB_DEFAULT = 1024;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_RESOURCE_CPU_VCORES = "tez.am.resource.cpu.vcores";
    public static final int TEZ_AM_RESOURCE_CPU_VCORES_DEFAULT = 1;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_DAG_CLEANUP_ON_COMPLETION = "tez.am.dag.cleanup.on.completion";
    public static final boolean TEZ_AM_DAG_CLEANUP_ON_COMPLETION_DEFAULT = false;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_DAG_CLEANUP_THREAD_COUNT_LIMIT = "tez.am.dag.deletion.thread-count-limit";
    public static final int TEZ_AM_DAG_CLEANUP_THREAD_COUNT_LIMIT_DEFAULT = 10;
    @ConfigurationScope(value=Scope.DAG)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_TASK_RESOURCE_MEMORY_MB = "tez.task.resource.memory.mb";
    public static final int TEZ_TASK_RESOURCE_MEMORY_MB_DEFAULT = 1024;
    @ConfigurationScope(value=Scope.DAG)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_TASK_RESOURCE_CPU_VCORES = "tez.task.resource.cpu.vcores";
    public static final int TEZ_TASK_RESOURCE_CPU_VCORES_DEFAULT = 1;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_RM_HEARTBEAT_INTERVAL_MS_MAX = "tez.am.am-rm.heartbeat.interval-ms.max";
    public static final int TEZ_AM_RM_HEARTBEAT_INTERVAL_MS_MAX_DEFAULT = 1000;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_TASK_GET_TASK_SLEEP_INTERVAL_MS_MAX = "tez.task.get-task.sleep.interval-ms.max";
    public static final int TEZ_TASK_GET_TASK_SLEEP_INTERVAL_MS_MAX_DEFAULT = 200;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_TASK_AM_HEARTBEAT_INTERVAL_MS = "tez.task.am.heartbeat.interval-ms.max";
    public static final int TEZ_TASK_AM_HEARTBEAT_INTERVAL_MS_DEFAULT = 100;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_TASK_AM_HEARTBEAT_COUNTER_INTERVAL_MS = "tez.task.am.heartbeat.counter.interval-ms.max";
    public static final int TEZ_TASK_AM_HEARTBEAT_COUNTER_INTERVAL_MS_DEFAULT = 4000;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_TASK_MAX_EVENTS_PER_HEARTBEAT = "tez.task.max-events-per-heartbeat";
    public static final int TEZ_TASK_MAX_EVENTS_PER_HEARTBEAT_DEFAULT = 500;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_TASK_MAX_EVENT_BACKLOG = "tez.task.max-event-backlog";
    public static final int TEZ_TASK_MAX_EVENT_BACKLOG_DEFAULT = 10000;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_TASK_INITIALIZE_PROCESSOR_FIRST = "tez.task.initialize-processor-first";
    public static final boolean TEZ_TASK_INITIALIZE_PROCESSOR_FIRST_DEFAULT = false;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_TASK_INITIALIZE_PROCESSOR_IO_SERIALLY = "tez.task.initialize-processor-io-serially";
    public static final boolean TEZ_TASK_INITIALIZE_PROCESSOR_IO_SERIALLY_DEFAULT = false;
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty
    public static final String TEZ_TASK_PROGRESS_STUCK_INTERVAL_MS = "tez.task.progress.stuck.interval-ms";
    public static final long TEZ_TASK_PROGRESS_STUCK_INTERVAL_MS_DEFAULT = -1L;
    @InterfaceStability.Unstable
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_TASK_GENERATE_COUNTERS_PER_IO = "tez.task.generate.counters.per.io";
    @InterfaceAudience.Private
    public static final boolean TEZ_TASK_GENERATE_COUNTERS_PER_IO_DEFAULT = false;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TASK_HEARTBEAT_TIMEOUT_MS = "tez.task.timeout-ms";
    public static final int TASK_HEARTBEAT_TIMEOUT_MS_DEFAULT = 300000;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TASK_HEARTBEAT_TIMEOUT_CHECK_MS = "tez.task.heartbeat.timeout.check-ms";
    public static final int TASK_HEARTBEAT_TIMEOUT_CHECK_MS_DEFAULT = 30000;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_TASK_SCALE_MEMORY_ENABLED = "tez.task.scale.memory.enabled";
    @InterfaceAudience.Private
    public static final boolean TEZ_TASK_SCALE_MEMORY_ENABLED_DEFAULT = true;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty
    public static final String TEZ_TASK_SCALE_MEMORY_ALLOCATOR_CLASS = "tez.task.scale.memory.allocator.class";
    @InterfaceAudience.Private
    public static final String TEZ_TASK_SCALE_MEMORY_ALLOCATOR_CLASS_DEFAULT = "org.apache.tez.runtime.library.resources.WeightedScalingMemoryDistributor";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty(type="double")
    public static final String TEZ_TASK_SCALE_MEMORY_RESERVE_FRACTION = "tez.task.scale.memory.reserve-fraction";
    @InterfaceAudience.Private
    public static final double TEZ_TASK_SCALE_MEMORY_RESERVE_FRACTION_DEFAULT = 0.3;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty(type="float")
    public static final String TEZ_TASK_SCALE_MEMORY_ADDITIONAL_RESERVATION_FRACTION_PER_IO = "tez.task.scale.memory.additional-reservation.fraction.per-io";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty(type="float")
    public static final String TEZ_TASK_SCALE_MEMORY_ADDITIONAL_RESERVATION_FRACTION_MAX = "tez.task.scale.memory.additional-reservation.fraction.max";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.VERTEX)
    @ConfigurationProperty
    public static final String TEZ_TASK_SCALE_MEMORY_WEIGHTED_RATIOS = "tez.task.scale.memory.ratios";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.VERTEX)
    public static final String TEZ_TASK_SCALE_MEMORY_INPUT_OUTPUT_CONCURRENT = "tez.task.scale.memory.input-output-concurrent";
    public static final boolean TEZ_TASK_SCALE_MEMORY_INPUT_OUTPUT_CONCURRENT_DEFAULT = true;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.VERTEX)
    public static final String TEZ_TASK_SCALE_MEMORY_NON_CONCURRENT_INPUTS_ENABLED = "tez.task.scale.memory.non-concurrent-inputs.enabled";
    public static final boolean TEZ_TASK_SCALE_MEMORY_NON_CONCURRENT_INPUTS_ENABLED_DEFAULT = false;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_TASK_RESOURCE_CALCULATOR_PROCESS_TREE_CLASS = "tez.task.resource.calculator.process-tree.class";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_CONTAINER_REUSE_ENABLED = "tez.am.container.reuse.enabled";
    public static final boolean TEZ_AM_CONTAINER_REUSE_ENABLED_DEFAULT = true;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_CONTAINER_REUSE_RACK_FALLBACK_ENABLED = "tez.am.container.reuse.rack-fallback.enabled";
    public static final boolean TEZ_AM_CONTAINER_REUSE_RACK_FALLBACK_ENABLED_DEFAULT = true;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_CONTAINER_REUSE_NON_LOCAL_FALLBACK_ENABLED = "tez.am.container.reuse.non-local-fallback.enabled";
    public static final boolean TEZ_AM_CONTAINER_REUSE_NON_LOCAL_FALLBACK_ENABLED_DEFAULT = false;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_CONTAINER_REUSE_NEW_CONTAINERS_ENABLED = "tez.am.container.reuse.new-containers.enabled";
    public static final boolean TEZ_AM_CONTAINER_REUSE_NEW_CONTAINERS_ENABLED_DEFAULT = false;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="long")
    public static final String TEZ_AM_CONTAINER_REUSE_LOCALITY_DELAY_ALLOCATION_MILLIS = "tez.am.container.reuse.locality.delay-allocation-millis";
    public static final long TEZ_AM_CONTAINER_REUSE_LOCALITY_DELAY_ALLOCATION_MILLIS_DEFAULT = 250L;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_CONTAINER_IDLE_RELEASE_TIMEOUT_MIN_MILLIS = "tez.am.container.idle.release-timeout-min.millis";
    public static final long TEZ_AM_CONTAINER_IDLE_RELEASE_TIMEOUT_MIN_MILLIS_DEFAULT = 5000L;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="long")
    public static final String TEZ_AM_CONTAINER_IDLE_RELEASE_TIMEOUT_MAX_MILLIS = "tez.am.container.idle.release-timeout-max.millis";
    public static final long TEZ_AM_CONTAINER_IDLE_RELEASE_TIMEOUT_MAX_MILLIS_DEFAULT = 10000L;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_SESSION_MIN_HELD_CONTAINERS = "tez.am.session.min.held-containers";
    public static final int TEZ_AM_SESSION_MIN_HELD_CONTAINERS_DEFAULT = 0;
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.AM)
    public static final String TEZ_AM_HISTORY_LOGGING_ENABLED = "tez.am.history.logging.enabled";
    public static final boolean TEZ_AM_HISTORY_LOGGING_ENABLED_DEFAULT = true;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_PREEMPTION_PERCENTAGE = "tez.am.preemption.percentage";
    public static final int TEZ_AM_PREEMPTION_PERCENTAGE_DEFAULT = 10;
    @ConfigurationScope(value=Scope.VERTEX)
    public static final String TEZ_VERTEX_FAILURES_MAXPERCENT = "tez.vertex.failures.maxpercent";
    public static final float TEZ_VERTEX_FAILURES_MAXPERCENT_DEFAULT = 0.0f;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_PREEMPTION_HEARTBEATS_BETWEEN_PREEMPTIONS = "tez.am.preemption.heartbeats-between-preemptions";
    public static final int TEZ_AM_PREEMPTION_HEARTBEATS_BETWEEN_PREEMPTIONS_DEFAULT = 3;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_PREEMPTION_MAX_WAIT_TIME_MS = "tez.am.preemption.max.wait-time-ms";
    public static final int TEZ_AM_PREEMPTION_MAX_WAIT_TIME_MS_DEFAULT = 60000;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_LIB_URIS = "tez.lib.uris";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_LIB_URIS_CLASSPATH = "tez.lib.uris.classpath";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_AUX_URIS = "tez.aux.uris";
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_IGNORE_LIB_URIS = "tez.ignore.lib.uris";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_USE_CLUSTER_HADOOP_LIBS = "tez.use.cluster.hadoop-libs";
    public static final boolean TEZ_USE_CLUSTER_HADOOP_LIBS_DEFAULT = false;
    @ConfigurationScope(value=Scope.CLIENT)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_USER_CLASSPATH_FIRST = "tez.user.classpath.first";
    public static final boolean TEZ_USER_CLASSPATH_FIRST_DEFAULT = true;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_CLUSTER_ADDITIONAL_CLASSPATH_PREFIX = "tez.cluster.additional.classpath.prefix";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.CLIENT)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_CLASSPATH_ADD_HADOOP_CONF = "tez.classpath.add-hadoop-conf";
    public static final boolean TEZ_CLASSPATH_ADD_HADOOP_CONF_DEFAULT = false;
    @InterfaceAudience.Private
    @ConfigurationProperty
    public static final String TEZ_SESSION_PREFIX = "tez.session.";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_SESSION_CLIENT_TIMEOUT_SECS = "tez.session.client.timeout.secs";
    public static final int TEZ_SESSION_CLIENT_TIMEOUT_SECS_DEFAULT = 120;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_SESSION_AM_DAG_SUBMIT_TIMEOUT_SECS = "tez.session.am.dag.submit.timeout.secs";
    public static final int TEZ_SESSION_AM_DAG_SUBMIT_TIMEOUT_SECS_DEFAULT = 300;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_QUEUE_NAME = "tez.queue.name";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_APPLICATION_TAGS = "tez.application.tags";
    @ConfigurationScope(value=Scope.AM)
    public static final String TEZ_AM_APPLICATION_PRIORITY = "tez.am.application.priority";
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.DAG)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_GENERATE_DEBUG_ARTIFACTS = "tez.generate.debug.artifacts";
    public static final boolean TEZ_GENERATE_DEBUG_ARTIFACTS_DEFAULT = false;
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_TASK_SPECIFIC_LAUNCH_CMD_OPTS_LIST = "tez.task-specific.launch.cmd-opts.list";
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_TASK_SPECIFIC_LAUNCH_CMD_OPTS = "tez.task-specific.launch.cmd-opts";
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_TASK_SPECIFIC_LOG_LEVEL = "tez.task-specific.log.level";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_HISTORY_LOGGING_SERVICE_CLASS = "tez.history.logging.service.class";
    public static final String TEZ_HISTORY_LOGGING_SERVICE_CLASS_DEFAULT = "org.apache.tez.dag.history.logging.impl.SimpleHistoryLoggingService";
    @ConfigurationScope(value=Scope.DAG)
    @ConfigurationProperty
    public static final String TEZ_HISTORY_LOGGING_LOGLEVEL = "tez.history.logging.log.level";
    @ConfigurationScope(value=Scope.DAG)
    @ConfigurationProperty
    public static final String TEZ_HISTORY_LOGGING_TASKATTEMPT_FILTERS = "tez.history.logging.taskattempt-filters";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_HISTORY_LOGGING_TIMELINE_CACHE_PLUGIN_OLD_NUM_DAGS_PER_GROUP = "tez.history.logging.timeline-cache-plugin.old-num-dags-per-group";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_HISTORY_LOGGING_TIMELINE_NUM_DAGS_PER_GROUP = "tez.history.logging.timeline.num-dags-per-group";
    public static final int TEZ_HISTORY_LOGGING_TIMELINE_NUM_DAGS_PER_GROUP_DEFAULT = 1;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_SIMPLE_HISTORY_LOGGING_DIR = "tez.simple.history.logging.dir";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_SIMPLE_HISTORY_LOGGING_MAX_ERRORS = "tez.simple.history.max.errors";
    public static final int TEZ_SIMPLE_HISTORY_LOGGING_MAX_ERRORS_DEFAULT = 10;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_HISTORY_LOGGING_PROTO_BASE_DIR = "tez.history.logging.proto-base-dir";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="long")
    public static final String TEZ_HISTORY_LOGGING_PROTO_SYNC_WINDOWN_SECS = "tez.history.logging.proto-sync-window-secs";
    public static final long TEZ_HISTORY_LOGGING_PROTO_SYNC_WINDOWN_SECS_DEFAULT = 60L;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_HISTORY_LOGGING_PROTO_QUEUE_SIZE = "tez.history.logging.queue.size";
    public static final int TEZ_HISTORY_LOGGING_PROTO_QUEUE_SIZE_DEFAULT = 100000;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_HISTORY_LOGGING_PROTO_SPLIT_DAG_START = "tez.history.logging.split-dag-start";
    public static final boolean TEZ_HISTORY_LOGGING_PROTO_SPLIT_DAG_START_DEFAULT = false;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_HISTORY_LOGGING_PROTO_DOAS = "tez.history.logging.proto-doas";
    public static final boolean TEZ_HISTORY_LOGGING_PROTO_DOAS_DEFAULT = false;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="long")
    public static final String YARN_ATS_EVENT_FLUSH_TIMEOUT_MILLIS = "tez.yarn.ats.event.flush.timeout.millis";
    public static final long YARN_ATS_EVENT_FLUSH_TIMEOUT_MILLIS_DEFAULT = -1L;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String YARN_ATS_MAX_EVENTS_PER_BATCH = "tez.yarn.ats.max.events.per.batch";
    public static final int YARN_ATS_MAX_EVENTS_PER_BATCH_DEFAULT = 5;
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.AM)
    public static final String TEZ_AM_UI_HISTORY_URL_SCHEME_CHECK_ENABLED = "tez.am.ui.history.url.scheme.check.enabled";
    public static final boolean TEZ_AM_UI_HISTORY_URL_SCHEME_CHECK_ENABLED_DEFAULT = true;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String YARN_ATS_MAX_POLLING_TIME_PER_EVENT = "tez.yarn.ats.max.polling.time.per.event.millis";
    public static final int YARN_ATS_MAX_POLLING_TIME_PER_EVENT_DEFAULT = 10;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String YARN_ATS_ACL_DOMAINS_AUTO_CREATE = "tez.yarn.ats.acl.domains.auto-create";
    public static final boolean YARN_ATS_ACL_DOMAINS_AUTO_CREATE_DEFAULT = true;
    @ConfigurationScope(value=Scope.AM)
    public static final String YARN_ATS_ACL_SESSION_DOMAIN_ID = "tez.yarn.ats.acl.session.domain.id";
    @ConfigurationScope(value=Scope.DAG)
    public static final String YARN_ATS_ACL_DAG_DOMAIN_ID = "tez.yarn.ats.acl.dag.domain.id";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String DAG_RECOVERY_ENABLED = "tez.dag.recovery.enabled";
    public static final boolean DAG_RECOVERY_ENABLED_DEFAULT = true;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String DAG_RECOVERY_FILE_IO_BUFFER_SIZE = "tez.dag.recovery.io.buffer.size";
    public static final int DAG_RECOVERY_FILE_IO_BUFFER_SIZE_DEFAULT = 8192;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String DAG_RECOVERY_MAX_UNFLUSHED_EVENTS = "tez.dag.recovery.max.unflushed.events";
    public static final int DAG_RECOVERY_MAX_UNFLUSHED_EVENTS_DEFAULT = 100;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String DAG_RECOVERY_FLUSH_INTERVAL_SECS = "tez.dag.recovery.flush.interval.secs";
    public static final int DAG_RECOVERY_FLUSH_INTERVAL_SECS_DEFAULT = 30;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_LOCAL_MODE = "tez.local.mode";
    public static final boolean TEZ_LOCAL_MODE_DEFAULT = false;
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_INLINE_TASK_EXECUTION_ENABLED = "tez.am.inline.task.execution.enabled";
    @InterfaceAudience.Private
    public static final boolean TEZ_AM_INLINE_TASK_EXECUTION_ENABLED_DEFAULT = false;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_INLINE_TASK_EXECUTION_MAX_TASKS = "tez.am.inline.task.execution.max-tasks";
    public static final int TEZ_AM_INLINE_TASK_EXECUTION_MAX_TASKS_DEFAULT = 1;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_ACLS_ENABLED = "tez.am.acls.enabled";
    public static final boolean TEZ_AM_ACLS_ENABLED_DEFAULT = true;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_AM_VIEW_ACLS = "tez.am.view-acls";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_AM_MODIFY_ACLS = "tez.am.modify-acls";
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_DISABLE_CLIENT_VERSION_CHECK = "tez.am.disable.client-version-check";
    public static final boolean TEZ_AM_DISABLE_CLIENT_VERSION_CHECK_DEFAULT = false;
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_ALLOW_DISABLED_TIMELINE_DOMAINS = "tez.allow.disabled.timeline-domains";
    public static final boolean TEZ_AM_ALLOW_DISABLED_TIMELINE_DOMAINS_DEFAULT = false;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_AM_TEZ_UI_HISTORY_URL_TEMPLATE = "tez.am.tez-ui.history-url.template";
    public static final String TEZ_AM_TEZ_UI_HISTORY_URL_TEMPLATE_DEFAULT = "__HISTORY_URL_BASE__/#/tez-app/__APPLICATION_ID__";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_HISTORY_URL_BASE = "tez.tez-ui.history-url.base";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_AM_WEBSERVICE_ENABLE = "tez.am.tez-ui.webservice.enable";
    public static final boolean TEZ_AM_WEBSERVICE_ENABLE_DEFAULT = true;
    @ConfigurationScope(value=Scope.DAG)
    @ConfigurationProperty(type="long")
    public static final String TEZ_DAG_STATUS_POLLINTERVAL_MS = "tez.dag.status.pollinterval-ms";
    public static final long TEZ_DAG_STATUS_POLLINTERVAL_MS_DEFAULT = 500L;
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.TEST)
    @ConfigurationProperty(type="long")
    public static final String TEZ_TEST_MINI_CLUSTER_APP_WAIT_ON_SHUTDOWN_SECS = "tez.test.minicluster.app.wait.on.shutdown.secs";
    public static final long TEZ_TEST_MINI_CLUSTER_APP_WAIT_ON_SHUTDOWN_SECS_DEFAULT = 30L;
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.CLIENT)
    @ConfigurationProperty(type="long")
    public static final String TEZ_CLIENT_DIAGNOSTICS_WAIT_TIMEOUT_MS = "tez.client.diagnostics.wait.timeout-ms";
    @InterfaceAudience.Private
    public static final long TEZ_CLIENT_DIAGNOSTICS_WAIT_TIMEOUT_MS_DEFAULT = 3000L;
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.CLIENT)
    @ConfigurationProperty
    public static final String TEZ_CLIENT_JAVA_OPTS_CHECKER_CLASS = "tez.java.opts.checker.class";
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.CLIENT)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_CLIENT_JAVA_OPTS_CHECKER_ENABLED = "tez.java.opts.checker.enabled";
    public static final boolean TEZ_CLIENT_JAVA_OPTS_CHECKER_ENABLED_DEFAULT = true;
    @ConfigurationScope(value=Scope.CLIENT)
    @ConfigurationProperty(type="long")
    public static final String TEZ_CLIENT_HARD_KILL_TIMEOUT_MS = "tez.client.timeout-ms";
    public static final long TEZ_CLIENT_HARD_KILL_TIMEOUT_MS_DEFAULT = 30000L;
    @ConfigurationScope(value=Scope.CLIENT)
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_CLIENT_ASYNCHRONOUS_STOP = "tez.client.asynchronous-stop";
    public static final boolean TEZ_CLIENT_ASYNCHRONOUS_STOP_DEFAULT = true;
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.CLIENT)
    @ConfigurationProperty(type="int")
    public static final String TEZ_IPC_PAYLOAD_RESERVED_BYTES = "tez.ipc.payload.reserved.bytes";
    public static final int TEZ_IPC_PAYLOAD_RESERVED_BYTES_DEFAULT = 0x500000;
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.TEST)
    public static final String TEZ_AM_RECOVERY_SERVICE_CLASS = "tez.test.recovery-service-class";
    @InterfaceAudience.Private
    public static final String TEZ_AM_RECOVERY_SERVICE_CLASS_DEFAULT = "org.apache.tez.dag.history.recovery.RecoveryService";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_AM_DELETION_TRACKER_CLASS = "tez.am.deletion.tracker.class";
    public static final String TEZ_AM_DELETION_TRACKER_CLASS_DEFAULT = "org.apache.tez.dag.app.launcher.DeletionTrackerImpl";
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.AM)
    public static final String TEZ_AM_ATS_V15_OVERRIDE_SUMMARY_TYPES = "tez.am.ats.v15.override.summary-types";
    public static final boolean TEZ_AM_ATS_V15_OVERRIDE_SUMMARY_TYPES_DEFAULT = true;
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.AM)
    public static final String TEZ_AM_SLEEP_TIME_BEFORE_EXIT_MILLIS = "tez.am.sleep.time.before.exit.millis";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_JVM_SYSTEM_PROPERTIES_TO_LOG = "tez.tez.jvm.system-properties-to-log";
    public static final List<String> TEZ_JVM_SYSTEM_PROPERTIES_TO_LOG_DEFAULT;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty(type="integer")
    public static final String TEZ_AM_CLIENT_HEARTBEAT_TIMEOUT_SECS = "tez.am.client.heartbeat.timeout.secs";
    public static final int TEZ_AM_CLIENT_HEARTBEAT_TIMEOUT_SECS_DEFAULT = -1;
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.AM)
    public static final String TEZ_AM_CLIENT_HEARTBEAT_POLL_INTERVAL_MILLIS = "tez.am.client.heartbeat.poll.interval.millis";
    public static final int TEZ_AM_CLIENT_HEARTBEAT_POLL_INTERVAL_MILLIS_DEFAULT = -1;
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.AM)
    public static final String TEZ_SHARED_EXECUTOR_MIN_THREADS = "tez.shared-executor.min-threads";
    public static final int TEZ_SHARED_EXECUTOR_MIN_THREADS_DEFAULT = 0;
    @InterfaceAudience.Private
    @ConfigurationScope(value=Scope.AM)
    public static final String TEZ_SHARED_EXECUTOR_MAX_THREADS = "tez.shared-executor.max-threads";
    public static final int TEZ_SHARED_EXECUTOR_MAX_THREADS_DEFAULT = -1;
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_JOB_FS_SERVERS = "tez.job.fs-servers";
    @ConfigurationScope(value=Scope.AM)
    @ConfigurationProperty
    public static final String TEZ_JOB_FS_SERVERS_TOKEN_RENEWAL_EXCLUDE = "tez.job.fs-servers.token-renewal.exclude";

    static void setupConfigurationScope(Class<?> clazz) {
        for (Field field : clazz.getFields()) {
            if (!field.isAnnotationPresent(ConfigurationScope.class)) continue;
            ConfigurationScope confScope = field.getAnnotation(ConfigurationScope.class);
            if (field.getType() == String.class) {
                try {
                    PropertyScope.put(field.get(null).toString(), confScope.value());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(field.getName() + " is not String type, should not been annotated with " + ConfigurationScope.class.getSimpleName());
        }
    }

    public TezConfiguration() {
        this(true);
    }

    public TezConfiguration(Configuration conf) {
        super(conf);
        this.addResource(TEZ_SITE_XML);
    }

    public TezConfiguration(boolean loadDefaults) {
        super(loadDefaults);
        if (loadDefaults) {
            this.addResource(TEZ_SITE_XML);
        }
    }

    public static void validateProperty(String property, Scope usedScope) {
        Scope validScope = PropertyScope.get(property);
        if (validScope == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(property + " is not standard configuration property of tez, can not been validated");
            }
        } else if (usedScope.ordinal() > validScope.ordinal()) {
            throw new IllegalStateException(property + " is set at the scope of " + (Object)((Object)usedScope) + ", but it is only valid in the scope of " + (Object)((Object)validScope));
        }
    }

    @VisibleForTesting
    static Set<String> getPropertySet() {
        return PropertyScope.keySet();
    }

    static {
        Configuration.addDeprecation((String)"tez.am.counters.max.keys", (String)TEZ_COUNTERS_MAX);
        Configuration.addDeprecation((String)"tez.am.counters.groups.max.keys", (String)TEZ_COUNTERS_MAX_GROUPS);
        Configuration.addDeprecation((String)"tez.am.counters.name.max.keys", (String)TEZ_COUNTERS_COUNTER_NAME_MAX_LENGTH);
        Configuration.addDeprecation((String)"tez.am.counters.group-name.max.keys", (String)TEZ_COUNTERS_GROUP_NAME_MAX_LENGTH);
        Configuration.addDeprecation((String)"tez.task.scale.task.memory.enabled", (String)TEZ_TASK_SCALE_MEMORY_ENABLED);
        Configuration.addDeprecation((String)"tez.task.scale.task.memory.allocator.class", (String)TEZ_TASK_SCALE_MEMORY_ALLOCATOR_CLASS);
        Configuration.addDeprecation((String)"tez.task.scale.task.memory.reserve-fraction", (String)TEZ_TASK_SCALE_MEMORY_RESERVE_FRACTION);
        Configuration.addDeprecation((String)"tez.task.scale.task.memory.additional-reservation.fraction.per-io", (String)TEZ_TASK_SCALE_MEMORY_ADDITIONAL_RESERVATION_FRACTION_PER_IO);
        Configuration.addDeprecation((String)"tez.task.scale.task.memory.additional-reservation.fraction.max", (String)TEZ_TASK_SCALE_MEMORY_ADDITIONAL_RESERVATION_FRACTION_MAX);
        Configuration.addDeprecation((String)"tez.task.scale.task.memory.ratios", (String)TEZ_TASK_SCALE_MEMORY_WEIGHTED_RATIOS);
        Configuration.addDeprecation((String)"tez.task.max-events-per-heartbeat.max", (String)TEZ_TASK_MAX_EVENTS_PER_HEARTBEAT);
        TezConfiguration.setupConfigurationScope(TezConfiguration.class);
        TEZ_AM_STAGING_DIR_DEFAULT = "/tmp/" + System.getProperty("user.name") + "/tez/staging";
        TEZ_AM_CREDENTIALS_MERGE_DEFAULT = true;
        TEZ_AM_USE_CONCURRENT_DISPATCHER_DEFAULT = false;
        TEZ_AM_LAUNCH_CLUSTER_DEFAULT_ENV_DEFAULT = NATIVE_LIB_PARAM_DEFAULT = Shell.WINDOWS ? "PATH=%PATH%;%HADOOP_COMMON_HOME%\\bin" : "LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$HADOOP_COMMON_HOME/lib/native/";
        TEZ_TASK_LAUNCH_CLUSTER_DEFAULT_ENV_DEFAULT = NATIVE_LIB_PARAM_DEFAULT;
        TEZ_JVM_SYSTEM_PROPERTIES_TO_LOG_DEFAULT = Collections.unmodifiableList(Arrays.asList("os.name", "os.version", "java.home", "java.runtime.version", "java.vendor", "java.version", "java.vm.name", "java.class.path", "java.io.tmpdir", "user.dir", "user.name"));
    }
}

