/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.pig.impl.io.NullableLongWritable;
import org.apache.pig.impl.util.ObjectSerializer;

public class PigLongRawComparator
extends WritableComparator
implements Configurable {
    protected final Log mLog = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected boolean[] mAsc;
    protected LongWritable.Comparator mWrappedComp = new LongWritable.Comparator();

    public PigLongRawComparator() {
        super(NullableLongWritable.class);
    }

    public void setConf(Configuration conf) {
        try {
            this.mAsc = (boolean[])ObjectSerializer.deserialize(conf.get("pig.sortOrder"));
        }
        catch (IOException ioe) {
            this.mLog.error((Object)("Unable to deserialize pig.sortOrder " + ioe.getMessage()));
            throw new RuntimeException(ioe);
        }
        if (this.mAsc == null) {
            this.mAsc = new boolean[1];
            this.mAsc[0] = true;
        }
    }

    public Configuration getConf() {
        return null;
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int rc = 0;
        rc = b1[s1] == 0 && b2[s2] == 0 ? this.mWrappedComp.compare(b1, s1 + 1, l1 - 2, b2, s2 + 1, l2 - 2) : (b1[s1] != 0 && b2[s2] != 0 ? b1[s1 + 1] - b2[s2 + 1] : (b1[s1] != 0 ? -1 : 1));
        if (!this.mAsc[0]) {
            rc *= -1;
        }
        return rc;
    }

    public int compare(Object o1, Object o2) {
        NullableLongWritable nlw1 = (NullableLongWritable)o1;
        NullableLongWritable nlw2 = (NullableLongWritable)o2;
        int rc = 0;
        rc = !nlw1.isNull() && !nlw2.isNull() ? ((Long)nlw1.getValueAsPigType()).compareTo((Long)nlw2.getValueAsPigType()) : (nlw1.isNull() && nlw2.isNull() ? nlw1.getIndex() - nlw2.getIndex() : (nlw1.isNull() ? -1 : 1));
        if (!this.mAsc[0]) {
            rc *= -1;
        }
        return rc;
    }
}

