/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.util;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezEdgeDescriptor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.UDFContextSeparator;

public class TezUDFContextSeparator
extends TezOpPlanVisitor {
    private UDFContextSeparator udfContextSeparator = new UDFContextSeparator();

    public TezUDFContextSeparator(TezOperPlan plan, PlanWalker<TezOperator, TezOperPlan> walker) {
        super(plan, walker);
    }

    @Override
    public void visitTezOp(TezOperator tezOperator) throws VisitorException {
        if (!tezOperator.isVertexGroup()) {
            this.udfContextSeparator.setPlan(tezOperator.plan, tezOperator.getOperatorKey().toString());
            this.udfContextSeparator.visit();
            for (Map.Entry<OperatorKey, TezEdgeDescriptor> entry : tezOperator.outEdges.entrySet()) {
                PhysicalPlan combinePlan = entry.getValue().combinePlan;
                if (combinePlan.isEmpty()) continue;
                this.udfContextSeparator.setPlan(combinePlan, tezOperator.getOperatorKey().toString() + "-" + entry.getKey().toString());
                this.udfContextSeparator.visit();
            }
        }
    }

    public void serializeUDFContext(Configuration conf, TezOperator tezOp) throws IOException {
        this.udfContextSeparator.serializeUDFContext(conf, tezOp.getOperatorKey().toString(), UDFContextSeparator.UDFType.values());
    }

    public void serializeUDFContext(Configuration conf, TezOperator tezOp, UDFContextSeparator.UDFType udfType) throws IOException {
        this.udfContextSeparator.serializeUDFContext(conf, tezOp.getOperatorKey().toString(), udfType);
    }

    public void serializeUDFContextForEdge(Configuration conf, TezOperator from, TezOperator to, UDFContextSeparator.UDFType udfType) throws IOException {
        this.udfContextSeparator.serializeUDFContext(conf, from.getOperatorKey().toString() + "-" + to.getOperatorKey().toString(), udfType);
    }

    public void serializeUDFContext(Configuration conf, TezOperator tezOp, POStore store) throws IOException {
        this.udfContextSeparator.serializeUDFContext(conf, tezOp.getOperatorKey().toString(), store);
    }
}

