/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jruby.util.unsafe.UnsafeHolder;
import sun.misc.Unsafe;

class ConcurrentAutoTable
implements Serializable {
    private volatile CAT _cat = new CAT(null, 4, 0L);
    private static final AtomicReferenceFieldUpdater<ConcurrentAutoTable, CAT> _catUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcurrentAutoTable.class, CAT.class, "_cat");

    ConcurrentAutoTable() {
    }

    public void add(long x) {
        this.add_if_mask(x, 0L);
    }

    public void decrement() {
        this.add_if_mask(-1L, 0L);
    }

    public void increment() {
        this.add_if_mask(1L, 0L);
    }

    public void set(long x) {
        CAT newcat = new CAT(null, 4, x);
        while (!this.CAS_cat(this._cat, newcat)) {
        }
    }

    public long get() {
        return this._cat.sum(0L);
    }

    public int intValue() {
        return (int)this._cat.sum(0L);
    }

    public long longValue() {
        return this._cat.sum(0L);
    }

    public long estimate_get() {
        return this._cat.estimate_sum(0L);
    }

    public String toString() {
        return this._cat.toString(0L);
    }

    public int internal_size() {
        return this._cat._t.length;
    }

    private long add_if_mask(long x, long mask) {
        return this._cat.add_if_mask(x, mask, ConcurrentAutoTable.hash(), this);
    }

    private boolean CAS_cat(CAT oldcat, CAT newcat) {
        return _catUpdater.compareAndSet(this, oldcat, newcat);
    }

    private static final int hash() {
        int h = System.identityHashCode(Thread.currentThread());
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h << 2;
    }

    private static class CAT
    implements Serializable {
        private static final Unsafe _unsafe = UnsafeHolder.U;
        private static final int _Lbase;
        private static final int _Lscale;
        volatile long _resizers;
        private static final AtomicLongFieldUpdater<CAT> _resizerUpdater;
        private final CAT _next;
        private volatile long _sum_cache;
        private volatile long _fuzzy_sum_cache;
        private volatile long _fuzzy_time;
        private static final int MAX_SPIN = 2;
        private long[] _t;

        private static final boolean CAS(long[] A, int idx, long old, long nnn) {
            assert (idx >= 0 && idx < A.length);
            if (_unsafe != null) {
                int rawIndex = _Lbase + idx * _Lscale;
                return _unsafe.compareAndSwapLong(A, rawIndex, old, nnn);
            }
            return CAT.CASnoUnsafe(A, idx, old, nnn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final boolean CASnoUnsafe(long[] A, int idx, long old, long nnn) {
            long[] lArray = A;
            synchronized (A) {
                if (A[idx] != old) {
                    // ** MonitorExit[var6_4] (shouldn't be in output)
                    return false;
                }
                A[idx] = nnn;
                // ** MonitorExit[var6_4] (shouldn't be in output)
                return true;
            }
        }

        CAT(CAT next2, int sz, long init) {
            this._next = next2;
            this._sum_cache = Long.MIN_VALUE;
            this._t = new long[sz];
            this._t[0] = init;
        }

        public long add_if_mask(long x, long mask, int hash2, ConcurrentAutoTable master) {
            long[] t = this._t;
            int idx = hash2 & t.length - 1;
            long old = t[idx];
            boolean ok = CAT.CAS(t, idx, old & (mask ^ 0xFFFFFFFFFFFFFFFFL), old + x);
            if (this._sum_cache != Long.MIN_VALUE) {
                this._sum_cache = Long.MIN_VALUE;
            }
            if (ok) {
                return old;
            }
            if ((old & mask) != 0L) {
                return old;
            }
            int cnt = 0;
            while (true) {
                if (((old = t[idx]) & mask) != 0L) {
                    return old;
                }
                if (CAT.CAS(t, idx, old, old + x)) break;
                ++cnt;
            }
            if (cnt < 2) {
                return old;
            }
            if (t.length >= 0x100000) {
                return old;
            }
            long r = this._resizers;
            int newbytes = t.length << 1 << 3;
            while (!_resizerUpdater.compareAndSet(this, r, r + (long)newbytes)) {
                r = this._resizers;
            }
            r += (long)newbytes;
            if (master._cat != this) {
                return old;
            }
            if (r >> 17 != 0L) {
                try {
                    Thread.sleep(r >> 17);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (master._cat != this) {
                    return old;
                }
            }
            CAT newcat = new CAT(this, t.length * 2, 0L);
            master.CAS_cat(this, newcat);
            return old;
        }

        public long sum(long mask) {
            long sum2 = this._sum_cache;
            if (sum2 != Long.MIN_VALUE) {
                return sum2;
            }
            sum2 = this._next == null ? 0L : this._next.sum(mask);
            long[] t = this._t;
            for (int i2 = 0; i2 < t.length; ++i2) {
                sum2 += t[i2] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this._sum_cache = sum2;
            return sum2;
        }

        public long estimate_sum(long mask) {
            if (this._t.length <= 64) {
                return this.sum(mask);
            }
            long millis = System.currentTimeMillis();
            if (this._fuzzy_time != millis) {
                this._fuzzy_sum_cache = this.sum(mask);
                this._fuzzy_time = millis;
            }
            return this._fuzzy_sum_cache;
        }

        public void all_or(long mask) {
            long[] t = this._t;
            for (int i2 = 0; i2 < t.length; ++i2) {
                boolean done = false;
                while (!done) {
                    long old = t[i2];
                    done = CAT.CAS(t, i2, old, old | mask);
                }
            }
            if (this._next != null) {
                this._next.all_or(mask);
            }
            if (this._sum_cache != Long.MIN_VALUE) {
                this._sum_cache = Long.MIN_VALUE;
            }
        }

        public void all_and(long mask) {
            long[] t = this._t;
            for (int i2 = 0; i2 < t.length; ++i2) {
                boolean done = false;
                while (!done) {
                    long old = t[i2];
                    done = CAT.CAS(t, i2, old, old & mask);
                }
            }
            if (this._next != null) {
                this._next.all_and(mask);
            }
            if (this._sum_cache != Long.MIN_VALUE) {
                this._sum_cache = Long.MIN_VALUE;
            }
        }

        public void all_set(long val) {
            long[] t = this._t;
            for (int i2 = 0; i2 < t.length; ++i2) {
                t[i2] = val;
            }
            if (this._next != null) {
                this._next.all_set(val);
            }
            if (this._sum_cache != Long.MIN_VALUE) {
                this._sum_cache = Long.MIN_VALUE;
            }
        }

        String toString(long mask) {
            return Long.toString(this.sum(mask));
        }

        static {
            if (_unsafe != null) {
                _Lbase = _unsafe.arrayBaseOffset(long[].class);
                _Lscale = _unsafe.arrayIndexScale(long[].class);
            } else {
                _Lscale = 0;
                _Lbase = 0;
            }
            _resizerUpdater = AtomicLongFieldUpdater.newUpdater(CAT.class, "_resizers");
        }
    }
}

