/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.FetchedInput;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDiskFetchedInput
extends FetchedInput {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDiskFetchedInput.class);
    private final Path inputFile;
    private final FileSystem localFS;
    private final long startOffset;
    private final long size;

    public LocalDiskFetchedInput(long startOffset, long compressedSize, InputAttemptIdentifier inputAttemptIdentifier, Path inputFile, Configuration conf, FetchedInputCallback callbackHandler) throws IOException {
        super(inputAttemptIdentifier, callbackHandler);
        this.size = compressedSize;
        this.startOffset = startOffset;
        this.inputFile = inputFile;
        this.localFS = FileSystem.getLocal((Configuration)conf);
    }

    @Override
    public FetchedInput.Type getType() {
        return FetchedInput.Type.DISK_DIRECT;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Output Stream is not supported for " + this.toString());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        FSDataInputStream inputStream = this.localFS.open(this.inputFile);
        inputStream.seek(this.startOffset);
        return new BoundedInputStream((InputStream)inputStream, this.getSize());
    }

    @Override
    public void commit() {
        if (this.isState(FetchedInput.State.PENDING)) {
            this.setState(FetchedInput.State.COMMITTED);
            this.notifyFetchComplete();
        }
    }

    @Override
    public void abort() {
        if (this.isState(FetchedInput.State.PENDING)) {
            this.setState(FetchedInput.State.ABORTED);
            this.notifyFetchFailure();
        }
    }

    @Override
    public void free() {
        Preconditions.checkState((this.isState(FetchedInput.State.COMMITTED) || this.isState(FetchedInput.State.ABORTED) ? 1 : 0) != 0, (Object)"FetchedInput can only be freed after it is committed or aborted");
        if (this.isState(FetchedInput.State.COMMITTED)) {
            this.setState(FetchedInput.State.FREED);
            this.notifyFreedResource();
        }
    }

    public String toString() {
        return "LocalDiskFetchedInput [inputFile path =" + this.inputFile + ", offset" + this.startOffset + ", compressedSize=" + this.getSize() + ", inputAttemptIdentifier=" + this.getInputAttemptIdentifier() + ", type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", state=" + (Object)((Object)this.getState()) + "]";
    }

    @VisibleForTesting
    protected Path getInputFile() {
        return this.inputFile;
    }

    @VisibleForTesting
    protected long getStartOffset() {
        return this.startOffset;
    }

    @VisibleForTesting
    protected FileSystem getLocalFS() {
        return this.localFS;
    }
}

