/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class TableDiskUsage {
    private int nextInternalId = 0;
    private Map<String, Integer> internalIds = new HashMap<String, Integer>();
    private Map<Integer, String> externalIds = new HashMap<Integer, String>();
    private Map<String, Integer[]> tableFiles = new HashMap<String, Integer[]>();
    private Map<String, Long> fileSizes = new HashMap<String, Long>();
    static final String[] SUFFIXES = new String[]{"K", "M", "G", "T", "P", "E", "Z"};

    void addTable(String tableId) {
        if (this.internalIds.containsKey(tableId)) {
            throw new IllegalArgumentException("Already added table " + tableId);
        }
        int iid = this.nextInternalId++;
        this.internalIds.put(tableId, iid);
        this.externalIds.put(iid, tableId);
    }

    void linkFileAndTable(String tableId, String file) {
        int internalId = this.internalIds.get(tableId);
        Integer[] tables = this.tableFiles.get(file);
        if (tables == null) {
            tables = new Integer[this.internalIds.size()];
            for (int i = 0; i < tables.length; ++i) {
                tables[i] = 0;
            }
            this.tableFiles.put(file, tables);
        }
        tables[internalId] = 1;
    }

    void addFileSize(String file, long size) {
        this.fileSizes.put(file, size);
    }

    Map<List<String>, Long> calculateUsage() {
        HashMap<List<Object>, Long> usage = new HashMap<List<Object>, Long>();
        for (Map.Entry<String, Integer[]> entry : this.tableFiles.entrySet()) {
            List<Object> key = Arrays.asList((Object[])entry.getValue());
            Long size = this.fileSizes.get(entry.getKey());
            Long tablesUsage = (Long)usage.get(key);
            if (tablesUsage == null) {
                tablesUsage = 0L;
            }
            tablesUsage = tablesUsage + size;
            usage.put(key, tablesUsage);
        }
        HashMap<List<String>, Long> externalUsage = new HashMap<List<String>, Long>();
        for (Map.Entry entry : usage.entrySet()) {
            ArrayList<String> externalKey = new ArrayList<String>();
            List key = (List)entry.getKey();
            for (int i = 0; i < key.size(); ++i) {
                if ((Integer)key.get(i) == 0) continue;
                externalKey.add(this.externalIds.get(i));
            }
            externalUsage.put((List<String>)externalKey, (Long)entry.getValue());
        }
        return externalUsage;
    }

    public static void printDiskUsage(AccumuloConfiguration acuConf, Collection<String> tables, FileSystem fs, Connector conn, boolean humanReadable) throws TableNotFoundException, IOException {
        TableDiskUsage.printDiskUsage(acuConf, tables, fs, conn, new Printer(){

            @Override
            public void print(String line) {
                System.out.println(line);
            }
        }, humanReadable);
    }

    public static void printDiskUsage(AccumuloConfiguration acuConf, Collection<String> tables, FileSystem fs, Connector conn, Printer printer, boolean humanReadable) throws TableNotFoundException, IOException {
        TableDiskUsage tdu = new TableDiskUsage();
        HashSet<String> tableIds = new HashSet<String>();
        for (String tableName : tables) {
            String tableId = conn.tableOperations().tableIdMap().get(tableName);
            if (tableId == null) {
                throw new TableNotFoundException(null, tableName, "Table " + tableName + " not found");
            }
            tableIds.add(tableId);
        }
        for (String tableId : tableIds) {
            tdu.addTable(tableId);
        }
        HashSet<String> tablesReferenced = new HashSet<String>(tableIds);
        HashSet<String> emptyTableIds = new HashSet<String>();
        for (String tableId : tableIds) {
            Scanner mdScanner = conn.createScanner("!METADATA", Constants.NO_AUTHS);
            mdScanner.fetchColumnFamily(Constants.METADATA_DATAFILE_COLUMN_FAMILY);
            mdScanner.setRange(new KeyExtent(new Text(tableId), null, null).toMetadataRange());
            if (!mdScanner.iterator().hasNext()) {
                emptyTableIds.add(tableId);
            }
            for (Map.Entry<Key, Value> entry : mdScanner) {
                String file = entry.getKey().getColumnQualifier().toString();
                if (file.startsWith("../")) {
                    file = file.substring(2);
                    tablesReferenced.add(file.split("\\/")[1]);
                } else {
                    file = "/" + tableId + file;
                }
                tdu.linkFileAndTable(tableId, file);
            }
        }
        for (String tableId : tablesReferenced) {
            FileStatus[] files;
            for (FileStatus fileStatus : files = fs.globStatus(new Path(Constants.getTablesDir(acuConf) + "/" + tableId + "/*/*"))) {
                String dir = fileStatus.getPath().getParent().getName();
                String name = fileStatus.getPath().getName();
                tdu.addFileSize("/" + tableId + "/" + dir + "/" + name, fileStatus.getLen());
            }
        }
        HashMap<String, String> reverseTableIdMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : conn.tableOperations().tableIdMap().entrySet()) {
            reverseTableIdMap.put(entry.getValue(), entry.getKey());
        }
        TreeMap<TreeSet<String>, Long> usage = new TreeMap<TreeSet<String>, Long>(new Comparator<TreeSet<String>>(){

            @Override
            public int compare(TreeSet<String> o1, TreeSet<String> o2) {
                int len1 = o1.size();
                int len2 = o2.size();
                int min = Math.min(len1, len2);
                Iterator<String> iter1 = o1.iterator();
                Iterator<String> iter2 = o2.iterator();
                for (int count = 0; count < min; ++count) {
                    String s2;
                    String s1 = iter1.next();
                    int cmp = s1.compareTo(s2 = iter2.next());
                    if (cmp == 0) continue;
                    return cmp;
                }
                return len1 - len2;
            }
        });
        for (Map.Entry<List<String>, Long> entry : tdu.calculateUsage().entrySet()) {
            TreeSet tableNames = new TreeSet();
            for (String tableId : entry.getKey()) {
                tableNames.add(reverseTableIdMap.get(tableId));
            }
            usage.put(tableNames, entry.getValue());
        }
        if (!emptyTableIds.isEmpty()) {
            TreeSet emptyTables = new TreeSet();
            for (String tableId : emptyTableIds) {
                emptyTables.add(reverseTableIdMap.get(tableId));
            }
            usage.put(emptyTables, 0L);
        }
        for (Map.Entry<SequencedCollection<String>, Long> entry : usage.entrySet()) {
            String valueFormat = humanReadable ? "%s" : "%,24d";
            Serializable value = humanReadable ? TableDiskUsage.humanReadableBytes(entry.getValue()) : (Serializable)entry.getValue();
            printer.print(String.format(valueFormat + " %s", value, entry.getKey()));
        }
    }

    public static String humanReadableBytes(long bytes) {
        if (bytes < 1024L) {
            return String.format("%4dB", bytes);
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        String suffix = SUFFIXES[exp - 1];
        double val = (double)bytes / Math.pow(1024.0, exp);
        return String.format(val >= 1000.0 ? "%4.0f%s" : " %3.1f%s", val, suffix);
    }

    public static interface Printer {
        public void print(String var1);
    }
}

