/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class AgeOffFilter
extends Filter {
    private static final String TTL = "ttl";
    private static final String CURRENT_TIME = "currentTime";
    private long threshold;
    private long currentTime;

    @Override
    public boolean accept(Key k, Value v) {
        return this.currentTime - k.getTimestamp() <= this.threshold;
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.threshold = -1L;
        if (options == null) {
            throw new IllegalArgumentException("ttl must be set for AgeOffFilter");
        }
        String ttl = options.get(TTL);
        if (ttl == null) {
            throw new IllegalArgumentException("ttl must be set for AgeOffFilter");
        }
        this.threshold = Long.parseLong(ttl);
        String time = options.get(CURRENT_TIME);
        this.currentTime = time != null ? Long.parseLong(time) : System.currentTimeMillis();
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        AgeOffFilter copy = (AgeOffFilter)super.deepCopy(env);
        copy.currentTime = this.currentTime;
        copy.threshold = this.threshold;
        return copy;
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.addNamedOption(TTL, "time to live (milliseconds)");
        io.addNamedOption(CURRENT_TIME, "if set, use the given value as the absolute time in milliseconds as the current time of day");
        io.setName("ageoff");
        io.setDescription("AgeOffFilter removes entries with timestamps more than <ttl> milliseconds old");
        return io;
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        if (!super.validateOptions(options)) {
            return false;
        }
        try {
            Long.parseLong(options.get(TTL));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bad long ttl:" + options.get(TTL));
        }
        return true;
    }

    public static void setTTL(IteratorSetting is, Long ttl) {
        is.addOption(TTL, Long.toString(ttl));
    }

    public static void setCurrentTime(IteratorSetting is, Long currentTime) {
        is.addOption(CURRENT_TIME, Long.toString(currentTime));
    }
}

