/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.HeapIterator;

public class MultiIterator
extends HeapIterator {
    private List<SortedKeyValueIterator<Key, Value>> iters;
    private Range fence;

    public MultiIterator deepCopy(IteratorEnvironment env) {
        return new MultiIterator(this, env);
    }

    private MultiIterator(MultiIterator other, IteratorEnvironment env) {
        super(other.iters.size());
        this.iters = new ArrayList<SortedKeyValueIterator<Key, Value>>();
        this.fence = other.fence;
        for (SortedKeyValueIterator<Key, Value> iter : other.iters) {
            this.iters.add(iter.deepCopy(env));
        }
    }

    private void init() {
        for (SortedKeyValueIterator<Key, Value> skvi : this.iters) {
            this.addSource(skvi);
        }
    }

    private MultiIterator(List<SortedKeyValueIterator<Key, Value>> iters, Range seekFence, boolean init) {
        super(iters.size());
        if (seekFence != null && init) {
            throw new IllegalArgumentException("Initializing not supported when seek fence set");
        }
        this.fence = seekFence;
        this.iters = iters;
        if (init) {
            this.init();
        }
    }

    public MultiIterator(List<SortedKeyValueIterator<Key, Value>> iters, Range seekFence) {
        this(iters, seekFence, false);
    }

    public MultiIterator(List<SortedKeyValueIterator<Key, Value>> iters2, KeyExtent extent) {
        this(iters2, new Range(extent.getPrevEndRow(), false, extent.getEndRow(), true), false);
    }

    public MultiIterator(List<SortedKeyValueIterator<Key, Value>> readers, boolean init) {
        this(readers, null, init);
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.clear();
        if (this.fence != null && (range = this.fence.clip(range, true)) == null) {
            return;
        }
        for (SortedKeyValueIterator<Key, Value> skvi : this.iters) {
            skvi.seek(range, columnFamilies, inclusive);
            this.addSource(skvi);
        }
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        throw new UnsupportedOperationException();
    }
}

