/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapred;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientSideIteratorScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.impl.OfflineScanner;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.mapred.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.InputFormatBase;
import org.apache.accumulo.core.client.mapreduce.lib.util.InputConfigurator;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class InputFormatBase<K, V>
implements InputFormat<K, V> {
    private static final Class<?> CLASS = AccumuloInputFormat.class;
    protected static final Logger log = Logger.getLogger(CLASS);

    public static void setConnectorInfo(JobConf job, String principal, AuthenticationToken token) throws AccumuloSecurityException {
        InputConfigurator.setConnectorInfo(CLASS, (Configuration)job, principal, token);
    }

    protected static Boolean isConnectorInfoSet(JobConf job) {
        return InputConfigurator.isConnectorInfoSet(CLASS, (Configuration)job);
    }

    protected static String getPrincipal(JobConf job) {
        return InputConfigurator.getPrincipal(CLASS, (Configuration)job);
    }

    protected static String getTokenClass(JobConf job) {
        return InputConfigurator.getTokenClass(CLASS, (Configuration)job);
    }

    protected static byte[] getToken(JobConf job) {
        return InputConfigurator.getToken(CLASS, (Configuration)job);
    }

    public static void setZooKeeperInstance(JobConf job, String instanceName, String zooKeepers) {
        InputConfigurator.setZooKeeperInstance(CLASS, (Configuration)job, instanceName, zooKeepers);
    }

    public static void setMockInstance(JobConf job, String instanceName) {
        InputConfigurator.setMockInstance(CLASS, (Configuration)job, instanceName);
    }

    protected static Instance getInstance(JobConf job) {
        return InputConfigurator.getInstance(CLASS, (Configuration)job);
    }

    public static void setLogLevel(JobConf job, Level level) {
        InputConfigurator.setLogLevel(CLASS, (Configuration)job, level);
    }

    protected static Level getLogLevel(JobConf job) {
        return InputConfigurator.getLogLevel(CLASS, (Configuration)job);
    }

    public static void setInputTableName(JobConf job, String tableName) {
        InputConfigurator.setInputTableName(CLASS, (Configuration)job, tableName);
    }

    protected static String getInputTableName(JobConf job) {
        return InputConfigurator.getInputTableName(CLASS, (Configuration)job);
    }

    public static void setScanAuthorizations(JobConf job, Authorizations auths) {
        InputConfigurator.setScanAuthorizations(CLASS, (Configuration)job, auths);
    }

    protected static Authorizations getScanAuthorizations(JobConf job) {
        return InputConfigurator.getScanAuthorizations(CLASS, (Configuration)job);
    }

    public static void setRanges(JobConf job, Collection<Range> ranges) {
        InputConfigurator.setRanges(CLASS, (Configuration)job, ranges);
    }

    protected static List<Range> getRanges(JobConf job) throws IOException {
        return InputConfigurator.getRanges(CLASS, (Configuration)job);
    }

    public static void fetchColumns(JobConf job, Collection<Pair<Text, Text>> columnFamilyColumnQualifierPairs) {
        InputConfigurator.fetchColumns(CLASS, (Configuration)job, columnFamilyColumnQualifierPairs);
    }

    protected static Set<Pair<Text, Text>> getFetchedColumns(JobConf job) {
        return InputConfigurator.getFetchedColumns(CLASS, (Configuration)job);
    }

    public static void addIterator(JobConf job, IteratorSetting cfg) {
        InputConfigurator.addIterator(CLASS, (Configuration)job, cfg);
    }

    protected static List<IteratorSetting> getIterators(JobConf job) {
        return InputConfigurator.getIterators(CLASS, (Configuration)job);
    }

    public static void setAutoAdjustRanges(JobConf job, boolean enableFeature) {
        InputConfigurator.setAutoAdjustRanges(CLASS, (Configuration)job, enableFeature);
    }

    protected static boolean getAutoAdjustRanges(JobConf job) {
        return InputConfigurator.getAutoAdjustRanges(CLASS, (Configuration)job);
    }

    public static void setScanIsolation(JobConf job, boolean enableFeature) {
        InputConfigurator.setScanIsolation(CLASS, (Configuration)job, enableFeature);
    }

    protected static boolean isIsolated(JobConf job) {
        return InputConfigurator.isIsolated(CLASS, (Configuration)job);
    }

    public static void setLocalIterators(JobConf job, boolean enableFeature) {
        InputConfigurator.setLocalIterators(CLASS, (Configuration)job, enableFeature);
    }

    protected static boolean usesLocalIterators(JobConf job) {
        return InputConfigurator.usesLocalIterators(CLASS, (Configuration)job);
    }

    public static void setOfflineTableScan(JobConf job, boolean enableFeature) {
        InputConfigurator.setOfflineTableScan(CLASS, (Configuration)job, enableFeature);
    }

    protected static boolean isOfflineScan(JobConf job) {
        return InputConfigurator.isOfflineScan(CLASS, (Configuration)job);
    }

    protected static TabletLocator getTabletLocator(JobConf job) throws TableNotFoundException {
        return InputConfigurator.getTabletLocator(CLASS, (Configuration)job);
    }

    protected static void validateOptions(JobConf job) throws IOException {
        InputConfigurator.validateOptions(CLASS, (Configuration)job);
    }

    Map<String, Map<KeyExtent, List<Range>>> binOfflineTable(JobConf job, String tableName, List<Range> ranges) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        HashMap<String, Map<KeyExtent, List<Range>>> binnedRanges = new HashMap<String, Map<KeyExtent, List<Range>>>();
        Instance instance = InputFormatBase.getInstance(job);
        Connector conn = instance.getConnector(InputFormatBase.getPrincipal(job), CredentialHelper.extractToken(InputFormatBase.getTokenClass(job), InputFormatBase.getToken(job)));
        String tableId = Tables.getTableId(instance, tableName);
        if (Tables.getTableState(instance, tableId) != TableState.OFFLINE) {
            Tables.clearCache(instance);
            if (Tables.getTableState(instance, tableId) != TableState.OFFLINE) {
                throw new AccumuloException("Table is online " + tableName + "(" + tableId + ") cannot scan table in offline mode ");
            }
        }
        block0: for (Range range : ranges) {
            Text startRow = range.getStartKey() != null ? range.getStartKey().getRow() : new Text();
            Range metadataRange = new Range(new KeyExtent(new Text(tableId), startRow, null).getMetadataEntry(), true, null, false);
            Scanner scanner = conn.createScanner("!METADATA", Constants.NO_AUTHS);
            Constants.METADATA_PREV_ROW_COLUMN.fetch(scanner);
            scanner.fetchColumnFamily(Constants.METADATA_LAST_LOCATION_COLUMN_FAMILY);
            scanner.fetchColumnFamily(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY);
            scanner.fetchColumnFamily(Constants.METADATA_FUTURE_LOCATION_COLUMN_FAMILY);
            scanner.setRange(metadataRange);
            RowIterator rowIter = new RowIterator(scanner);
            KeyExtent lastExtent = null;
            while (rowIter.hasNext()) {
                ArrayList<Range> rangeList;
                Object row = rowIter.next();
                String last = "";
                KeyExtent extent = null;
                String location = null;
                while (row.hasNext()) {
                    Map.Entry entry = (Map.Entry)row.next();
                    Key key = (Key)entry.getKey();
                    if (key.getColumnFamily().equals((Object)Constants.METADATA_LAST_LOCATION_COLUMN_FAMILY)) {
                        last = ((Value)entry.getValue()).toString();
                    }
                    if (key.getColumnFamily().equals((Object)Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY) || key.getColumnFamily().equals((Object)Constants.METADATA_FUTURE_LOCATION_COLUMN_FAMILY)) {
                        location = ((Value)entry.getValue()).toString();
                    }
                    if (!Constants.METADATA_PREV_ROW_COLUMN.hasColumns(key)) continue;
                    extent = new KeyExtent(key.getRow(), (Value)entry.getValue());
                }
                if (location != null) {
                    return null;
                }
                if (!extent.getTableId().toString().equals(tableId)) {
                    throw new AccumuloException("Saw unexpected table Id " + tableId + " " + extent);
                }
                if (lastExtent != null && !extent.isPreviousExtent(lastExtent)) {
                    throw new AccumuloException(" " + lastExtent + " is not previous extent " + extent);
                }
                HashMap<KeyExtent, ArrayList<Range>> tabletRanges = (HashMap<KeyExtent, ArrayList<Range>>)binnedRanges.get(last);
                if (tabletRanges == null) {
                    tabletRanges = new HashMap<KeyExtent, ArrayList<Range>>();
                    binnedRanges.put(last, tabletRanges);
                }
                if ((rangeList = (ArrayList<Range>)tabletRanges.get(extent)) == null) {
                    rangeList = new ArrayList<Range>();
                    tabletRanges.put(extent, rangeList);
                }
                rangeList.add(range);
                if (extent.getEndRow() == null || range.afterEndKey(new Key(extent.getEndRow()).followingKey(PartialKey.ROW))) continue block0;
                lastExtent = extent;
            }
        }
        return binnedRanges;
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        List<Range> ranges;
        log.setLevel(InputFormatBase.getLogLevel(job));
        InputFormatBase.validateOptions(job);
        String tableName = InputFormatBase.getInputTableName(job);
        boolean autoAdjust = InputFormatBase.getAutoAdjustRanges(job);
        List<Range> list = ranges = autoAdjust ? Range.mergeOverlapping(InputFormatBase.getRanges(job)) : InputFormatBase.getRanges(job);
        if (ranges.isEmpty()) {
            ranges = new ArrayList<Range>(1);
            ranges.add(new Range());
        }
        Map<Object, Object> binnedRanges = new HashMap();
        try {
            if (InputFormatBase.isOfflineScan(job)) {
                binnedRanges = this.binOfflineTable(job, tableName, ranges);
                while (binnedRanges == null) {
                    UtilWaitThread.sleep(100 + (int)(Math.random() * 100.0));
                    binnedRanges = this.binOfflineTable(job, tableName, ranges);
                }
            } else {
                Instance instance = InputFormatBase.getInstance(job);
                String tableId = null;
                TabletLocator tl = InputFormatBase.getTabletLocator(job);
                tl.invalidateCache();
                while (!tl.binRanges(ranges, binnedRanges, new TCredentials(InputFormatBase.getPrincipal(job), InputFormatBase.getTokenClass(job), ByteBuffer.wrap(InputFormatBase.getToken(job)), InputFormatBase.getInstance(job).getInstanceID())).isEmpty()) {
                    if (!(instance instanceof MockInstance)) {
                        if (tableId == null) {
                            tableId = Tables.getTableId(instance, tableName);
                        }
                        if (!Tables.exists(instance, tableId)) {
                            throw new TableDeletedException(tableId);
                        }
                        if (Tables.getTableState(instance, tableId) == TableState.OFFLINE) {
                            throw new TableOfflineException(instance, tableId);
                        }
                    }
                    binnedRanges.clear();
                    log.warn((Object)"Unable to locate bins for specified ranges. Retrying.");
                    UtilWaitThread.sleep(100 + (int)(Math.random() * 100.0));
                    tl.invalidateCache();
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        ArrayList<RangeInputSplit> splits = new ArrayList<RangeInputSplit>(ranges.size());
        HashMap<Range, ArrayList<String>> splitsToAdd = null;
        if (!autoAdjust) {
            splitsToAdd = new HashMap<Range, ArrayList<String>>();
        }
        HashMap<String, String> hostNameCache = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : binnedRanges.entrySet()) {
            String ip = ((String)entry.getKey()).split(":", 2)[0];
            String location = (String)hostNameCache.get(ip);
            if (location == null) {
                InetAddress inetAddress = InetAddress.getByName(ip);
                location = inetAddress.getHostName();
                hostNameCache.put(ip, location);
            }
            for (Map.Entry extentRanges : ((Map)entry.getValue()).entrySet()) {
                Range ke = ((KeyExtent)extentRanges.getKey()).toDataRange();
                for (Range r : (List)extentRanges.getValue()) {
                    if (autoAdjust) {
                        splits.add(new RangeInputSplit(tableName, ke.clip(r), new String[]{location}));
                        continue;
                    }
                    ArrayList<String> locations = (ArrayList<String>)splitsToAdd.get(r);
                    if (locations == null) {
                        locations = new ArrayList<String>(1);
                    }
                    locations.add(location);
                    splitsToAdd.put(r, locations);
                }
            }
        }
        if (!autoAdjust) {
            for (Map.Entry<Object, Object> entry : splitsToAdd.entrySet()) {
                splits.add(new RangeInputSplit(tableName, (Range)entry.getKey(), ((ArrayList)entry.getValue()).toArray(new String[0])));
            }
        }
        return splits.toArray(new InputSplit[splits.size()]);
    }

    public static class RangeInputSplit
    extends InputFormatBase.RangeInputSplit
    implements InputSplit {
        public RangeInputSplit() {
        }

        public RangeInputSplit(RangeInputSplit split) throws IOException {
            super(split);
        }

        protected RangeInputSplit(String table, Range range, String[] locations) {
            super(table, range, locations);
        }
    }

    protected static abstract class RecordReaderBase<K, V>
    implements RecordReader<K, V> {
        protected long numKeysRead;
        protected Iterator<Map.Entry<Key, Value>> scannerIterator;
        protected RangeInputSplit split;
        protected Key currentKey = null;

        protected RecordReaderBase() {
        }

        protected void setupIterators(JobConf job, Scanner scanner) {
            List<IteratorSetting> iterators = InputFormatBase.getIterators(job);
            for (IteratorSetting iterator : iterators) {
                scanner.addScanIterator(iterator);
            }
        }

        public void initialize(InputSplit inSplit, JobConf job) throws IOException {
            Scanner scanner;
            this.split = (RangeInputSplit)inSplit;
            log.debug((Object)("Initializing input split: " + this.split.getRange()));
            Instance instance = InputFormatBase.getInstance(job);
            String user = InputFormatBase.getPrincipal(job);
            String tokenClass = InputFormatBase.getTokenClass(job);
            byte[] password = InputFormatBase.getToken(job);
            Authorizations authorizations = InputFormatBase.getScanAuthorizations(job);
            try {
                log.debug((Object)("Creating connector with user: " + user));
                Connector conn = instance.getConnector(user, CredentialHelper.extractToken(tokenClass, password));
                log.debug((Object)("Creating scanner for table: " + InputFormatBase.getInputTableName(job)));
                log.debug((Object)("Authorizations are: " + authorizations));
                scanner = InputFormatBase.isOfflineScan(job) ? new OfflineScanner(instance, new TCredentials(user, tokenClass, ByteBuffer.wrap(password), instance.getInstanceID()), Tables.getTableId(instance, InputFormatBase.getInputTableName(job)), authorizations) : conn.createScanner(InputFormatBase.getInputTableName(job), authorizations);
                if (InputFormatBase.isIsolated(job)) {
                    log.info((Object)"Creating isolated scanner");
                    scanner = new IsolatedScanner(scanner);
                }
                if (InputFormatBase.usesLocalIterators(job)) {
                    log.info((Object)"Using local iterators");
                    scanner = new ClientSideIteratorScanner(scanner);
                }
                this.setupIterators(job, scanner);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            for (Pair<Text, Text> c : InputFormatBase.getFetchedColumns(job)) {
                if (c.getSecond() != null) {
                    log.debug((Object)("Fetching column " + c.getFirst() + ":" + c.getSecond()));
                    scanner.fetchColumn(c.getFirst(), c.getSecond());
                    continue;
                }
                log.debug((Object)("Fetching column family " + c.getFirst()));
                scanner.fetchColumnFamily(c.getFirst());
            }
            scanner.setRange(this.split.getRange());
            this.numKeysRead = 0L;
            this.scannerIterator = scanner.iterator();
        }

        public void close() {
        }

        public long getPos() throws IOException {
            return this.numKeysRead;
        }

        public float getProgress() throws IOException {
            if (this.numKeysRead > 0L && this.currentKey == null) {
                return 1.0f;
            }
            return this.split.getProgress(this.currentKey);
        }
    }
}

