/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableHistogram;

@InterfaceAudience.Private
public abstract class MutableRangeHistogram
extends MutableHistogram {
    public MutableRangeHistogram(MetricsInfo info) {
        this(info.name(), info.description());
    }

    public MutableRangeHistogram(String name, String description) {
        super(name, description);
    }

    public abstract String getRangeType();

    public abstract long[] getRange();

    public abstract AtomicLongArray getRangeVals();

    @Override
    public void add(long val) {
        super.add(val);
        this.updateBand(val);
    }

    private void updateBand(long val) {
        int i;
        for (i = 0; i < this.getRange().length && val > this.getRange()[i]; ++i) {
        }
        this.getRangeVals().incrementAndGet(i);
    }

    @Override
    public void snapshot(MetricsRecordBuilder metricsRecordBuilder, boolean all) {
        if (all || this.changed()) {
            this.clearChanged();
            this.updateSnapshotMetrics(metricsRecordBuilder);
            this.updateSnapshotRangeMetrics(metricsRecordBuilder);
        }
    }

    public void updateSnapshotRangeMetrics(MetricsRecordBuilder metricsRecordBuilder) {
        long prior = 0L;
        for (int i = 0; i < this.getRange().length; ++i) {
            long val = this.getRangeVals().get(i);
            if (val > 0L) {
                metricsRecordBuilder.addCounter(Interns.info(this.name + "_" + this.getRangeType() + "_" + prior + "-" + this.getRange()[i], this.desc), val);
            }
            prior = this.getRange()[i];
        }
        long val = this.getRangeVals().get(this.getRange().length);
        if (val > 0L) {
            metricsRecordBuilder.addCounter(Interns.info(this.name + "_" + this.getRangeType() + "_" + this.getRange()[this.getRange().length - 1] + "-inf", this.desc), this.getRangeVals().get(this.getRange().length));
        }
    }
}

