/*
 * Decompiled with CFR 0.152.
 */
package sdsu.io;

import java.io.IOException;
import java.io.Writer;
import sdsu.io.ChunkWriter;
import sdsu.io.LabeledObject;
import sdsu.util.Stringizable;

public class StringizableWriter {
    protected static final String META_SEPARATOR_KEY = "DataSeparator";
    protected static final String META_COMMENT_CHAR_KEY = "CommentCharacter";
    protected static final String META_DATA_CHAR_KEY = "MetaDataCharacter";
    protected static final char DEFAULT_COMMENT_CHAR = '#';
    protected static final char DEFAULT_METADATA_CHAR = '$';
    protected static final String DEFAULT_DATA_BLOCK_SEPARATOR = "@DataBlockSeparator@";
    private static final String lineSeparator = System.getProperty("line.separator");
    private String dataBlockSeparator = "@DataBlockSeparator@";
    private char commentChar = (char)35;
    private char metaDataChar = (char)36;
    private ChunkWriter out;

    public StringizableWriter(Writer writer) {
        this.out = new ChunkWriter(writer, DEFAULT_DATA_BLOCK_SEPARATOR);
    }

    public StringizableWriter(Writer writer, String string) throws IOException {
        this.out = new ChunkWriter(writer, string);
        this.dataBlockSeparator = string;
        String string2 = this.commentChar + "All lines starting with " + this.commentChar + this.metaDataChar + " are required to reconstruct objects, do not modify them.";
        String string3 = "" + this.commentChar + this.metaDataChar + " " + META_SEPARATOR_KEY + "=" + this.dataBlockSeparator;
        writer.write(String.valueOf(string2) + lineSeparator + string3);
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    void writeLabeledObject(LabeledObject labeledObject) throws IOException {
        this.out.writeChunk(labeledObject.toString());
    }

    public void writeObject(Stringizable stringizable) throws IOException {
        this.writeLabeledObject(new LabeledObject(stringizable));
    }

    public void writeObject(Stringizable stringizable, String string) throws IOException {
        this.writeLabeledObject(new LabeledObject(stringizable, string));
    }

    public void writeObject(Stringizable stringizable, String string, String string2) throws IOException {
        this.writeLabeledObject(new LabeledObject(stringizable, string, string2));
    }
}

