/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue.clustered.partition;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.controller.queue.clustered.partition.FlowFilePartitioner;
import org.apache.nifi.controller.queue.clustered.partition.QueuePartition;
import org.apache.nifi.controller.repository.FlowFileRecord;

public class RoundRobinPartitioner
implements FlowFilePartitioner {
    private final AtomicLong counter = new AtomicLong(0L);

    @Override
    public QueuePartition getPartition(FlowFileRecord flowFile, QueuePartition[] partitions, QueuePartition localPartition) {
        long count = this.counter.getAndIncrement();
        int index = (int)(count % (long)partitions.length);
        return partitions[index];
    }

    @Override
    public boolean isRebalanceOnClusterResize() {
        return false;
    }

    @Override
    public boolean isRebalanceOnFailure() {
        return true;
    }
}

