/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractLongHashSet;
import io.questdb.std.LongList;
import io.questdb.std.Numbers;
import java.util.Arrays;

public class LongHashSet
extends AbstractLongHashSet {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private final LongList list;

    public LongHashSet() {
        this(16);
    }

    public LongHashSet(int initialCapacity) {
        this(initialCapacity, 0.4, -1L);
    }

    public LongHashSet(int initialCapacity, double loadFactor, long noKeyValue) {
        super(initialCapacity, loadFactor, noKeyValue);
        this.list = new LongList(this.free);
        this.clear();
    }

    public boolean add(long key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            return false;
        }
        this.addAt(index, key);
        return true;
    }

    public void addAt(int index, long key) {
        this.keys[index] = key;
        this.list.add(key);
        if (--this.free < 1) {
            this.rehash();
        }
    }

    @Override
    public final void clear() {
        this.free = this.capacity;
        Arrays.fill(this.keys, this.noEntryKeyValue);
        this.list.clear();
    }

    public boolean contains(long key) {
        return this.keyIndex(key) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongHashSet that = (LongHashSet)o;
        if (this.size() != that.size()) {
            return false;
        }
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            long key = this.list.getQuick(i);
            if (key == this.noEntryKeyValue || !that.excludes(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean excludes(long key) {
        return this.keyIndex(key) > -1;
    }

    public long get(int index) {
        return this.list.getQuick(index);
    }

    public long getLast() {
        return this.list.getLast();
    }

    public int hashCode() {
        int hashCode = 0;
        int n = this.keys.length;
        for (int i = 0; i < n; ++i) {
            if (this.keys[i] == this.noEntryKeyValue) continue;
            hashCode = (int)((long)hashCode + this.keys[i]);
        }
        return hashCode;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0) {
            long key = this.keys[-index - 1];
            super.removeAt(index);
            this.list.remove(key);
        }
    }

    public String toString() {
        return this.list.toString();
    }

    private void rehash() {
        int newCapacity;
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        this.keys = new long[len];
        Arrays.fill(this.keys, this.noEntryKeyValue);
        this.mask = len - 1;
        int n = this.list.size();
        this.free -= n;
        for (int i = 0; i < n; ++i) {
            long key = this.list.getQuick(i);
            int keyIndex = this.keyIndex(key);
            this.keys[keyIndex] = key;
        }
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = this.noEntryKeyValue;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.erase(from);
    }
}

