/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.Long256Function;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;

public class RndLong256FunctionFactory
implements FunctionFactory {
    private static final String SIGNATURE = "rnd_long256()";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new RndFunction();
    }

    private static class RndFunction
    extends Long256Function
    implements Function {
        private final Long256Impl long256A = new Long256Impl();
        private final Long256Impl long256B = new Long256Impl();
        private Rnd rnd;

        private RndFunction() {
        }

        @Override
        public void getLong256(Record rec, CharSink sink) {
            Numbers.appendLong256(this.rnd.nextLong(), this.rnd.nextLong(), this.rnd.nextLong(), this.rnd.nextLong(), sink);
        }

        @Override
        public Long256 getLong256A(Record rec) {
            return this.rndLong(this.long256A);
        }

        @Override
        public Long256 getLong256B(Record rec) {
            return this.rndLong(this.long256B);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(RndLong256FunctionFactory.SIGNATURE);
        }

        @NotNull
        private Long256 rndLong(Long256Impl long256) {
            long256.setAll(this.rnd.nextLong(), this.rnd.nextLong(), this.rnd.nextLong(), this.rnd.nextLong());
            return long256;
        }
    }
}

