/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.GeoHashes;
import io.questdb.cutlass.line.tcp.DirectByteSymbolLookup;
import io.questdb.std.Chars;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Unsafe;
import io.questdb.std.Uuid;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.FloatingDirectCharSink;

public class LineTcpEventBuffer {
    private final long bufLo;
    private final long bufSize;
    private final FloatingDirectCharSink tempSink = new FloatingDirectCharSink();

    public LineTcpEventBuffer(long bufLo, long bufSize) {
        this.bufLo = bufLo;
        this.bufSize = bufLo + bufSize;
    }

    public long addBoolean(long address, byte value) {
        this.checkCapacity(address, 2);
        Unsafe.getUnsafe().putByte(address, (byte)6);
        Unsafe.getUnsafe().putByte(address + 1L, value);
        return address + 1L + 1L;
    }

    public long addByte(long address, byte value) {
        this.checkCapacity(address, 2);
        Unsafe.getUnsafe().putByte(address, (byte)17);
        Unsafe.getUnsafe().putByte(address + 1L, value);
        return address + 1L + 1L;
    }

    public long addChar(long address, char value) {
        this.checkCapacity(address, 3);
        Unsafe.getUnsafe().putByte(address, (byte)19);
        Unsafe.getUnsafe().putChar(address + 1L, value);
        return address + 2L + 1L;
    }

    public long addColumnIndex(long address, int colIndex) {
        this.checkCapacity(address, 4);
        Unsafe.getUnsafe().putInt(address, colIndex);
        return address + 4L;
    }

    public long addColumnName(long address, CharSequence colName) {
        int length = colName.length();
        int capacity = 4 + 2 * length;
        this.checkCapacity(address, capacity);
        Unsafe.getUnsafe().putInt(address, -1 * length);
        Chars.copyStrChars(colName, 0, length, address + 4L);
        return address + (long)capacity;
    }

    public long addDate(long address, long value) {
        this.checkCapacity(address, 9);
        Unsafe.getUnsafe().putByte(address, (byte)18);
        Unsafe.getUnsafe().putLong(address + 1L, value);
        return address + 8L + 1L;
    }

    public void addDesignatedTimestamp(long address, long timestamp) {
        this.checkCapacity(address, 8);
        Unsafe.getUnsafe().putLong(address, timestamp);
    }

    public long addDouble(long address, double value) {
        this.checkCapacity(address, 9);
        Unsafe.getUnsafe().putByte(address, (byte)15);
        Unsafe.getUnsafe().putDouble(address + 1L, value);
        return address + 8L + 1L;
    }

    public long addFloat(long address, float value) {
        this.checkCapacity(address, 5);
        Unsafe.getUnsafe().putByte(address, (byte)2);
        Unsafe.getUnsafe().putFloat(address + 1L, value);
        return address + 4L + 1L;
    }

    public long addGeoHash(long address, DirectByteCharSequence value, int colTypeMeta) {
        long geohash;
        try {
            geohash = GeoHashes.fromStringTruncatingNl(value.getLo(), value.getHi(), Numbers.decodeLowShort(colTypeMeta));
        }
        catch (NumericException e) {
            geohash = -1L;
        }
        switch (Numbers.decodeHighShort(colTypeMeta)) {
            default: {
                this.checkCapacity(address, 9);
                Unsafe.getUnsafe().putByte(address, (byte)12);
                Unsafe.getUnsafe().putLong(address + 1L, geohash);
                return address + 8L + 1L;
            }
            case 16: {
                this.checkCapacity(address, 5);
                Unsafe.getUnsafe().putByte(address, (byte)11);
                Unsafe.getUnsafe().putInt(address + 1L, (int)geohash);
                return address + 4L + 1L;
            }
            case 15: {
                this.checkCapacity(address, 3);
                Unsafe.getUnsafe().putByte(address, (byte)10);
                Unsafe.getUnsafe().putShort(address + 1L, (short)geohash);
                return address + 2L + 1L;
            }
            case 14: 
        }
        this.checkCapacity(address, 2);
        Unsafe.getUnsafe().putByte(address, (byte)9);
        Unsafe.getUnsafe().putByte(address + 1L, (byte)geohash);
        return address + 1L + 1L;
    }

    public long addInt(long address, int value) {
        this.checkCapacity(address, 5);
        Unsafe.getUnsafe().putByte(address, (byte)3);
        Unsafe.getUnsafe().putInt(address + 1L, value);
        return address + 4L + 1L;
    }

    public long addLong(long address, long value) {
        this.checkCapacity(address, 9);
        Unsafe.getUnsafe().putByte(address, (byte)14);
        Unsafe.getUnsafe().putLong(address + 1L, value);
        return address + 8L + 1L;
    }

    public long addLong256(long address, DirectByteCharSequence value, boolean hasNonAsciiChars) {
        return this.addString(address, value, hasNonAsciiChars, (byte)7);
    }

    public long addNull(long address) {
        this.checkCapacity(address, 1);
        Unsafe.getUnsafe().putByte(address, (byte)0);
        return address + 1L;
    }

    public void addNumOfColumns(long address, int numOfColumns) {
        this.checkCapacity(address, 4);
        Unsafe.getUnsafe().putInt(address, numOfColumns);
    }

    public long addShort(long address, short value) {
        this.checkCapacity(address, 3);
        Unsafe.getUnsafe().putByte(address, (byte)16);
        Unsafe.getUnsafe().putShort(address + 1L, value);
        return address + 2L + 1L;
    }

    public long addString(long address, DirectByteCharSequence value, boolean hasNonAsciiChars) {
        return this.addString(address, value, hasNonAsciiChars, (byte)4);
    }

    public void addStructureVersion(long address, long structureVersion) {
        this.checkCapacity(address, 8);
        Unsafe.getUnsafe().putLong(address, structureVersion);
    }

    public long addSymbol(long address, DirectByteCharSequence value, boolean hasNonAsciiChars, DirectByteSymbolLookup symbolLookup) {
        int maxLen = 2 * value.length();
        this.checkCapacity(address, 5 + maxLen);
        long strPos = address + 1L + 4L;
        this.tempSink.of(strPos, strPos + (long)maxLen);
        int symIndex = symbolLookup.keyOf(value);
        if (symIndex != -2) {
            Unsafe.getUnsafe().putByte(address, (byte)8);
            Unsafe.getUnsafe().putInt(address + 1L, symIndex);
            return address + 4L + 1L;
        }
        if (!hasNonAsciiChars) {
            this.tempSink.put(value);
        } else {
            Chars.utf8ToUtf16(value, this.tempSink, true);
        }
        int length = this.tempSink.length();
        Unsafe.getUnsafe().putByte(address, (byte)1);
        Unsafe.getUnsafe().putInt(address + 1L, length);
        return address + (long)length * 2L + 4L + 1L;
    }

    public long addTimestamp(long address, long value) {
        this.checkCapacity(address, 9);
        Unsafe.getUnsafe().putByte(address, (byte)13);
        Unsafe.getUnsafe().putLong(address + 1L, value);
        return address + 8L + 1L;
    }

    public long addUuid(long offset, DirectByteCharSequence value) throws NumericException {
        this.checkCapacity(offset, 17);
        Uuid.checkDashesAndLength(value);
        long hi = Uuid.parseHi(value);
        long lo = Uuid.parseLo(value);
        Unsafe.getUnsafe().putByte(offset, (byte)20);
        Unsafe.getUnsafe().putLong(++offset, lo);
        Unsafe.getUnsafe().putLong(offset += 8L, hi);
        return offset + 8L;
    }

    public long columnValueLength(byte entityType, long offset) {
        switch (entityType) {
            case 1: 
            case 4: 
            case 7: {
                CharSequence cs = this.readUtf16Chars(offset);
                return (long)cs.length() * 2L + 4L;
            }
            case 6: 
            case 9: 
            case 17: {
                return 1L;
            }
            case 10: 
            case 16: {
                return 2L;
            }
            case 19: {
                return 2L;
            }
            case 3: 
            case 8: 
            case 11: {
                return 4L;
            }
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                return 8L;
            }
            case 2: {
                return 4L;
            }
            case 15: {
                return 8L;
            }
            case 20: {
                return 16L;
            }
            case 0: {
                return 0L;
            }
        }
        throw new UnsupportedOperationException("entityType " + entityType + " is not implemented!");
    }

    public long getAddress() {
        return this.bufLo;
    }

    public long getAddressAfterHeader() {
        return this.bufLo + 16L + 4L;
    }

    public byte readByte(long address) {
        return Unsafe.getUnsafe().getByte(address);
    }

    public char readChar(long address) {
        return Unsafe.getUnsafe().getChar(address);
    }

    public double readDouble(long address) {
        return Unsafe.getUnsafe().getDouble(address);
    }

    public float readFloat(long address) {
        return Unsafe.getUnsafe().getFloat(address);
    }

    public int readInt(long address) {
        return Unsafe.getUnsafe().getInt(address);
    }

    public long readLong(long address) {
        return Unsafe.getUnsafe().getLong(address);
    }

    public short readShort(long address) {
        return Unsafe.getUnsafe().getShort(address);
    }

    public CharSequence readUtf16Chars(long address) {
        int len = this.readInt(address);
        return this.readUtf16Chars(address + 4L, len);
    }

    public CharSequence readUtf16Chars(long address, int length) {
        return this.tempSink.asCharSequence(address, address + (long)length * 2L);
    }

    private long addString(long address, DirectByteCharSequence value, boolean hasNonAsciiChars, byte entityTypeString) {
        int maxLen = 2 * value.length();
        this.checkCapacity(address, 5 + maxLen);
        long strPos = address + 1L + 4L;
        this.tempSink.of(strPos, strPos + (long)maxLen);
        if (hasNonAsciiChars) {
            Chars.utf8ToUtf16Unchecked(value, this.tempSink);
        } else {
            this.tempSink.put(value);
        }
        int length = this.tempSink.length();
        Unsafe.getUnsafe().putByte(address, entityTypeString);
        Unsafe.getUnsafe().putInt(address + 1L, length);
        return address + (long)length * 2L + 4L + 1L;
    }

    private void checkCapacity(long address, int length) {
        if (address + (long)length > this.bufSize) {
            throw CairoException.critical(0).put("queue buffer overflow");
        }
    }
}

