/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.resource;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.resource.StringContentResourceLoader;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.skin.SkinFactory;
import org.apache.myfaces.trinidadinternal.share.nls.LocaleContextImpl;
import org.apache.myfaces.trinidadinternal.util.nls.LocaleUtils;

public abstract class TranslationsResourceLoader
extends StringContentResourceLoader {
    private static final String _CONTENT_TYPE = "text/javascript";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TranslationsResourceLoader.class);

    public TranslationsResourceLoader(String path) {
        super(path);
    }

    protected abstract String getJSVarName();

    protected abstract String getBundleName();

    protected int getDefaultSize() {
        return 10000;
    }

    protected String getLocaleString(FacesContext context) {
        Object localeObj = context.getExternalContext().getRequestParameterMap().get("loc");
        return localeObj == null || "".equals(localeObj) ? null : localeObj.toString();
    }

    protected String getContentType(String path) {
        return _CONTENT_TYPE;
    }

    protected URL findResource(String path) throws IOException {
        return this.getURL(path);
    }

    protected String getString(String path) throws IOException {
        ResourceBundle bundle;
        Locale locale;
        FacesContext context = FacesContext.getCurrentInstance();
        String localeStr = this.getLocaleString(context);
        if (localeStr != null) {
            localeStr = localeStr.replace('_', '-');
        }
        if ((locale = LocaleUtils.getLocaleForIANAString(localeStr)) == null) {
            locale = Locale.getDefault();
        }
        try {
            bundle = this._getResourceBundle(locale);
        }
        catch (MissingResourceException mre) {
            _LOG.severe("CANNOT_FIND_BUNDLE", (Object)this.getBundleName());
            _LOG.severe((Throwable)mre);
            return "/* COULD NOT FIND BUNDLE " + this.getBundleName() + " */";
        }
        ResourceBundle applicationBundle = this._getApplicationFacesMessageBundle(context, locale);
        HashMap<String, String> messages = new HashMap<String, String>();
        this._addMessagesToMap(messages, bundle);
        if (applicationBundle != null) {
            this._addMessagesToMap(messages, applicationBundle, true);
        }
        StringBuilder builder = new StringBuilder(this.getDefaultSize());
        builder.append(this.getJSVarName()).append("=").append("{\n");
        this._processBundle(context, builder, messages, locale);
        builder.append("\n}");
        return builder.toString();
    }

    private ResourceBundle _getResourceBundle(Locale locale) throws MissingResourceException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return ResourceBundle.getBundle(this.getBundleName(), locale, loader);
    }

    private ResourceBundle _getApplicationFacesMessageBundle(FacesContext context, Locale locale) {
        assert (context != null);
        assert (locale != null);
        Application application = context.getApplication();
        if (application == null) {
            return null;
        }
        String bundleName = application.getMessageBundle();
        if (bundleName == null) {
            return null;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return ResourceBundle.getBundle(bundleName, locale, loader);
        }
        catch (MissingResourceException missingResource) {
            _LOG.warning("Unable to load faces-config.xml defined message bundle {0}", (Object)bundleName);
            _LOG.warning((Throwable)missingResource);
            return null;
        }
    }

    protected Skin getSkin(FacesContext context) {
        Skin skin = null;
        SkinFactory skinFactory = SkinFactory.getFactory();
        Object skinIdObj = context.getExternalContext().getRequestParameterMap().get("skinId");
        if (skinIdObj != null) {
            skin = skinFactory.getSkin(context, skinIdObj.toString());
        }
        return skin;
    }

    private void _addMessagesToMap(Map<String, String> map, ResourceBundle bundle, boolean onlyReplaceExisting) {
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = null;
            if (onlyReplaceExisting) {
                if (!map.containsKey(key)) continue;
                value = bundle.getString(key);
                map.put(key, value);
                continue;
            }
            value = bundle.getString(key);
            map.put(key, value);
        }
    }

    private void _addMessagesToMap(Map<String, String> map, ResourceBundle bundle) {
        this._addMessagesToMap(map, bundle, false);
    }

    private void _processBundle(FacesContext context, StringBuilder builder, Map<String, String> messages, Locale locale) {
        Skin skin = this.getSkin(context);
        LocaleContextImpl lc = new LocaleContextImpl(locale);
        Set<String> keys = messages.keySet();
        boolean writtenOne = false;
        Iterator<String> iterator = keys.iterator();
        while (iterator.hasNext()) {
            if (writtenOne) {
                builder.append(",\n");
            } else {
                writtenOne = true;
            }
            String key = iterator.next();
            String value = skin == null ? messages.get(key) : skin.getTranslatedString((LocaleContext)lc, key);
            builder.append("'");
            builder.append(key);
            builder.append("':'");
            this._appendUnicodeString(builder, value);
            builder.append("'");
        }
    }

    private void _appendUnicodeString(StringBuilder builder, String value) {
        if (value == null) {
            return;
        }
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u0080') {
                if (c == '\'') {
                    builder.append("\\'");
                    continue;
                }
                if (c == '\\') {
                    builder.append("\\\\");
                    continue;
                }
                builder.append(c);
                continue;
            }
            builder.append("\\u");
            String hex = Integer.toHexString(c);
            int hexLen = hex.length();
            if (hexLen == 1) {
                builder.append("000");
            } else if (hexLen == 2) {
                builder.append("00");
            } else if (hexLen == 3) {
                builder.append("0");
            }
            builder.append(hex);
        }
    }
}

