/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.model.TreeLocalRowKeyIndex;

public abstract class TreeModel
extends CollectionModel
implements TreeLocalRowKeyIndex {
    public abstract boolean isContainer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContainerEmpty() {
        if (!this.isContainer()) {
            return true;
        }
        this.enterContainer();
        try {
            int kids = this.getRowCount();
            if (kids < 0) {
                this.setRowIndex(0);
                boolean bl = !this.isRowAvailable();
                return bl;
            }
            boolean bl = kids == 0;
            return bl;
        }
        finally {
            this.exitContainer();
        }
    }

    public abstract void enterContainer();

    public abstract void exitContainer();

    public final Object getContainerRowKey() {
        Object key = this.getRowKey();
        Object parentKey = this.getContainerRowKey(key);
        return parentKey;
    }

    public List<Object> getAllAncestorContainerRowKeys(Object childRowKey) {
        if (childRowKey == null) {
            return Collections.emptyList();
        }
        int size = this.getDepth(childRowKey);
        if (size <= 0) {
            return Collections.emptyList();
        }
        Object[] keys = new Object[size];
        for (int i = size - 1; i >= 0; --i) {
            childRowKey = this.getContainerRowKey(childRowKey);
            assert (childRowKey != null);
            keys[i] = childRowKey;
        }
        return Collections.unmodifiableList(Arrays.asList(keys));
    }

    public abstract Object getContainerRowKey(Object var1);

    public final int getDepth() {
        Object key = this.getRowKey();
        return this.getDepth(key);
    }

    public int getDepth(Object rowKey) {
        Object key = rowKey;
        int depth = 0;
        while ((key = this.getContainerRowKey(key)) != null) {
            ++depth;
        }
        return depth;
    }

    @Override
    public boolean isChildCollectionLocallyAvailable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChildCollectionLocallyAvailable(int index) {
        if (this.isRowLocallyAvailable(index)) {
            int oldIndex = this.getRowIndex();
            try {
                this.setRowIndex(index);
                boolean bl = this.isChildCollectionLocallyAvailable();
                return bl;
            }
            finally {
                this.setRowIndex(oldIndex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChildCollectionLocallyAvailable(Object rowKey) {
        if (this.isRowLocallyAvailable(rowKey)) {
            Object oldKey = this.getRowKey();
            try {
                this.setRowKey(rowKey);
                boolean bl = this.isChildCollectionLocallyAvailable();
                return bl;
            }
            finally {
                this.setRowKey(oldKey);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areRowsLocallyAvailable(int startIndex, int rowCount, RowKeySet disclosedRowKeys) {
        boolean available = false;
        if (this.isRowLocallyAvailable(startIndex)) {
            Object oldKey = this.getRowKey();
            try {
                this.setRowIndex(startIndex);
                available = this.areRowsLocallyAvailable(rowCount, disclosedRowKeys);
            }
            finally {
                this.setRowKey(oldKey);
            }
        }
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areRowsLocallyAvailable(Object startRowKey, int rowCount, RowKeySet disclosedRowKeys) {
        boolean available = false;
        if (this.isRowLocallyAvailable(startRowKey)) {
            Object oldKey = this.getRowKey();
            try {
                this.setRowKey(startRowKey);
                available = this.areRowsLocallyAvailable(rowCount, disclosedRowKeys);
            }
            finally {
                this.setRowKey(oldKey);
            }
        }
        return available;
    }

    @Override
    public boolean areRowsLocallyAvailable(int rowCount, RowKeySet disclosedRowKeys) {
        boolean available = false;
        Object startingRowKey = this.getRowKey();
        if (startingRowKey != null) {
            available = this._areRowsLocallyAvailable(startingRowKey, rowCount, disclosedRowKeys);
        }
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _areRowsLocallyAvailable(Object rowKey, int count, RowKeySet disclosedRows) {
        if (!this.isRowLocallyAvailable(rowKey)) {
            return false;
        }
        Object oldKey = this.getRowKey();
        try {
            this.setRowKey(rowKey);
            int startIndex = this.getRowIndex();
            while ((count = this._walkAvailableNodes(startIndex, count, disclosedRows)) > 0 && this.getDepth() > 0) {
                this.exitContainer();
                startIndex = this.getRowIndex();
                ++startIndex;
            }
            boolean bl = count >= 0;
            return bl;
        }
        finally {
            this.setRowKey(oldKey);
        }
    }

    private int _walkAvailableNodes(int startIndex, int count, RowKeySet disclosedRows) {
        int rowCount = this.getRowCount();
        if (rowCount < 0) {
            return -1;
        }
        for (int index = startIndex; index < rowCount && count > 0; ++index) {
            if (!this.isRowLocallyAvailable(index)) {
                return -1;
            }
            --count;
            this.setRowIndex(index);
            Object key = this.getRowKey();
            if (!disclosedRows.contains(key)) continue;
            if (this.isChildCollectionLocallyAvailable()) {
                this.enterContainer();
                this.setRowIndex(0);
                count = this._walkAvailableNodes(0, count, disclosedRows);
                if (count < 0) {
                    return -1;
                }
                this.exitContainer();
                continue;
            }
            return -1;
        }
        return count;
    }
}

