/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.facelets;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public abstract class MetaTagHandler
extends TagHandler {
    private Class lastType = Object.class;
    private Metadata mapper;

    public MetaTagHandler(TagConfig config) {
        super(config);
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        assert (type != null);
        return new MetaRulesetImpl(this.tag, type);
    }

    protected void setAttributes(FaceletContext ctx, Object instance) {
        if (instance != null) {
            Class<?> type = instance.getClass();
            if (this.mapper == null || !this.lastType.equals(type)) {
                this.lastType = type;
                this.mapper = this.createMetaRuleset(type).finish();
            }
            this.mapper.applyMetadata(ctx, instance);
        }
    }

    private static class MetadataTargetImpl
    extends MetadataTarget {
        private final Map pd;
        private final Class type;

        public MetadataTargetImpl(Class type) throws IntrospectionException {
            this.type = type;
            this.pd = new HashMap();
            BeanInfo info = Introspector.getBeanInfo(type);
            PropertyDescriptor[] pda = info.getPropertyDescriptors();
            for (int i = 0; i < pda.length; ++i) {
                this.pd.put(pda[i].getName(), pda[i]);
            }
        }

        public PropertyDescriptor getProperty(String name) {
            return (PropertyDescriptor)this.pd.get(name);
        }

        public boolean isTargetInstanceOf(Class type) {
            return type.isAssignableFrom(this.type);
        }

        public Class getTargetClass() {
            return this.type;
        }

        public Class getPropertyType(String name) {
            PropertyDescriptor pd = this.getProperty(name);
            if (pd != null) {
                return pd.getPropertyType();
            }
            return null;
        }

        public Method getWriteMethod(String name) {
            PropertyDescriptor pd = this.getProperty(name);
            if (pd != null) {
                return pd.getWriteMethod();
            }
            return null;
        }

        public Method getReadMethod(String name) {
            PropertyDescriptor pd = this.getProperty(name);
            if (pd != null) {
                return pd.getReadMethod();
            }
            return null;
        }
    }

    private static class MetaRulesetImpl
    extends MetaRuleset {
        private static final WeakHashMap metadata = new WeakHashMap();
        private static final TrinidadLogger log = TrinidadLogger.createTrinidadLogger(MetaRulesetImpl.class);
        private final Tag tag;
        private final Class type;
        private final Map attributes;
        private final List mappers;
        private final List rules;
        private static final Metadata NONE = new Metadata(){

            public void applyMetadata(FaceletContext ctx, Object instance) {
            }
        };

        public MetaRulesetImpl(Tag tag, Class type) {
            this.tag = tag;
            this.type = type;
            this.attributes = new HashMap();
            this.mappers = new ArrayList();
            this.rules = new ArrayList();
            TagAttribute[] attrs = this.tag.getAttributes().getAll();
            for (int i = 0; i < attrs.length; ++i) {
                this.attributes.put(attrs[i].getLocalName(), attrs[i]);
            }
            this.rules.add(BeanPropertyTagRule.Instance);
        }

        public MetaRuleset ignore(String attribute) {
            assert (attribute != null);
            this.attributes.remove(attribute);
            return this;
        }

        public MetaRuleset alias(String attribute, String property) {
            assert (attribute != null);
            assert (property != null);
            TagAttribute attr = (TagAttribute)this.attributes.remove(attribute);
            if (attr != null) {
                this.attributes.put(property, attr);
            }
            return this;
        }

        public MetaRuleset add(Metadata mapper) {
            assert (mapper != null);
            if (!this.mappers.contains(mapper)) {
                this.mappers.add(mapper);
            }
            return this;
        }

        public MetaRuleset addRule(MetaRule rule) {
            assert (rule != null);
            this.rules.add(rule);
            return this;
        }

        private final MetadataTarget getMetadataTarget() {
            String key = this.type.getName();
            MetadataTarget meta = (MetadataTarget)metadata.get(key);
            if (meta == null) {
                try {
                    meta = new MetadataTargetImpl(this.type);
                }
                catch (IntrospectionException e) {
                    throw new TagException(this.tag, "Error Creating TargetMetadata", (Throwable)e);
                }
                metadata.put(key, meta);
            }
            return meta;
        }

        public Metadata finish() {
            if (!this.attributes.isEmpty()) {
                if (this.rules.isEmpty()) {
                    if (log.isLoggable(Level.SEVERE)) {
                        Iterator itr = this.attributes.values().iterator();
                        while (itr.hasNext()) {
                            log.severe(itr.next() + " Unhandled by MetaTagHandler for type " + this.type.getName());
                        }
                    }
                } else {
                    MetadataTarget target = this.getMetadataTarget();
                    int ruleEnd = this.rules.size() - 1;
                    for (Map.Entry entry : this.attributes.entrySet()) {
                        Metadata data = null;
                        for (int i = ruleEnd; data == null && i >= 0; --i) {
                            MetaRule rule = (MetaRule)this.rules.get(i);
                            data = rule.applyRule((String)entry.getKey(), (TagAttribute)entry.getValue(), target);
                        }
                        if (data == null) {
                            if (!log.isLoggable(Level.SEVERE)) continue;
                            log.severe(entry.getValue() + " Unhandled by MetaTagHandler for type " + this.type.getName());
                            continue;
                        }
                        this.mappers.add(data);
                    }
                }
            }
            if (this.mappers.isEmpty()) {
                return NONE;
            }
            return new MetadataImpl(this.mappers.toArray(new Metadata[this.mappers.size()]));
        }

        public MetaRuleset ignoreAll() {
            this.attributes.clear();
            return this;
        }

        static final class MetadataImpl
        extends Metadata {
            private final Metadata[] mappers;
            private final int size;

            public MetadataImpl(Metadata[] mappers) {
                this.mappers = mappers;
                this.size = mappers.length;
            }

            public void applyMetadata(FaceletContext ctx, Object instance) {
                for (int i = 0; i < this.size; ++i) {
                    this.mappers[i].applyMetadata(ctx, instance);
                }
            }
        }
    }

    private static class BeanPropertyTagRule
    extends MetaRule {
        public static final BeanPropertyTagRule Instance = new BeanPropertyTagRule();

        private BeanPropertyTagRule() {
        }

        public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
            Method m = meta.getWriteMethod(name);
            if (m != null) {
                if (attribute.isLiteral()) {
                    return new LiteralPropertyMetadata(m, attribute);
                }
                return new DynamicPropertyMetadata(m, attribute);
            }
            return null;
        }

        static final class DynamicPropertyMetadata
        extends Metadata {
            private final Method method;
            private final TagAttribute attribute;
            private final Class type;

            public DynamicPropertyMetadata(Method method, TagAttribute attribute) {
                this.method = method;
                this.type = method.getParameterTypes()[0];
                this.attribute = attribute;
            }

            public void applyMetadata(FaceletContext ctx, Object instance) {
                try {
                    this.method.invoke(instance, this.attribute.getObject(ctx, this.type));
                }
                catch (InvocationTargetException e) {
                    throw new TagAttributeException(this.attribute, e.getCause());
                }
                catch (Exception e) {
                    throw new TagAttributeException(this.attribute, (Throwable)e);
                }
            }
        }

        static final class LiteralPropertyMetadata
        extends Metadata {
            private final Method method;
            private final TagAttribute attribute;
            private Object[] value;

            public LiteralPropertyMetadata(Method method, TagAttribute attribute) {
                this.method = method;
                this.attribute = attribute;
            }

            public void applyMetadata(FaceletContext ctx, Object instance) {
                if (this.value == null) {
                    String str = this.attribute.getValue();
                    this.value = new Object[]{ctx.getExpressionFactory().coerceToType((Object)str, this.method.getParameterTypes()[0])};
                }
                try {
                    this.method.invoke(instance, this.value);
                }
                catch (InvocationTargetException e) {
                    throw new TagAttributeException(this.attribute, e.getCause());
                }
                catch (Exception e) {
                    throw new TagAttributeException(this.attribute, (Throwable)e);
                }
            }
        }
    }
}

