/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.io;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidadinternal.io.ResponseWriterDecorator;

public class IndentingResponseWriter
extends ResponseWriterDecorator {
    private boolean _justEndedElement;
    private int _depth;
    private int _spacesPer;
    private boolean _isHtml;
    private static final int _MAX_INDENT = 50;
    private static final int _DEFAULT_SPACES_PER_LEVEL = 2;
    private static final char[] _sSpaces = new char[50];
    private static final Set<String> _HTML_TYPES;
    private static final Set<String> _WHITESPACE_SENSITIVE_ELEMENTS;

    public IndentingResponseWriter(ResponseWriter decorated) {
        this(decorated, 2);
    }

    public IndentingResponseWriter(ResponseWriter decorated, int spacesPerLevel) {
        super(decorated);
        this._spacesPer = spacesPerLevel;
        this._isHtml = _HTML_TYPES.contains(decorated.getContentType());
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return new IndentingResponseWriter(this.getResponseWriter().cloneWithWriter(writer));
    }

    public void startElement(String name, UIComponent component) throws IOException {
        int depth;
        if ((depth = this._depth++) > 0 && !this._isWhiteSpaceSensitive(name)) {
            this._writeIndent(depth);
        }
        this._justEndedElement = false;
        super.startElement(name, component);
    }

    public void endElement(String name) throws IOException {
        --this._depth;
        this._seeIfJustEndedElement();
        super.endElement(name);
        if (!this._isWhiteSpaceSensitive(name)) {
            this._justEndedElement = true;
        }
    }

    public void writeComment(Object comment) throws IOException {
        this._seeIfJustEndedElement();
        super.writeComment(comment);
    }

    public void writeText(Object text, UIComponent component, String componentPropertyName) throws IOException {
        this._seeIfJustEndedElement();
        super.writeText(text, component, componentPropertyName);
    }

    public void writeText(Object text, String componentPropertyName) throws IOException {
        this._seeIfJustEndedElement();
        super.writeText(text, componentPropertyName);
    }

    public void writeText(char[] text, int start, int length) throws IOException {
        this._seeIfJustEndedElement();
        super.writeText(text, start, length);
    }

    public void write(String text) throws IOException {
        this._seeIfJustEndedElement();
        super.write(text);
    }

    public void write(String str, int off, int len) throws IOException {
        this._seeIfJustEndedElement();
        super.write(str, off, len);
    }

    public void write(char[] text, int start, int length) throws IOException {
        this._seeIfJustEndedElement();
        super.write(text, start, length);
    }

    public void write(char[] text) throws IOException {
        this._seeIfJustEndedElement();
        super.write(text);
    }

    public void write(int c) throws IOException {
        this._seeIfJustEndedElement();
        super.write(c);
    }

    private void _seeIfJustEndedElement() throws IOException {
        if (this._justEndedElement) {
            this._justEndedElement = false;
            this._writeIndent(this._depth);
        }
    }

    private void _writeIndent(int depth) throws IOException {
        if ((depth *= this._spacesPer) > 50) {
            depth = 50;
        }
        this.writeText("\n", null);
        if (depth > 0) {
            super.write(_sSpaces, 0, depth);
        }
    }

    private boolean _isWhiteSpaceSensitive(String element) {
        if (!this._isHtml) {
            return false;
        }
        String name = element.toLowerCase();
        return _WHITESPACE_SENSITIVE_ELEMENTS.contains(name);
    }

    static {
        for (int i = 0; i < 50; ++i) {
            IndentingResponseWriter._sSpaces[i] = 32;
        }
        _HTML_TYPES = new HashSet<String>();
        _HTML_TYPES.add("text/html");
        _HTML_TYPES.add("application/xhtml+xml");
        _WHITESPACE_SENSITIVE_ELEMENTS = new HashSet<String>();
        _WHITESPACE_SENSITIVE_ELEMENTS.add("img");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("a");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("br");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("span");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("select");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("div");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("area");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("u");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("i");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("input");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("b");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("em");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("strong");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("map");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("label");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("font");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("table");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("tbody");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("tr");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("nobr");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("wbr");
        _WHITESPACE_SENSITIVE_ELEMENTS.add("script");
    }
}

