/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.openapi3;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.openapi3.HeaderInfo;
import org.apache.juneau.dto.openapi3.Link;
import org.apache.juneau.dto.openapi3.MediaType;
import org.apache.juneau.dto.openapi3.OpenApiElement;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;

@Bean(properties="contentType,style,explode,headers,allowReserved,*")
@FluentSetters
public class Response
extends OpenApiElement {
    private String description;
    private Map<String, HeaderInfo> headers;
    private Map<String, MediaType> content;
    private Map<String, Link> links;

    public Response() {
    }

    public Response(Response copyFrom) {
        super(copyFrom);
        this.description = copyFrom.description;
        if (copyFrom.headers == null) {
            this.headers = null;
        } else {
            this.headers = new LinkedHashMap<String, HeaderInfo>();
            for (Map.Entry<String, HeaderInfo> entry : copyFrom.headers.entrySet()) {
                this.headers.put(entry.getKey(), entry.getValue().copy());
            }
        }
        if (copyFrom.content == null) {
            this.content = null;
        } else {
            this.content = new LinkedHashMap<String, MediaType>();
            for (Map.Entry<String, OpenApiElement> entry : copyFrom.content.entrySet()) {
                this.content.put(entry.getKey(), ((MediaType)entry.getValue()).copy());
            }
        }
        if (copyFrom.links == null) {
            this.links = null;
        } else {
            this.links = new LinkedHashMap<String, Link>();
            for (Map.Entry<String, OpenApiElement> entry : copyFrom.links.entrySet()) {
                this.links.put(entry.getKey(), ((Link)entry.getValue()).copy());
            }
        }
    }

    public Response copy() {
        return new Response(this);
    }

    @Override
    protected Response strict() {
        super.strict();
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Response setDescription(String value) {
        this.description = value;
        return this;
    }

    public Map<String, HeaderInfo> getHeaders() {
        return this.headers;
    }

    public Response setHeaders(Map<String, HeaderInfo> value) {
        this.headers = CollectionUtils.copyOf(value);
        return this;
    }

    public Response addHeader(String key, HeaderInfo value) {
        this.headers = CollectionUtils.mapBuilder(this.headers).sparse().add(key, value).build();
        return this;
    }

    public Map<String, MediaType> getContent() {
        return this.content;
    }

    public Response setContent(Map<String, MediaType> value) {
        this.content = CollectionUtils.copyOf(value);
        return this;
    }

    public Response addContent(String key, MediaType value) {
        this.content = CollectionUtils.mapBuilder(this.content).sparse().add(key, value).build();
        return this;
    }

    public Map<String, Link> getLinks() {
        return this.links;
    }

    public Response setLinks(Map<String, Link> value) {
        this.links = CollectionUtils.copyOf(value);
        return this;
    }

    public Response addLink(String key, Link value) {
        this.links = CollectionUtils.mapBuilder(this.links).sparse().add(key, value).build();
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "description": {
                return ConverterUtils.toType(this.getDescription(), type);
            }
            case "content": {
                return ConverterUtils.toType(this.getContent(), type);
            }
            case "headers": {
                return ConverterUtils.toType(this.getHeaders(), type);
            }
            case "links": {
                return ConverterUtils.toType(this.getLinks(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Response set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "description": {
                return this.setDescription(StringUtils.stringify(value));
            }
            case "headers": {
                return this.setHeaders(CollectionUtils.mapBuilder(String.class, HeaderInfo.class, new Type[0]).sparse().addAny(value).build());
            }
            case "content": {
                return this.setContent(CollectionUtils.mapBuilder(String.class, MediaType.class, new Type[0]).sparse().addAny(value).build());
            }
            case "links": {
                return this.setLinks(CollectionUtils.mapBuilder(String.class, Link.class, new Type[0]).sparse().addAny(value).build());
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setBuilder(String.class, new Type[0]).addIf(this.description != null, "description").addIf(this.headers != null, "headers").addIf(this.content != null, "content").addIf(this.links != null, "links").build();
        return new MultiSet<String>(s, super.keySet());
    }
}

