/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.serialization;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.serialization.QuadsToJsonld;
import com.apicatalog.jsonld.uri.UriValidationPolicy;
import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.RdfNQuad;
import com.apicatalog.rdf.RdfValue;
import com.apicatalog.rdf.api.RdfConsumerException;
import jakarta.json.JsonArray;

@Deprecated
public final class RdfToJsonld {
    private final RdfDataset dataset;
    private boolean ordered;
    private JsonLdOptions.RdfDirection rdfDirection;
    private boolean useNativeTypes;
    private boolean useRdfType;
    private UriValidationPolicy uriValidation;
    private JsonLdVersion processingMode;

    private RdfToJsonld(RdfDataset dataset) {
        this.dataset = dataset;
        this.ordered = false;
        this.rdfDirection = null;
        this.useNativeTypes = false;
        this.useRdfType = false;
        this.uriValidation = JsonLdOptions.DEFAULT_URI_VALIDATION;
    }

    public static final RdfToJsonld with(RdfDataset dataset) {
        return new RdfToJsonld(dataset);
    }

    public RdfToJsonld ordered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public RdfToJsonld rdfDirection(JsonLdOptions.RdfDirection rdfDirection) {
        this.rdfDirection = rdfDirection;
        return this;
    }

    public RdfToJsonld useNativeTypes(boolean useNativeTypes) {
        this.useNativeTypes = useNativeTypes;
        return this;
    }

    public RdfToJsonld useRdfType(boolean useRdfType) {
        this.useRdfType = useRdfType;
        return this;
    }

    public RdfToJsonld processingMode(JsonLdVersion processingMode) {
        this.processingMode = processingMode;
        return this;
    }

    @Deprecated
    public RdfToJsonld uriValidation(boolean enabled) {
        return this.uriValidation(enabled ? UriValidationPolicy.Full : UriValidationPolicy.SchemeOnly);
    }

    public RdfToJsonld uriValidation(UriValidationPolicy uriValidation) {
        this.uriValidation = uriValidation;
        return this;
    }

    public JsonArray build() throws JsonLdError {
        QuadsToJsonld toLd = new QuadsToJsonld();
        toLd.ordered(this.ordered);
        toLd.mode(this.processingMode);
        toLd.rdfDirection(this.rdfDirection);
        toLd.uriValidation(this.uriValidation);
        toLd.useNativeTypes(this.useNativeTypes);
        toLd.useRdfType(this.useRdfType);
        try {
            for (RdfNQuad quad : this.dataset.toList()) {
                if (quad.getObject().isLiteral()) {
                    toLd.quad(quad.getSubject().getValue(), quad.getPredicate().getValue(), quad.getObject().getValue(), quad.getObject().asLiteral().getDatatype(), quad.getObject().asLiteral().getLanguage().orElse(null), null, quad.getGraphName().map(RdfValue::getValue).orElse(null));
                    continue;
                }
                toLd.quad(quad.getSubject().getValue(), quad.getPredicate().getValue(), quad.getObject().getValue(), null, null, null, quad.getGraphName().map(RdfValue::getValue).orElse(null));
            }
        }
        catch (RdfConsumerException e) {
            if (e.getCause() instanceof JsonLdError) {
                throw (JsonLdError)e.getCause();
            }
            throw new JsonLdError(JsonLdErrorCode.UNSPECIFIED, (Throwable)e);
        }
        return toLd.toJsonLd();
    }
}

