/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.Set;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVars;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.sse.writers.WriterExpr;

public abstract class ExprNode
implements Expr {
    private Set<Var> varsMentioned = null;

    protected ExprNode() {
    }

    @Override
    public final boolean isSatisfied(Binding binding, FunctionEnv funcEnv) {
        try {
            NodeValue v = this.eval(binding, funcEnv);
            boolean b = XSDFuncOp.effectiveBooleanValue(v);
            return b;
        }
        catch (ExprEvalException ex) {
            return false;
        }
    }

    @Deprecated(forRemoval=true)
    public boolean isExpr() {
        return true;
    }

    @Deprecated(forRemoval=true)
    public final Expr getExpr() {
        return this;
    }

    @Override
    public abstract NodeValue eval(Binding var1, FunctionEnv var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Var> getVarsMentioned() {
        if (this.varsMentioned == null) {
            ExprNode exprNode = this;
            synchronized (exprNode) {
                if (this.varsMentioned == null) {
                    this.varsMentioned = ExprVars.getVarsMentioned(this);
                }
            }
        }
        return this.varsMentioned;
    }

    @Override
    public abstract int hashCode();

    @Override
    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof Expr)) {
            return false;
        }
        return this.equals((Expr)other, false);
    }

    @Override
    public final boolean equalsBySyntax(Expr other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.equals(other, true);
    }

    @Override
    public abstract boolean equals(Expr var1, boolean var2);

    protected static NodeValue eval(Binding binding, FunctionEnv funcEnv, Expr expr) {
        if (expr == null) {
            return null;
        }
        return expr.eval(binding, funcEnv);
    }

    @Override
    public final Expr deepCopy() {
        return this.copySubstitute(null);
    }

    @Override
    public abstract Expr copySubstitute(Binding var1);

    @Override
    public abstract Expr applyNodeTransform(NodeTransform var1);

    @Override
    public boolean isVariable() {
        return false;
    }

    @Override
    public String getVarName() {
        return null;
    }

    @Override
    public ExprVar getExprVar() {
        return null;
    }

    @Override
    public Var asVar() {
        return null;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public NodeValue getConstant() {
        return null;
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public ExprFunction getFunction() {
        return null;
    }

    public boolean isGraphPattern() {
        return false;
    }

    public Op getGraphPattern() {
        return null;
    }

    public String toString() {
        return WriterExpr.asString(this);
    }
}

