/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hadoop.authentication;

import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.catalog.hadoop.authentication.AuthenticationConfig;
import org.apache.gravitino.catalog.hadoop.authentication.KerberosUserContext;
import org.apache.gravitino.catalog.hadoop.authentication.SimpleUserContext;
import org.apache.gravitino.connector.CatalogInfo;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public abstract class UserContext
implements Closeable {
    private static final Map<NameIdentifier, UserContext> userContextMap = Maps.newConcurrentMap();

    private static void addUserContext(NameIdentifier nameIdentifier, UserContext userContext) {
        userContextMap.put(nameIdentifier, userContext);
    }

    public static void clearUserContext(NameIdentifier nameIdentifier) {
        UserContext userContext = userContextMap.remove(nameIdentifier);
        if (userContext != null) {
            try {
                userContext.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to close user context", e);
            }
        }
    }

    public static void cleanAllUserContext() {
        userContextMap.keySet().forEach(UserContext::clearUserContext);
        userContextMap.clear();
    }

    public static UserContext getUserContext(NameIdentifier nameIdentifier, Map<String, String> properties, Configuration configuration, CatalogInfo catalogInfo) {
        UserGroupInformation currentUser;
        NameIdentifier currentNameIdentifier = NameIdentifier.of((String[])nameIdentifier.namespace().levels());
        UserContext parentContext = null;
        while (!currentNameIdentifier.namespace().isEmpty()) {
            if (userContextMap.containsKey(currentNameIdentifier)) {
                parentContext = userContextMap.get(currentNameIdentifier);
                break;
            }
            currentNameIdentifier = NameIdentifier.of((String[])currentNameIdentifier.namespace().levels());
        }
        if (configuration == null) {
            configuration = new Configuration();
        }
        AuthenticationConfig authenticationConfig = new AuthenticationConfig(properties);
        boolean enableUserImpersonation = (Boolean)AuthenticationConfig.ENABLE_IMPERSONATION_ENTRY.getDefaultValue();
        if (properties.containsKey("authentication.impersonation-enable")) {
            enableUserImpersonation = authenticationConfig.isImpersonationEnabled();
        } else if (parentContext != null) {
            enableUserImpersonation = parentContext.enableUserImpersonation();
        }
        AuthenticationConfig.AuthenticationType authenticationType = AuthenticationConfig.AuthenticationType.fromString((String)AuthenticationConfig.AUTH_TYPE_ENTRY.getDefaultValue());
        if (properties.containsKey("authentication.type")) {
            authenticationType = authenticationConfig.isSimpleAuth() ? AuthenticationConfig.AuthenticationType.SIMPLE : AuthenticationConfig.AuthenticationType.KERBEROS;
        } else if (parentContext != null) {
            authenticationType = parentContext instanceof SimpleUserContext ? AuthenticationConfig.AuthenticationType.SIMPLE : AuthenticationConfig.AuthenticationType.KERBEROS;
        }
        try {
            currentUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Failed to get current user", ioException);
        }
        if (authenticationType == AuthenticationConfig.AuthenticationType.SIMPLE) {
            UserGroupInformation userGroupInformation = parentContext != null ? parentContext.getUser() : currentUser;
            SimpleUserContext simpleUserContext = new SimpleUserContext(userGroupInformation, enableUserImpersonation);
            UserContext.addUserContext(nameIdentifier, simpleUserContext);
            return simpleUserContext;
        }
        if (authenticationType == AuthenticationConfig.AuthenticationType.KERBEROS) {
            if (parentContext != null && authenticationConfig.isSimpleAuth()) {
                KerberosUserContext kerberosUserContext = ((KerberosUserContext)parentContext).deepCopy();
                kerberosUserContext.setEnableUserImpersonation(enableUserImpersonation);
                UserContext.addUserContext(nameIdentifier, kerberosUserContext);
                return kerberosUserContext;
            }
            String keytabPath = String.format("keytabs/gravitino-%s", catalogInfo.id() + "-" + nameIdentifier.toString().replace(".", "-"));
            KerberosUserContext kerberosUserContext = new KerberosUserContext(enableUserImpersonation, keytabPath);
            kerberosUserContext.initKerberos(properties, configuration, parentContext == null);
            UserContext.addUserContext(nameIdentifier, kerberosUserContext);
            return kerberosUserContext;
        }
        throw new RuntimeException("Unsupported authentication type: " + (Object)((Object)authenticationType));
    }

    abstract UserGroupInformation getUser();

    abstract boolean enableUserImpersonation();

    abstract UserGroupInformation createProxyUser();

    public <T> T doAs(PrivilegedExceptionAction<T> action, NameIdentifier ident) {
        UserGroupInformation u = this.getUser();
        if (this.enableUserImpersonation()) {
            u = this.createProxyUser();
        }
        try {
            return (T)u.doAs(action);
        }
        catch (IOException | InterruptedException ioe) {
            throw new RuntimeException("Failed to operation on entity:" + ident, ioe);
        }
        catch (UndeclaredThrowableException e) {
            Throwable innerException = e.getCause();
            if (innerException instanceof PrivilegedActionException) {
                throw new RuntimeException(innerException.getCause());
            }
            if (innerException instanceof InvocationTargetException) {
                throw new RuntimeException(innerException.getCause());
            }
            throw new RuntimeException(innerException);
        }
    }
}

