/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class NearCacheUpdates
implements Message {
    private static final long serialVersionUID = 0L;
    @GridDirectCollection(value=int.class)
    private List<Integer> nearValsIdxs;
    @GridDirectCollection(value=int.class)
    private List<Integer> nearSkipIdxs;
    @GridToStringInclude
    @GridDirectCollection(value=CacheObject.class)
    private List<CacheObject> nearVals;
    private GridCacheVersion nearVer;
    private GridLongList nearTtls;
    private GridLongList nearExpireTimes;

    List<CacheObject> nearValues() {
        return this.nearVals;
    }

    void addNearValue(int keyIdx, @Nullable CacheObject val, long ttl, long expireTime) {
        if (this.nearValsIdxs == null) {
            this.nearValsIdxs = new ArrayList<Integer>();
            this.nearVals = new ArrayList<CacheObject>();
        }
        this.addNearTtl(keyIdx, ttl, expireTime);
        this.nearValsIdxs.add(keyIdx);
        this.nearVals.add(val);
    }

    void addNearTtl(int keyIdx, long ttl, long expireTime) {
        int i;
        if (ttl >= 0L && this.nearTtls == null) {
            this.nearTtls = new GridLongList(16);
            for (i = 0; i < keyIdx; ++i) {
                this.nearTtls.add(-1L);
            }
        }
        if (this.nearTtls != null) {
            this.nearTtls.add(ttl);
        }
        if (expireTime >= 0L && this.nearExpireTimes == null) {
            this.nearExpireTimes = new GridLongList(16);
            for (i = 0; i < keyIdx; ++i) {
                this.nearExpireTimes.add(-1L);
            }
        }
        if (this.nearExpireTimes != null) {
            this.nearExpireTimes.add(expireTime);
        }
    }

    long nearExpireTime(int idx) {
        if (this.nearExpireTimes != null) {
            assert (idx >= 0 && idx < this.nearExpireTimes.size());
            return this.nearExpireTimes.get(idx);
        }
        return -1L;
    }

    long nearTtl(int idx) {
        if (this.nearTtls != null) {
            assert (idx >= 0 && idx < this.nearTtls.size());
            return this.nearTtls.get(idx);
        }
        return -1L;
    }

    void nearVersion(GridCacheVersion nearVer) {
        this.nearVer = nearVer;
    }

    GridCacheVersion nearVersion() {
        return this.nearVer;
    }

    void addSkippedIndex(int keyIdx) {
        if (this.nearSkipIdxs == null) {
            this.nearSkipIdxs = new ArrayList<Integer>();
        }
        this.nearSkipIdxs.add(keyIdx);
        this.addNearTtl(keyIdx, -1L, -1L);
    }

    @Nullable
    List<Integer> skippedIndexes() {
        return this.nearSkipIdxs;
    }

    @Nullable
    List<Integer> nearValuesIndexes() {
        return this.nearValsIdxs;
    }

    @Nullable
    CacheObject nearValue(int idx) {
        return this.nearVals.get(idx);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeMessage("nearExpireTimes", this.nearExpireTimes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeCollection("nearSkipIdxs", this.nearSkipIdxs, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeMessage("nearTtls", this.nearTtls)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeCollection("nearVals", this.nearVals, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeCollection("nearValsIdxs", this.nearValsIdxs, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeMessage("nearVer", this.nearVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.nearExpireTimes = (GridLongList)reader.readMessage("nearExpireTimes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.nearSkipIdxs = (List)reader.readCollection("nearSkipIdxs", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.nearTtls = (GridLongList)reader.readMessage("nearTtls");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.nearVals = (List)reader.readCollection("nearVals", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.nearValsIdxs = (List)reader.readCollection("nearValsIdxs", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.nearVer = (GridCacheVersion)reader.readMessage("nearVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(NearCacheUpdates.class);
    }

    @Override
    public short directType() {
        return -51;
    }

    @Override
    public byte fieldsCount() {
        return 6;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(NearCacheUpdates.class, this);
    }
}

