/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetPreferences;
import org.apache.directory.studio.ldapbrowser.core.utils.AttributeComparator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class EntryEditorWidgetSorter
extends ViewerSorter
implements SelectionListener {
    private TreeViewer viewer;
    private int sortBy = 0;
    private int sortOrder = 0;
    private EntryEditorWidgetPreferences preferences;

    public EntryEditorWidgetSorter(EntryEditorWidgetPreferences preferences) {
        this.preferences = preferences;
    }

    public void connect(TreeViewer viewer) {
        this.viewer = viewer;
        viewer.setSorter((ViewerSorter)this);
        TreeColumn[] treeColumnArray = viewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.addSelectionListener((SelectionListener)this);
            ++n2;
        }
    }

    public void dispose() {
        this.viewer = null;
        this.preferences = null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget instanceof TreeColumn && this.viewer != null) {
            Tree tree = this.viewer.getTree();
            TreeColumn treeColumn = (TreeColumn)event.widget;
            int index = tree.indexOf(treeColumn);
            switch (index) {
                case 0: {
                    if (this.sortBy == 3) {
                        this.toggleSortOrder();
                        break;
                    }
                    this.sortBy = 3;
                    this.sortOrder = 1;
                    break;
                }
                case 1: {
                    if (this.sortBy == 4) {
                        this.toggleSortOrder();
                        break;
                    }
                    this.sortBy = 4;
                    this.sortOrder = 1;
                }
            }
            if (this.sortOrder == 0) {
                this.sortBy = 0;
            }
            TreeColumn[] treeColumnArray = tree.getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                column.setImage(null);
                ++n2;
            }
            if (this.sortOrder == 1) {
                treeColumn.setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/sort_ascending.gif"));
            } else if (this.sortOrder == 2) {
                treeColumn.setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/sort_descending.gif"));
            }
            this.viewer.refresh();
        }
    }

    private void toggleSortOrder() {
        switch (this.sortOrder) {
            case 0: {
                this.sortOrder = 1;
                break;
            }
            case 1: {
                this.sortOrder = 2;
                break;
            }
            case 2: {
                this.sortOrder = 0;
            }
        }
    }

    public void sort(final Viewer viewer, Object[] elements) {
        Arrays.sort(elements, new Comparator<Object>(){

            @Override
            public int compare(Object a, Object b) {
                return EntryEditorWidgetSorter.this.compare(viewer, a, b);
            }
        });
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        boolean objectClassAndMustAttributesFirst = this.preferences == null || this.preferences.isObjectClassAndMustAttributesFirst();
        boolean operationalAttributesLast = this.preferences == null || this.preferences.isOperationalAttributesLast();
        AttributeComparator comparator = new AttributeComparator(this.sortBy, this.getDefaultSortBy(), this.sortOrder, this.getDefaultSortOrder(), objectClassAndMustAttributesFirst, operationalAttributesLast);
        return comparator.compare(o1, o2);
    }

    private int getDefaultSortOrder() {
        if (this.preferences == null) {
            return 1;
        }
        return this.preferences.getDefaultSortOrder();
    }

    private int getDefaultSortBy() {
        if (this.preferences == null) {
            return 3;
        }
        return this.preferences.getDefaultSortBy();
    }
}

