/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.connection;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.AbstractConnectionParameterPage;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.ldapbrowser.common.widgets.connection.Messages;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.AliasesDereferencingWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.LimitWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.ReferralsHandlingWidget;
import org.apache.directory.studio.ldapbrowser.core.jobs.FetchBaseDNsRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.impl.BrowserConnection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BrowserParameterPage
extends AbstractConnectionParameterPage {
    private static final String X_BASE_DN = "X-BASE-Dn";
    private static final String X_COUNT_LIMIT = "X-COUNT-LIMIT";
    private static final String X_TIME_LIMIT = "X-TIME-LIMIT";
    private static final String X_ALIAS_HANDLING = "X-ALIAS-HANDLING";
    private static final String X_ALIAS_HANDLING_FINDING = "FINDING";
    private static final String X_ALIAS_HANDLING_SEARCHING = "SEARCHING";
    private static final String X_ALIAS_HANDLING_NEVER = "NEVER";
    private static final String X_REFERRAL_HANDLING = "X-REFERRAL-HANDLING";
    private static final String X_REFERRAL_HANDLING_IGNORE = "IGNORE";
    private static final String X_REFERRAL_HANDLING_FOLLOW = "FOLLOW";
    private static final String X_MANAGE_DSA_IT = "X-MANAGE-DSA-IT";
    private static final String X_FETCH_SUBENTRIES = "X-FETCH-SUBENTRIES";
    private static final String X_FETCH_OPERATIONAL_ATTRIBUTES = "X-FETCH-OPERATIONAL-ATTRIBUTES";
    private static final String X_PAGED_SEARCH = "X-PAGED-SEARCH";
    private static final String X_PAGED_SEARCH_SIZE = "X-PAGED-SEARCH-SIZE";
    private static final String X_PAGED_SEARCH_SCROLL_MODE = "X-PAGED-SEARCH-SCROLL-MODE";
    private Button autoFetchBaseDnsButton;
    private Button fetchBaseDnsButton;
    private Combo baseDNCombo;
    private LimitWidget limitWidget;
    private AliasesDereferencingWidget aliasesDereferencingWidget;
    private ReferralsHandlingWidget referralsHandlingWidget;
    private Button manageDsaItButton;
    private Button fetchSubentriesButton;
    private Button pagedSearchButton;
    private Label pagedSearchSizeLabel;
    private Text pagedSearchSizeText;
    private Button pagedSearchScrollModeButton;
    private Button fetchOperationalAttributesButton;

    private boolean isAutoFetchBaseDns() {
        return this.autoFetchBaseDnsButton.getSelection();
    }

    private String getBaseDN() {
        return this.isAutoFetchBaseDns() ? null : this.baseDNCombo.getText();
    }

    private int getCountLimit() {
        return this.limitWidget.getCountLimit();
    }

    private int getTimeLimit() {
        return this.limitWidget.getTimeLimit();
    }

    private Connection.AliasDereferencingMethod getAliasesDereferencingMethod() {
        return this.aliasesDereferencingWidget.getAliasesDereferencingMethod();
    }

    private Connection.ReferralHandlingMethod getReferralsHandlingMethod() {
        return this.referralsHandlingWidget.getReferralsHandlingMethod();
    }

    private boolean manageDsaIT() {
        return this.manageDsaItButton.getSelection();
    }

    private boolean isFetchSubentries() {
        return this.fetchSubentriesButton.getSelection();
    }

    private boolean isFetchOperationalAttributes() {
        return this.fetchOperationalAttributesButton.getSelection();
    }

    private boolean isPagedSearch() {
        return this.pagedSearchButton.getSelection();
    }

    private int getPagedSearchSize() {
        int pageSize;
        try {
            pageSize = Integer.valueOf(this.pagedSearchSizeText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            pageSize = 100;
        }
        return pageSize;
    }

    private boolean isPagedSearchScrollMode() {
        return this.pagedSearchScrollModeButton.getSelection();
    }

    private Connection getTestConnection() {
        ConnectionParameter cp = this.connectionParameterPageModifyListener.getTestConnectionParameters();
        Connection conn = new Connection(cp);
        return conn;
    }

    protected void createComposite(Composite parent) {
        this.addBaseDNInput(parent);
        this.addLimitInput(parent);
        this.addControlInput(parent);
        this.addFeaturesInput(parent);
    }

    private void addBaseDNInput(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        Group group = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("BrowserParameterPage.BaseDNGroup"), (int)1);
        Composite groupComposite = BaseWidgetUtils.createColumnContainer((Composite)group, (int)3, (int)1);
        this.autoFetchBaseDnsButton = BaseWidgetUtils.createCheckbox((Composite)groupComposite, (String)Messages.getString("BrowserParameterPage.GetBaseDNsFromRootDSE"), (int)2);
        this.autoFetchBaseDnsButton.setSelection(true);
        this.fetchBaseDnsButton = new Button(groupComposite, 8);
        this.fetchBaseDnsButton.setText(Messages.getString("BrowserParameterPage.FetchBaseDNs"));
        this.fetchBaseDnsButton.setEnabled(true);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        this.fetchBaseDnsButton.setLayoutData((Object)gd);
        BaseWidgetUtils.createLabel((Composite)groupComposite, (String)Messages.getString("BrowserParameterPage.BaseDN"), (int)1);
        this.baseDNCombo = BaseWidgetUtils.createCombo((Composite)groupComposite, (String[])new String[0], (int)0, (int)2);
    }

    private void addControlInput(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        Group group = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("BrowserParameterPage.Controls"), (int)1);
        Composite groupComposite = BaseWidgetUtils.createColumnContainer((Composite)group, (int)1, (int)1);
        this.manageDsaItButton = BaseWidgetUtils.createCheckbox((Composite)groupComposite, (String)Messages.getString("BrowserParameterPage.ManageDsaItWhileBrowsing"), (int)1);
        this.manageDsaItButton.setToolTipText(Messages.getString("BrowserParameterPage.ManageDsaItWhileBrowsingTooltip"));
        this.manageDsaItButton.setSelection(false);
        this.fetchSubentriesButton = BaseWidgetUtils.createCheckbox((Composite)groupComposite, (String)Messages.getString("BrowserParameterPage.FetchSubentriesWhileBrowsing"), (int)1);
        this.fetchSubentriesButton.setToolTipText(Messages.getString("BrowserParameterPage.FetchSubentriesWhileBrowsingTooltip"));
        this.fetchSubentriesButton.setSelection(false);
        Composite sprcComposite = BaseWidgetUtils.createColumnContainer((Composite)groupComposite, (int)4, (int)1);
        this.pagedSearchButton = BaseWidgetUtils.createCheckbox((Composite)sprcComposite, (String)Messages.getString("BrowserParameterPage.PagedSearch"), (int)1);
        this.pagedSearchButton.setToolTipText(Messages.getString("BrowserParameterPage.PagedSearchTooltip"));
        this.pagedSearchSizeLabel = BaseWidgetUtils.createLabel((Composite)sprcComposite, (String)Messages.getString("BrowserParameterPage.PageSize"), (int)1);
        this.pagedSearchSizeText = BaseWidgetUtils.createText((Composite)sprcComposite, (String)"100", (int)5, (int)1);
        this.pagedSearchScrollModeButton = BaseWidgetUtils.createCheckbox((Composite)sprcComposite, (String)Messages.getString("BrowserParameterPage.ScrollMode"), (int)1);
        this.pagedSearchScrollModeButton.setToolTipText(Messages.getString("BrowserParameterPage.ScrollModeTooltip"));
        this.pagedSearchScrollModeButton.setSelection(true);
    }

    private void addFeaturesInput(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        Group group = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("BrowserParameterPage.Features"), (int)1);
        Composite groupComposite = BaseWidgetUtils.createColumnContainer((Composite)group, (int)1, (int)1);
        this.fetchOperationalAttributesButton = BaseWidgetUtils.createCheckbox((Composite)groupComposite, (String)Messages.getString("BrowserParameterPage.FetchOperationalAttributesWhileBrowsing"), (int)1);
        this.fetchOperationalAttributesButton.setToolTipText(Messages.getString("BrowserParameterPage.FetchOperationalAttributesWhileBrowsingTooltip"));
        this.fetchOperationalAttributesButton.setSelection(false);
    }

    public void addLimitInput(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)3, (int)1);
        this.limitWidget = new LimitWidget(1000, 0);
        this.limitWidget.createWidget(composite);
        this.aliasesDereferencingWidget = new AliasesDereferencingWidget(Connection.AliasDereferencingMethod.ALWAYS);
        this.aliasesDereferencingWidget.createWidget(composite);
        this.referralsHandlingWidget = new ReferralsHandlingWidget(Connection.ReferralHandlingMethod.FOLLOW_MANUALLY);
        this.referralsHandlingWidget.createWidget(composite, true);
    }

    protected void validate() {
        this.baseDNCombo.setEnabled(!this.isAutoFetchBaseDns());
        this.pagedSearchSizeLabel.setEnabled(this.isPagedSearch());
        this.pagedSearchSizeText.setEnabled(this.isPagedSearch());
        this.pagedSearchScrollModeButton.setEnabled(this.isPagedSearch());
        this.message = null;
        this.infoMessage = null;
        this.errorMessage = null;
        if (!this.isAutoFetchBaseDns() && !Dn.isValid((String)this.getBaseDN())) {
            this.message = Messages.getString("BrowserParameterPage.EnterValidBaseDN");
        }
    }

    protected void loadParameters(ConnectionParameter parameter) {
        this.connectionParameter = parameter;
        boolean fetchBaseDns = parameter.getExtendedBoolProperty("ldapbrowser.fetchBaseDns");
        this.autoFetchBaseDnsButton.setSelection(fetchBaseDns);
        String baseDn = parameter.getExtendedProperty("ldapbrowser.baseDn");
        this.baseDNCombo.setText(baseDn != null ? baseDn : "");
        int countLimit = parameter.getExtendedIntProperty("ldapbrowser.countLimit");
        this.limitWidget.setCountLimit(countLimit);
        int timeLimit = parameter.getExtendedIntProperty("ldapbrowser.timeLimit");
        this.limitWidget.setTimeLimit(timeLimit);
        int referralsHandlingMethodOrdinal = parameter.getExtendedIntProperty("ldapbrowser.referralsHandlingMethod");
        Connection.ReferralHandlingMethod referralsHandlingMethod = Connection.ReferralHandlingMethod.getByOrdinal((int)referralsHandlingMethodOrdinal);
        this.referralsHandlingWidget.setReferralsHandlingMethod(referralsHandlingMethod);
        int aliasesDereferencingMethodOrdinal = parameter.getExtendedIntProperty("ldapbrowser.aliasesDereferencingMethod");
        Connection.AliasDereferencingMethod aliasesDereferencingMethod = Connection.AliasDereferencingMethod.getByOrdinal((int)aliasesDereferencingMethodOrdinal);
        this.aliasesDereferencingWidget.setAliasesDereferencingMethod(aliasesDereferencingMethod);
        boolean manageDsaIT = parameter.getExtendedBoolProperty("ldapbrowser.manageDsaIT");
        this.manageDsaItButton.setSelection(manageDsaIT);
        boolean fetchSubentries = parameter.getExtendedBoolProperty("ldapbrowser.fetchSubentries");
        this.fetchSubentriesButton.setSelection(fetchSubentries);
        boolean pagedSearch = parameter.getExtendedBoolProperty("ldapbrowser.pagedSearch");
        this.pagedSearchButton.setSelection(pagedSearch);
        String pagedSearchSize = parameter.getExtendedProperty("ldapbrowser.pagedSearchSize");
        this.pagedSearchSizeText.setText(pagedSearchSize != null ? pagedSearchSize : "100");
        boolean pagedSearchScrollMode = parameter.getExtendedBoolProperty("ldapbrowser.pagedSearchScrollMode");
        this.pagedSearchScrollModeButton.setSelection(pagedSearch ? pagedSearchScrollMode : true);
        boolean fetchOperationalAttributes = parameter.getExtendedBoolProperty("ldapbrowser.fetchOperationalAttributes");
        this.fetchOperationalAttributesButton.setSelection(fetchOperationalAttributes);
    }

    protected void initListeners() {
        this.autoFetchBaseDnsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BrowserParameterPage.this.connectionPageModified();
            }
        });
        this.fetchBaseDnsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Connection connection = BrowserParameterPage.this.getTestConnection();
                BrowserConnection browserConnection = new BrowserConnection(connection);
                FetchBaseDNsRunnable runnable = new FetchBaseDNsRunnable((IBrowserConnection)browserConnection);
                IStatus status = RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)runnable, (IRunnableContext)BrowserParameterPage.this.runnableContext, (boolean)true);
                if (status.isOK()) {
                    if (!runnable.getBaseDNs().isEmpty()) {
                        List baseDNs = runnable.getBaseDNs();
                        BrowserParameterPage.this.baseDNCombo.setItems(baseDNs.toArray(new String[baseDNs.size()]));
                        BrowserParameterPage.this.baseDNCombo.select(0);
                        String msg = Messages.getString("BrowserParameterPage.BaseDNResult");
                        for (String baseDN : baseDNs) {
                            msg = String.valueOf(msg) + "\n  - " + baseDN;
                        }
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("BrowserParameterPage.FetchBaseDNs"), (String)msg);
                    } else {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("BrowserParameterPage.FetchBaseDNs"), (String)Messages.getString("BrowserParameterPage.NoBaseDNReturnedFromServer"));
                        BrowserParameterPage.this.autoFetchBaseDnsButton.setSelection(false);
                    }
                }
            }
        });
        this.baseDNCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                BrowserParameterPage.this.connectionPageModified();
            }
        });
        this.manageDsaItButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BrowserParameterPage.this.connectionPageModified();
            }
        });
        this.fetchSubentriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BrowserParameterPage.this.connectionPageModified();
            }
        });
        this.pagedSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserParameterPage.this.connectionPageModified();
            }
        });
        this.pagedSearchSizeText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        this.pagedSearchSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BrowserParameterPage.this.connectionPageModified();
            }
        });
        this.fetchOperationalAttributesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BrowserParameterPage.this.connectionPageModified();
            }
        });
    }

    public void saveParameters(ConnectionParameter parameter) {
        parameter.setExtendedBoolProperty("ldapbrowser.fetchBaseDns", this.isAutoFetchBaseDns());
        parameter.setExtendedProperty("ldapbrowser.baseDn", this.getBaseDN());
        parameter.setExtendedIntProperty("ldapbrowser.countLimit", this.getCountLimit());
        parameter.setExtendedIntProperty("ldapbrowser.timeLimit", this.getTimeLimit());
        parameter.setExtendedIntProperty("ldapbrowser.referralsHandlingMethod", this.getReferralsHandlingMethod().getOrdinal());
        parameter.setExtendedIntProperty("ldapbrowser.aliasesDereferencingMethod", this.getAliasesDereferencingMethod().getOrdinal());
        parameter.setExtendedBoolProperty("ldapbrowser.manageDsaIT", this.manageDsaIT());
        parameter.setExtendedBoolProperty("ldapbrowser.fetchSubentries", this.isFetchSubentries());
        parameter.setExtendedBoolProperty("ldapbrowser.pagedSearch", this.isPagedSearch());
        parameter.setExtendedIntProperty("ldapbrowser.pagedSearchSize", this.getPagedSearchSize());
        parameter.setExtendedBoolProperty("ldapbrowser.pagedSearchScrollMode", this.isPagedSearchScrollMode());
        parameter.setExtendedBoolProperty("ldapbrowser.fetchOperationalAttributes", this.isFetchOperationalAttributes());
    }

    public void saveDialogSettings() {
    }

    public void setFocus() {
        this.baseDNCombo.setFocus();
    }

    public boolean areParametersModifed() {
        int countLimit = this.connectionParameter.getExtendedIntProperty("ldapbrowser.countLimit");
        int timeLimit = this.connectionParameter.getExtendedIntProperty("ldapbrowser.timeLimit");
        boolean manageDsaIT = this.connectionParameter.getExtendedBoolProperty("ldapbrowser.manageDsaIT");
        boolean fetchSubentries = this.connectionParameter.getExtendedBoolProperty("ldapbrowser.fetchSubentries");
        boolean pagedSearch = this.connectionParameter.getExtendedBoolProperty("ldapbrowser.pagedSearch");
        int pagedSearchSize = this.connectionParameter.getExtendedIntProperty("ldapbrowser.pagedSearchSize");
        boolean pagedSearchScrollMode = this.connectionParameter.getExtendedBoolProperty("ldapbrowser.pagedSearchScrollMode");
        return this.isReconnectionRequired() || countLimit != this.getCountLimit() || timeLimit != this.getTimeLimit() || manageDsaIT != this.manageDsaIT() || fetchSubentries != this.isFetchSubentries() || pagedSearch != this.isPagedSearch() || pagedSearchSize != this.getPagedSearchSize() || pagedSearchScrollMode != this.isPagedSearchScrollMode();
    }

    public boolean isReconnectionRequired() {
        if (this.connectionParameter == null) {
            return true;
        }
        boolean fetchBaseDns = this.connectionParameter.getExtendedBoolProperty("ldapbrowser.fetchBaseDns");
        String baseDn = this.connectionParameter.getExtendedProperty("ldapbrowser.baseDn");
        int referralsHandlingMethodOrdinal = this.connectionParameter.getExtendedIntProperty("ldapbrowser.referralsHandlingMethod");
        Connection.ReferralHandlingMethod referralsHandlingMethod = Connection.ReferralHandlingMethod.getByOrdinal((int)referralsHandlingMethodOrdinal);
        int aliasesDereferencingMethodOrdinal = this.connectionParameter.getExtendedIntProperty("ldapbrowser.aliasesDereferencingMethod");
        Connection.AliasDereferencingMethod aliasesDereferencingMethod = Connection.AliasDereferencingMethod.getByOrdinal((int)aliasesDereferencingMethodOrdinal);
        boolean fetchOperationalAttributes = this.connectionParameter.getExtendedBoolProperty("ldapbrowser.fetchOperationalAttributes");
        return fetchBaseDns != this.isAutoFetchBaseDns() || !StringUtils.equals((CharSequence)baseDn, (CharSequence)this.getBaseDN()) || referralsHandlingMethod != this.getReferralsHandlingMethod() || aliasesDereferencingMethod != this.getAliasesDereferencingMethod() || fetchOperationalAttributes != this.isFetchOperationalAttributes();
    }

    public void mergeParametersToLdapURL(ConnectionParameter parameter, LdapUrl ldapUrl) {
        boolean fetchOperationalAttributes;
        boolean pagedSearch;
        boolean fetchSubentries;
        int timeLimit;
        int countLimit;
        boolean fetchBaseDns = parameter.getExtendedBoolProperty("ldapbrowser.fetchBaseDns");
        String baseDn = parameter.getExtendedProperty("ldapbrowser.baseDn");
        if (!fetchBaseDns && StringUtils.isNotEmpty((CharSequence)baseDn)) {
            ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_BASE_DN, baseDn));
        }
        if ((countLimit = parameter.getExtendedIntProperty("ldapbrowser.countLimit")) != 0) {
            ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_COUNT_LIMIT, parameter.getExtendedProperty("ldapbrowser.countLimit")));
        }
        if ((timeLimit = parameter.getExtendedIntProperty("ldapbrowser.timeLimit")) != 0) {
            ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_TIME_LIMIT, parameter.getExtendedProperty("ldapbrowser.timeLimit")));
        }
        int aliasesDereferencingMethodOrdinal = parameter.getExtendedIntProperty("ldapbrowser.aliasesDereferencingMethod");
        Connection.AliasDereferencingMethod aliasesDereferencingMethod = Connection.AliasDereferencingMethod.getByOrdinal((int)aliasesDereferencingMethodOrdinal);
        switch (aliasesDereferencingMethod) {
            case ALWAYS: {
                break;
            }
            case FINDING: {
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_ALIAS_HANDLING, X_ALIAS_HANDLING_FINDING));
                break;
            }
            case SEARCH: {
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_ALIAS_HANDLING, X_ALIAS_HANDLING_SEARCHING));
                break;
            }
            case NEVER: {
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_ALIAS_HANDLING, X_ALIAS_HANDLING_NEVER));
            }
        }
        int referralsHandlingMethodOrdinal = parameter.getExtendedIntProperty("ldapbrowser.referralsHandlingMethod");
        Connection.ReferralHandlingMethod referralsHandlingMethod = Connection.ReferralHandlingMethod.getByOrdinal((int)referralsHandlingMethodOrdinal);
        switch (referralsHandlingMethod) {
            case FOLLOW_MANUALLY: {
                break;
            }
            case IGNORE: {
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_REFERRAL_HANDLING, X_REFERRAL_HANDLING_IGNORE));
                break;
            }
            case FOLLOW: {
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_REFERRAL_HANDLING, X_REFERRAL_HANDLING_FOLLOW));
            }
        }
        boolean manageDsaIt = parameter.getExtendedBoolProperty("ldapbrowser.manageDsaIT");
        if (manageDsaIt) {
            ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_MANAGE_DSA_IT, null));
        }
        if (fetchSubentries = parameter.getExtendedBoolProperty("ldapbrowser.fetchSubentries")) {
            ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_FETCH_SUBENTRIES, null));
        }
        if (pagedSearch = parameter.getExtendedBoolProperty("ldapbrowser.pagedSearch")) {
            ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_PAGED_SEARCH, null));
            ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_PAGED_SEARCH_SIZE, parameter.getExtendedProperty("ldapbrowser.pagedSearchSize")));
            boolean pagedSearchScrollMode = parameter.getExtendedBoolProperty("ldapbrowser.pagedSearchScrollMode");
            if (pagedSearchScrollMode) {
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_PAGED_SEARCH_SCROLL_MODE, null));
            }
        }
        if (fetchOperationalAttributes = parameter.getExtendedBoolProperty("ldapbrowser.fetchOperationalAttributes")) {
            ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_FETCH_OPERATIONAL_ATTRIBUTES, null));
        }
    }

    public void mergeLdapUrlToParameters(LdapUrl ldapUrl, ConnectionParameter parameter) {
        LdapUrl.Extension fetchOperationalAttributes;
        String baseDn = ldapUrl.getExtensionValue(X_BASE_DN);
        if (baseDn == null) {
            parameter.setExtendedBoolProperty("ldapbrowser.fetchBaseDns", true);
            parameter.setExtendedProperty("ldapbrowser.baseDn", null);
        } else {
            parameter.setExtendedBoolProperty("ldapbrowser.fetchBaseDns", false);
            parameter.setExtendedProperty("ldapbrowser.baseDn", baseDn);
        }
        String countLimit = ldapUrl.getExtensionValue(X_COUNT_LIMIT);
        try {
            parameter.setExtendedIntProperty("ldapbrowser.countLimit", Integer.valueOf(countLimit).intValue());
        }
        catch (NumberFormatException numberFormatException) {
            parameter.setExtendedIntProperty("ldapbrowser.countLimit", 0);
        }
        String timeLimit = ldapUrl.getExtensionValue(X_TIME_LIMIT);
        try {
            parameter.setExtendedIntProperty("ldapbrowser.timeLimit", Integer.valueOf(timeLimit).intValue());
        }
        catch (NumberFormatException numberFormatException) {
            parameter.setExtendedIntProperty("ldapbrowser.timeLimit", 0);
        }
        String alias = ldapUrl.getExtensionValue(X_ALIAS_HANDLING);
        if (StringUtils.isNotEmpty((CharSequence)alias) && X_ALIAS_HANDLING_FINDING.equalsIgnoreCase(alias)) {
            parameter.setExtendedIntProperty("ldapbrowser.aliasesDereferencingMethod", Connection.AliasDereferencingMethod.FINDING.getOrdinal());
        } else if (StringUtils.isNotEmpty((CharSequence)alias) && X_ALIAS_HANDLING_SEARCHING.equalsIgnoreCase(alias)) {
            parameter.setExtendedIntProperty("ldapbrowser.aliasesDereferencingMethod", Connection.AliasDereferencingMethod.SEARCH.getOrdinal());
        } else if (StringUtils.isNotEmpty((CharSequence)alias) && X_ALIAS_HANDLING_NEVER.equalsIgnoreCase(alias)) {
            parameter.setExtendedIntProperty("ldapbrowser.aliasesDereferencingMethod", Connection.AliasDereferencingMethod.NEVER.getOrdinal());
        } else {
            parameter.setExtendedIntProperty("ldapbrowser.aliasesDereferencingMethod", Connection.AliasDereferencingMethod.ALWAYS.getOrdinal());
        }
        String referral = ldapUrl.getExtensionValue(X_REFERRAL_HANDLING);
        if (StringUtils.isNotEmpty((CharSequence)referral) && X_REFERRAL_HANDLING_IGNORE.equalsIgnoreCase(referral)) {
            parameter.setExtendedIntProperty("ldapbrowser.referralsHandlingMethod", Connection.ReferralHandlingMethod.IGNORE.getOrdinal());
        } else if (StringUtils.isNotEmpty((CharSequence)referral) && X_REFERRAL_HANDLING_FOLLOW.equalsIgnoreCase(referral)) {
            parameter.setExtendedIntProperty("ldapbrowser.referralsHandlingMethod", Connection.ReferralHandlingMethod.FOLLOW.getOrdinal());
        } else {
            parameter.setExtendedIntProperty("ldapbrowser.referralsHandlingMethod", Connection.ReferralHandlingMethod.FOLLOW_MANUALLY.getOrdinal());
        }
        LdapUrl.Extension manageDsaIT = ldapUrl.getExtension(X_MANAGE_DSA_IT);
        parameter.setExtendedBoolProperty("ldapbrowser.manageDsaIT", manageDsaIT != null);
        LdapUrl.Extension fetchSubentries = ldapUrl.getExtension(X_FETCH_SUBENTRIES);
        parameter.setExtendedBoolProperty("ldapbrowser.fetchSubentries", fetchSubentries != null);
        LdapUrl.Extension pagedSearch = ldapUrl.getExtension(X_PAGED_SEARCH);
        String pagedSearchSize = ldapUrl.getExtensionValue(X_PAGED_SEARCH_SIZE);
        LdapUrl.Extension pagedSearchScrollMode = ldapUrl.getExtension(X_PAGED_SEARCH_SCROLL_MODE);
        if (pagedSearch != null) {
            parameter.setExtendedBoolProperty("ldapbrowser.pagedSearch", pagedSearch != null);
            try {
                parameter.setExtendedIntProperty("ldapbrowser.pagedSearchSize", Integer.valueOf(pagedSearchSize).intValue());
            }
            catch (NumberFormatException numberFormatException) {
                parameter.setExtendedIntProperty("ldapbrowser.pagedSearchSize", 100);
            }
            parameter.setExtendedBoolProperty("ldapbrowser.pagedSearchScrollMode", pagedSearchScrollMode != null);
        }
        parameter.setExtendedBoolProperty("ldapbrowser.fetchOperationalAttributes", (fetchOperationalAttributes = ldapUrl.getExtension(X_FETCH_OPERATIONAL_ATTRIBUTES)) != null);
    }
}

