/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.directory.SearchControls;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchResultEntryImpl;
import org.apache.directory.api.ldap.model.message.SearchResultReference;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ILdapLogger;
import org.apache.directory.studio.connection.core.ReferralsInfo;
import org.apache.directory.studio.connection.core.io.ConnectionWrapperUtils;
import org.apache.directory.studio.connection.core.io.api.StudioSearchResult;

public class StudioSearchResultEnumeration {
    private Connection connection;
    private String searchBase;
    private String filter;
    private SearchControls searchControls;
    private Connection.AliasDereferencingMethod aliasesDereferencingMethod;
    private Connection.ReferralHandlingMethod referralsHandlingMethod;
    private Control[] controls;
    private long requestNum;
    private StudioProgressMonitor monitor;
    private ReferralsInfo referralsInfo;
    private long resultEntryCounter;
    private SearchCursor cursor;
    private SearchResultEntry currentSearchResultEntry;
    private List<String> currentReferralUrlsList;
    private StudioSearchResultEnumeration referralEnumeration;
    private SearchResultDone searchResultDone;

    public StudioSearchResultEnumeration(Connection connection, SearchCursor cursor, String searchBase, String filter, SearchControls searchControls, Connection.AliasDereferencingMethod aliasesDereferencingMethod, Connection.ReferralHandlingMethod referralsHandlingMethod, Control[] controls, long requestNum, StudioProgressMonitor monitor, ReferralsInfo referralsInfo) {
        this.connection = connection;
        this.searchBase = searchBase;
        this.filter = filter;
        this.searchControls = searchControls;
        this.aliasesDereferencingMethod = aliasesDereferencingMethod;
        this.referralsHandlingMethod = referralsHandlingMethod;
        this.controls = controls;
        this.requestNum = requestNum;
        this.monitor = monitor;
        this.referralsInfo = referralsInfo;
        this.resultEntryCounter = 0L;
        if (referralsInfo == null) {
            this.referralsInfo = new ReferralsInfo(false);
        }
        this.cursor = cursor;
    }

    public void close() throws LdapException {
        try {
            this.cursor.close();
        }
        catch (Exception e) {
            throw new LdapException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasMore() throws LdapException {
        try {
            block16: {
                Referral referral;
                block15: {
                    this.currentSearchResultEntry = null;
                    while (true) {
                        if (!this.cursor.next()) {
                            if (this.searchResultDone == null) {
                                this.searchResultDone = this.cursor.getSearchResultDone();
                                referral = this.searchResultDone.getLdapResult().getReferral();
                                if (this.referralsHandlingMethod != Connection.ReferralHandlingMethod.IGNORE && referral != null) {
                                    this.referralsInfo.addReferral(referral);
                                }
                            }
                            if (this.referralsHandlingMethod == Connection.ReferralHandlingMethod.FOLLOW_MANUALLY) {
                                if (this.currentReferralUrlsList == null || this.currentReferralUrlsList.size() <= 0) break;
                                return true;
                            }
                            break block15;
                        }
                        Response currentResponse = (Response)this.cursor.get();
                        if (currentResponse instanceof SearchResultEntry) {
                            this.currentSearchResultEntry = (SearchResultEntry)currentResponse;
                            return true;
                        }
                        if (!(currentResponse instanceof SearchResultReference) || this.referralsHandlingMethod == Connection.ReferralHandlingMethod.IGNORE) continue;
                        this.referralsInfo.addReferral(((SearchResultReference)currentResponse).getReferral());
                    }
                    if (this.referralsInfo.hasMoreReferrals()) {
                        this.currentReferralUrlsList = new ArrayList<String>(this.referralsInfo.getNextReferral().getLdapUrls());
                        return this.currentReferralUrlsList.size() > 0;
                    }
                    break block16;
                }
                if (this.referralsHandlingMethod == Connection.ReferralHandlingMethod.FOLLOW) {
                    if (this.referralEnumeration != null && this.referralEnumeration.hasMore()) {
                        return true;
                    }
                    if (this.referralsInfo.hasMoreReferrals()) {
                        referral = this.referralsInfo.getNextReferral();
                        ArrayList referralUrls = new ArrayList(referral.getLdapUrls());
                        LdapUrl url = new LdapUrl((String)referralUrls.get(0));
                        Connection referralConnection = ConnectionWrapperUtils.getReferralConnection(referral, this.monitor, this);
                        if (referralConnection != null) {
                            String referralSearchBase = url.getDn() != null && !url.getDn().isEmpty() ? url.getDn().getName() : this.searchBase;
                            String referralFilter = url.getFilter() != null && url.getFilter().length() == 0 ? url.getFilter() : this.filter;
                            SearchControls referralSearchControls = new SearchControls();
                            referralSearchControls.setSearchScope(url.getScope().getScope() > -1 ? url.getScope().getScope() : this.searchControls.getSearchScope());
                            referralSearchControls.setReturningAttributes(url.getAttributes() != null && url.getAttributes().size() > 0 ? url.getAttributes().toArray(new String[url.getAttributes().size()]) : this.searchControls.getReturningAttributes());
                            referralSearchControls.setCountLimit(this.searchControls.getCountLimit());
                            referralSearchControls.setTimeLimit(this.searchControls.getTimeLimit());
                            referralSearchControls.setDerefLinkFlag(this.searchControls.getDerefLinkFlag());
                            referralSearchControls.setReturningObjFlag(this.searchControls.getReturningObjFlag());
                            this.referralEnumeration = referralConnection.getConnectionWrapper().search(referralSearchBase, referralFilter, referralSearchControls, this.aliasesDereferencingMethod, this.referralsHandlingMethod, this.controls, this.monitor, this.referralsInfo);
                            return this.referralEnumeration.hasMore();
                        }
                    }
                }
            }
            Iterator<ILdapLogger> iterator = ConnectionCorePlugin.getDefault().getLdapLoggers().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return false;
                }
                ILdapLogger logger = iterator.next();
                logger.logSearchResultDone(this.connection, this.resultEntryCounter, this.requestNum, null);
            }
        }
        catch (CursorException e) {
            throw new LdapException(e.getMessage(), (Throwable)e);
        }
    }

    public StudioSearchResult next() throws LdapException {
        try {
            if (this.currentSearchResultEntry != null) {
                ++this.resultEntryCounter;
                StudioSearchResult ssr = new StudioSearchResult(this.currentSearchResultEntry, this.connection, false, null);
                for (ILdapLogger logger : ConnectionCorePlugin.getDefault().getLdapLoggers()) {
                    logger.logSearchResultEntry(this.connection, ssr, this.requestNum, null);
                }
                return ssr;
            }
            if (this.referralsHandlingMethod == Connection.ReferralHandlingMethod.FOLLOW_MANUALLY) {
                if (this.currentReferralUrlsList != null && this.currentReferralUrlsList.size() > 0) {
                    ++this.resultEntryCounter;
                    LdapUrl url = new LdapUrl(this.currentReferralUrlsList.remove(0));
                    SearchResultEntryImpl sre = new SearchResultEntryImpl();
                    sre.setEntry((Entry)new DefaultEntry());
                    sre.setObjectName(url.getDn());
                    return new StudioSearchResult((SearchResultEntry)sre, null, false, url);
                }
            } else if (this.referralsHandlingMethod == Connection.ReferralHandlingMethod.FOLLOW) {
                ++this.resultEntryCounter;
                return new StudioSearchResult(this.referralEnumeration.next().getSearchResultEntry(), this.connection, true, null);
            }
            return null;
        }
        catch (Exception e) {
            throw new LdapException(e.getMessage());
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Collection<Control> getResponseControls() {
        Map controlsMap;
        if (this.searchResultDone != null && (controlsMap = this.searchResultDone.getControls()) != null && controlsMap.size() > 0) {
            return controlsMap.values();
        }
        return Collections.emptyList();
    }
}

