/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Table;

public abstract class AbstractTable<K, V>
implements Table<K, V> {
    protected final String name;
    protected SchemaManager schemaManager;
    protected final Comparator<K> keyComparator;
    protected final Comparator<V> valueComparator;
    protected long count;
    protected boolean allowsDuplicates;
    protected AtomicInteger commitNumber;

    protected AbstractTable(SchemaManager schemaManager, String name, Comparator<K> keyComparator, Comparator<V> valueComparator) {
        this.schemaManager = schemaManager;
        this.name = name;
        if (keyComparator == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_591, (Object[])new Object[0]));
        }
        this.keyComparator = keyComparator;
        this.valueComparator = valueComparator;
        this.commitNumber = new AtomicInteger(0);
    }

    @Override
    public Comparator<K> getKeyComparator() {
        return this.keyComparator;
    }

    @Override
    public Comparator<V> getValueComparator() {
        return this.valueComparator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long count(PartitionTxn transaction) throws LdapException {
        return this.count;
    }

    @Override
    public long greaterThanCount(PartitionTxn transaction, K key) throws LdapException {
        return Math.min(this.count, 10L);
    }

    @Override
    public long lessThanCount(PartitionTxn transaction, K key) throws LdapException {
        return Math.min(this.count, 10L);
    }

    @Override
    public boolean isDupsEnabled() {
        return this.allowsDuplicates;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name    : ").append(this.name).append('\n');
        sb.append("NbElems : ").append(this.count).append('\n');
        sb.append("Dups    : ").append(this.allowsDuplicates).append('\n');
        sb.append("Key     : ").append(this.keyComparator.getClass().getName()).append('\n');
        sb.append("Value   : ").append(this.valueComparator.getClass().getName()).append('\n');
        return sb.toString();
    }
}

