/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.EmptyValueAddedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EmptyValueDeletedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.ValueAddedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueDeletedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueModifiedEvent;
import org.apache.directory.studio.ldapbrowser.core.internal.search.LdapSearchPageScoreComputer;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeDescription;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Value;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.eclipse.search.ui.ISearchPageScoreComputer;

public class Attribute
implements IAttribute {
    private static final long serialVersionUID = -5679384884002589786L;
    private AttributeDescription attributeDescription;
    private IEntry entry;
    private List<IValue> valueList;

    public Attribute(IEntry entry, String description) {
        assert (entry != null);
        assert (description != null);
        this.entry = entry;
        this.attributeDescription = new AttributeDescription(description);
        this.valueList = new ArrayList<IValue>();
    }

    @Override
    public IEntry getEntry() {
        return this.entry;
    }

    @Override
    public boolean isConsistent() {
        if (this.valueList.isEmpty()) {
            return false;
        }
        for (IValue value : this.valueList) {
            if (!value.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMustAttribute() {
        if (this.isObjectClassAttribute()) {
            return true;
        }
        Collection<AttributeType> mustAtds = SchemaUtils.getMustAttributeTypeDescriptions(this.entry);
        return mustAtds.contains(this.getAttributeTypeDescription());
    }

    @Override
    public boolean isMayAttribute() {
        return !this.isObjectClassAttribute() && !this.isMustAttribute() && !this.isOperationalAttribute();
    }

    @Override
    public boolean isOperationalAttribute() {
        return this.getAttributeTypeDescription() == null || SchemaUtils.isOperational(this.getAttributeTypeDescription());
    }

    @Override
    public boolean isObjectClassAttribute() {
        return "objectClass".equalsIgnoreCase(this.getDescription());
    }

    @Override
    public boolean isString() {
        return !this.isBinary();
    }

    @Override
    public boolean isBinary() {
        return SchemaUtils.isBinary(this.getAttributeTypeDescription(), this.getEntry().getBrowserConnection().getSchema());
    }

    @Override
    public void addEmptyValue() {
        Value emptyValue = new Value(this);
        this.valueList.add(emptyValue);
        this.attributeModified(new EmptyValueAddedEvent(this.getEntry().getBrowserConnection(), this.getEntry(), this, emptyValue));
    }

    @Override
    public void deleteEmptyValue() {
        Iterator<IValue> it = this.valueList.iterator();
        while (it.hasNext()) {
            IValue value = it.next();
            if (!value.isEmpty()) continue;
            it.remove();
            this.attributeModified(new EmptyValueDeletedEvent(this.getEntry().getBrowserConnection(), this.getEntry(), this, value));
            return;
        }
    }

    private void attributeModified(EntryModificationEvent event) {
        EventRegistry.fireEntryUpdated(event, this.getEntry());
    }

    private void checkValue(IValue value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(BrowserCoreMessages.model__empty_value);
        }
        if (!value.getAttribute().equals(this)) {
            throw new IllegalArgumentException(BrowserCoreMessages.model__values_attribute_is_not_myself);
        }
    }

    private boolean internalDeleteValue(IValue valueToDelete) {
        Iterator<IValue> it = this.valueList.iterator();
        while (it.hasNext()) {
            IValue value = it.next();
            if (!value.equals(valueToDelete)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public void addValue(IValue valueToAdd) throws IllegalArgumentException {
        this.checkValue(valueToAdd);
        this.valueList.add(valueToAdd);
        this.attributeModified(new ValueAddedEvent(this.getEntry().getBrowserConnection(), this.getEntry(), this, valueToAdd));
    }

    @Override
    public void deleteValue(IValue valueToDelete) throws IllegalArgumentException {
        this.checkValue(valueToDelete);
        if (this.internalDeleteValue(valueToDelete)) {
            this.attributeModified(new ValueDeletedEvent(this.getEntry().getBrowserConnection(), this.getEntry(), this, valueToDelete));
        }
    }

    @Override
    public void modifyValue(IValue oldValue, IValue newValue) throws IllegalArgumentException {
        this.checkValue(oldValue);
        this.checkValue(newValue);
        this.internalDeleteValue(oldValue);
        this.valueList.add(newValue);
        this.attributeModified(new ValueModifiedEvent(this.getEntry().getBrowserConnection(), this.getEntry(), this, oldValue, newValue));
    }

    @Override
    public IValue[] getValues() {
        return this.valueList.toArray(new IValue[0]);
    }

    @Override
    public int getValueSize() {
        return this.valueList.size();
    }

    @Override
    public String getDescription() {
        return this.getAttributeDescription().getDescription();
    }

    @Override
    public String getType() {
        return this.getAttributeDescription().getParsedAttributeType();
    }

    public String toString() {
        return this.getDescription();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof IAttribute)) {
            return false;
        }
        IAttribute a = (IAttribute)o;
        if (!this.getEntry().equals(a.getEntry())) {
            return false;
        }
        return this.getDescription().equals(a.getDescription());
    }

    public int hashCode() {
        return this.getDescription().hashCode();
    }

    @Override
    public byte[][] getBinaryValues() {
        IValue[] values;
        ArrayList<byte[]> binaryValueList = new ArrayList<byte[]>();
        IValue[] iValueArray = values = this.getValues();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            IValue value = iValueArray[n2];
            binaryValueList.add(value.getBinaryValue());
            ++n2;
        }
        return (byte[][])binaryValueList.toArray((T[])new byte[0][]);
    }

    @Override
    public String getStringValue() {
        if (this.getValueSize() > 0) {
            return this.valueList.get(0).getStringValue();
        }
        return null;
    }

    @Override
    public String[] getStringValues() {
        IValue[] values;
        ArrayList<String> stringValueList = new ArrayList<String>();
        IValue[] iValueArray = values = this.getValues();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            IValue value = iValueArray[n2];
            stringValueList.add(value.getStringValue());
            ++n2;
        }
        return stringValueList.toArray(new String[stringValueList.size()]);
    }

    @Override
    public AttributeType getAttributeTypeDescription() {
        return this.getEntry().getBrowserConnection().getSchema().getAttributeTypeDescription(this.getType());
    }

    public Object getAdapter(Class adapter) {
        Class clazz = adapter;
        if (clazz.isAssignableFrom(ISearchPageScoreComputer.class)) {
            return new LdapSearchPageScoreComputer();
        }
        if (clazz.isAssignableFrom(Connection.class)) {
            return this.getEntry().getBrowserConnection().getConnection();
        }
        if (clazz.isAssignableFrom(IBrowserConnection.class)) {
            return this.getEntry().getBrowserConnection();
        }
        if (clazz.isAssignableFrom(IEntry.class)) {
            return this.getEntry();
        }
        if (clazz.isAssignableFrom(IAttribute.class)) {
            return this;
        }
        return null;
    }

    @Override
    public AttributeDescription getAttributeDescription() {
        return this.attributeDescription;
    }
}

