/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.torque.Column;
import org.apache.torque.ColumnImpl;
import org.apache.torque.Database;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.TorqueRuntimeException;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.criteria.FromElement;
import org.apache.torque.map.ColumnMap;
import org.apache.torque.map.MapHelper;
import org.apache.torque.map.TableMap;
import org.apache.torque.oid.IdGenerator;
import org.apache.torque.oid.SequenceIdGenerator;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.sql.Query;
import org.apache.torque.sql.SqlBuilder;
import org.apache.torque.util.ColumnValues;
import org.apache.torque.util.ExceptionMapper;
import org.apache.torque.util.JdbcTypedValue;
import org.apache.torque.util.ResultsetSpliterator;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public class BasePeerImpl<T>
implements Serializable {
    private static final long serialVersionUID = -7702123730779032381L;
    private static final Logger log = LogManager.getLogger(BasePeerImpl.class);
    private RecordMapper<T> recordMapper = null;
    private TableMap tableMap = null;
    private String databaseName = null;

    public BasePeerImpl() {
    }

    public BasePeerImpl(RecordMapper<T> recordMapper, TableMap tableMap, String databaseName) {
        this();
        this.setRecordMapper(recordMapper);
        this.setTableMap(tableMap);
        this.setDatabaseName(databaseName);
    }

    public void setRecordMapper(RecordMapper<T> recordMapper) {
        this.recordMapper = recordMapper;
    }

    public RecordMapper<T> getRecordMapper() {
        if (this.recordMapper == null) {
            throw new TorqueRuntimeException("No record mapper injected");
        }
        return this.recordMapper;
    }

    public void setTableMap(TableMap tableMap) {
        this.tableMap = tableMap;
    }

    public TableMap getTableMap() {
        if (this.tableMap == null) {
            throw new TorqueRuntimeException("No table map injected");
        }
        return this.tableMap;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        if (this.databaseName == null) {
            throw new TorqueRuntimeException("No database name injected");
        }
        return this.databaseName;
    }

    public int doDelete(Criteria criteria) throws TorqueException {
        this.setDbName(criteria);
        try (TorqueConnection connection = Transaction.begin(criteria.getDbName());){
            int deletedRows = this.doDelete(criteria, connection);
            Transaction.commit(connection);
            int n = deletedRows;
            return n;
        }
    }

    public int doDelete(Criteria criteria, Connection connection) throws TorqueException {
        int n;
        block10: {
            this.correctBooleans(criteria);
            this.setDbName(criteria);
            Query query = SqlBuilder.buildQuery(criteria);
            query.setType(Query.Type.DELETE);
            String fullTableName = this.tableMap == null ? SqlBuilder.guessFullTableFromCriteria(criteria) : SqlBuilder.getFullTableName(this.tableMap.getFullyQualifiedTableName(), criteria.getDbName());
            boolean ownTableAdded = false;
            for (FromElement fromElement : query.getFromClause()) {
                if (!fullTableName.equalsIgnoreCase(fromElement.getFromExpression())) continue;
                ownTableAdded = true;
                break;
            }
            if (!ownTableAdded) {
                query.getFromClause().add(new FromElement(fullTableName));
            }
            String sql = query.toString();
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            try {
                List<Object> replacements = this.setPreparedStatementReplacements(preparedStatement, query.getPreparedStatementReplacements(), 0);
                StopWatch stopWatch = new StopWatch();
                log.debug("Executing delete {}, parameters = {}", (Object)sql, replacements);
                stopWatch.start();
                int affectedRows = preparedStatement.executeUpdate();
                log.trace("Delete took {} milliseconds", new Supplier[]{() -> stopWatch.getTime()});
                n = affectedRows;
                if (preparedStatement == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw ExceptionMapper.getInstance().toTorqueException(e);
                }
            }
            preparedStatement.close();
        }
        return n;
    }

    public ObjectKey<?> doInsert(ColumnValues insertValues) throws TorqueException {
        String databaseNameFromInsertValues = insertValues.getDbName();
        if (databaseNameFromInsertValues == null) {
            databaseNameFromInsertValues = this.getDatabaseName();
        }
        try (TorqueConnection connection = Transaction.begin(databaseNameFromInsertValues);){
            ObjectKey<?> id = this.doInsert(insertValues, connection);
            Transaction.commit(connection);
            ObjectKey<?> objectKey = id;
            return objectKey;
        }
    }

    public ObjectKey<?> doInsert(ColumnValues insertValues, Connection connection) throws TorqueException {
        if (insertValues == null) {
            throw new TorqueException("insertValues is null");
        }
        if (connection == null) {
            throw new TorqueException("connection is null");
        }
        String databaseNameFromInsertValues = insertValues.getDbName();
        if (databaseNameFromInsertValues == null) {
            databaseNameFromInsertValues = this.getDatabaseName();
        }
        Database database = Torque.getDatabase(databaseNameFromInsertValues);
        Object keyInfo = this.getIdMethodInfo();
        IdGenerator keyGen = database.getIdGenerator(this.getTableMap().getPrimaryKeyMethod());
        SimpleKey<?> id = null;
        ColumnMap primaryKey = null;
        if (keyGen != null) {
            primaryKey = this.getTableMap().getPrimaryKey();
            if (keyGen.isPriorToInsert() && primaryKey != null && !insertValues.containsKey(primaryKey)) {
                id = this.getId(primaryKey, keyGen, connection, keyInfo);
                insertValues.put(primaryKey, new JdbcTypedValue(id.getValue(), id.getJdbcType()));
            }
        }
        String columnNamesList = insertValues.keySet().stream().map(column -> column.getColumnName()).collect(Collectors.joining(",", "(", ")"));
        String fullTableName = SqlBuilder.getFullTableName(this.getTableMap().getFullyQualifiedTableName(), databaseNameFromInsertValues);
        StringBuilder query = new StringBuilder("INSERT INTO ").append(fullTableName).append(columnNamesList).append(" VALUES (");
        boolean first = true;
        ArrayList<JdbcTypedValue> replacementObjects = new ArrayList<JdbcTypedValue>();
        for (Map.Entry<Column, JdbcTypedValue> columnValue : insertValues.entrySet()) {
            if (!first) {
                query.append(",");
            }
            if (columnValue.getValue().getSqlExpression() == null) {
                query.append("?");
                replacementObjects.add(columnValue.getValue());
            } else {
                Column sqlExpression = columnValue.getValue().getSqlExpression();
                query.append(sqlExpression.getSqlExpression());
            }
            first = false;
        }
        query.append(")");
        boolean useGetGeneratedKeys = keyGen != null && keyGen.isGetGeneratedKeysSupported() && primaryKey != null && !insertValues.containsKey(primaryKey);
        try (PreparedStatement preparedStatement = useGetGeneratedKeys ? connection.prepareStatement(query.toString(), 1) : connection.prepareStatement(query.toString());){
            int position = 1;
            for (JdbcTypedValue replacementObject : replacementObjects) {
                Object value = replacementObject.getValue();
                if (value != null) {
                    if (replacementObject.getJdbcType() != 2004 && replacementObject.getJdbcType() != 2005) {
                        preparedStatement.setObject(position, value, replacementObject.getJdbcType());
                    } else {
                        preparedStatement.setObject(position, value);
                    }
                } else {
                    preparedStatement.setNull(position, replacementObject.getJdbcType());
                }
                ++position;
            }
            StopWatch stopWatch = new StopWatch();
            log.debug("Executing insert {} using parameters {}", new Supplier[]{() -> query.toString(), () -> replacementObjects});
            stopWatch.start();
            preparedStatement.executeUpdate();
            log.trace("Insert took {} milliseconds", new Supplier[]{() -> stopWatch.getTime()});
            if (keyGen != null && keyGen.isPostInsert() && primaryKey != null && !insertValues.containsKey(primaryKey)) {
                id = keyGen.isGetGeneratedKeysSupported() ? this.getId(primaryKey, keyGen, connection, preparedStatement) : this.getId(primaryKey, keyGen, connection, keyInfo);
            }
        }
        catch (SQLException e) {
            throw ExceptionMapper.getInstance().toTorqueException(e);
        }
        return id;
    }

    public int doInsert(Column[] toInsertInto, Criteria criteria) throws TorqueException {
        return this.doInsert(toInsertInto, criteria, (String)null);
    }

    public int doInsert(Column[] toInsertInto, Criteria criteria, String dbName) throws TorqueException {
        String dbNameToUse = dbName;
        if (dbNameToUse == null) {
            dbNameToUse = this.getDatabaseName();
        }
        try (TorqueConnection connection = Transaction.begin(dbNameToUse);){
            int numberOfInsertedRows = this.doInsert(toInsertInto, criteria, dbNameToUse, connection);
            Transaction.commit(connection);
            int n = numberOfInsertedRows;
            return n;
        }
    }

    public int doInsert(Column[] toInsertInto, Criteria criteria, Connection connection) throws TorqueException {
        return this.doInsert(toInsertInto, criteria, null, connection);
    }

    public int doInsert(Column[] toInsertInto, Criteria criteria, String dbName, Connection connection) throws TorqueException {
        if (dbName == null) {
            dbName = this.getDatabaseName();
        }
        ColumnMap pk = this.getTableMap().getPrimaryKey();
        boolean pkExistsInColumnMap = false;
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column column : toInsertInto) {
            columnNames.add(column.getColumnName());
            if (pk == null || !column.getSqlExpression().equals(pk.getSqlExpression())) continue;
            pkExistsInColumnMap = true;
        }
        if (!pkExistsInColumnMap) {
            IDMethod idMethod = this.getTableMap().getPrimaryKeyMethod();
            Adapter adapter = Torque.getAdapter(dbName);
            if (idMethod == IDMethod.ID_BROKER) {
                log.debug("pk does not exist in column map and id method is {}, SQL will fail if column has no default value", new Supplier[]{() -> idMethod});
            } else if (idMethod == IDMethod.SEQUENCE || idMethod == IDMethod.NATIVE && adapter.getIDMethodType() == IDMethod.SEQUENCE) {
                IdGenerator keyGen = Torque.getDatabase(dbName).getIdGenerator(this.getTableMap().getPrimaryKeyMethod());
                if (keyGen instanceof SequenceIdGenerator) {
                    int nextvalPos;
                    SequenceIdGenerator sequenceIdGenerator = (SequenceIdGenerator)keyGen;
                    String idSql = sequenceIdGenerator.getIdSql(this.getIdMethodInfo());
                    int spacePos = idSql.lastIndexOf(" ", nextvalPos = idSql.toLowerCase().indexOf("nextval"));
                    if (spacePos != -1) {
                        idSql = idSql.substring(spacePos + 1);
                    }
                    if ((spacePos = idSql.indexOf(" ")) != -1) {
                        idSql = idSql.substring(0, idSql.indexOf(" "));
                    }
                    columnNames.add(pk.getColumnName());
                    criteria.addSelectColumn(new ColumnImpl(null, null, null, idSql));
                } else {
                    log.warn("id method is sequence but keyGen is no Sequence id generator, cannot add sequence generation info");
                }
            }
        }
        String fullTableName = SqlBuilder.getFullTableName(this.getTableMap().getFullyQualifiedTableName(), dbName);
        Query selectQuery = SqlBuilder.buildQuery(criteria);
        StringBuilder query = new StringBuilder("INSERT INTO ").append(fullTableName).append("(").append(StringUtils.join(columnNames, (String)",")).append(") ").append(selectQuery);
        int numberOfInsertedRows = 0;
        try (PreparedStatement preparedStatement = connection.prepareStatement(query.toString());){
            List<Object> replacements = this.setPreparedStatementReplacements(preparedStatement, selectQuery.getPreparedStatementReplacements(), 0);
            StopWatch stopWatch = new StopWatch();
            log.debug("Executing insert {} using parameters {}", new Supplier[]{() -> query.toString(), () -> replacements});
            stopWatch.start();
            numberOfInsertedRows = preparedStatement.executeUpdate();
            log.trace("Insert took {} milliseconds", new Supplier[]{() -> stopWatch.getTime()});
        }
        catch (SQLException e) {
            throw ExceptionMapper.getInstance().toTorqueException(e);
        }
        return numberOfInsertedRows;
    }

    private Object getIdMethodInfo() throws TorqueException {
        IDMethod idMethod = this.tableMap.getPrimaryKeyMethod();
        if (IDMethod.NATIVE == idMethod) {
            Adapter adapter = Torque.getAdapter(this.getDatabaseName());
            if (adapter == null) {
                throw new TorqueException("missing adapter configuration for database " + this.getDatabaseName() + "check the Torque configuration");
            }
            idMethod = adapter.getIDMethodType();
        }
        Object keyInfo = this.tableMap.getPrimaryKeyMethodInfo(idMethod);
        return keyInfo;
    }

    private SimpleKey<?> getId(ColumnMap pk, IdGenerator keyGen, Connection con, Object keyInfo) throws TorqueException {
        SimpleKey id = null;
        if (pk != null && keyGen != null) {
            id = pk.getType() instanceof Number ? new NumberKey(keyGen.getIdAsBigDecimal(con, keyInfo)) : new StringKey(keyGen.getIdAsString(con, keyInfo));
        }
        return id;
    }

    public void addSelectColumns(Criteria criteria) {
        ColumnMap[] columns;
        for (ColumnMap c : columns = this.tableMap.getColumns()) {
            criteria.addSelectColumn(c);
        }
    }

    public List<T> doSelect(Criteria criteria) throws TorqueException {
        if (criteria.getSelectColumns().size() == 0) {
            this.addSelectColumns(criteria);
        }
        this.setDbName(criteria);
        return this.doSelect(criteria, this.getRecordMapper());
    }

    public List<T> doSelect(Criteria criteria, Connection connection) throws TorqueException {
        if (criteria.getSelectColumns().size() == 0) {
            this.addSelectColumns(criteria);
        }
        this.setDbName(criteria);
        return this.doSelect(criteria, this.getRecordMapper(), connection);
    }

    public Stream<T> doSelectAsStream(Criteria criteria, Connection connection) throws TorqueException {
        if (criteria.getSelectColumns().size() == 0) {
            this.addSelectColumns(criteria);
        }
        this.setDbName(criteria);
        return this.doSelectAsStream(criteria, this.getRecordMapper(), connection);
    }

    public T doSelectSingleRecord(Criteria criteria) throws TorqueException {
        List<T> recordList = this.doSelect(criteria);
        T record = null;
        if (recordList.size() > 1) {
            throw new TooManyRowsException("Criteria " + criteria + " matched more than one record");
        }
        if (!recordList.isEmpty()) {
            record = recordList.get(0);
        }
        return record;
    }

    public T doSelectSingleRecord(Criteria criteria, Connection connection) throws TorqueException {
        List<T> recordList = this.doSelect(criteria, connection);
        T record = null;
        if (recordList.size() > 1) {
            throw new TooManyRowsException("Criteria " + criteria + " matched more than one record");
        }
        if (!recordList.isEmpty()) {
            record = recordList.get(0);
        }
        return record;
    }

    public <TT> List<TT> doSelect(Criteria criteria, RecordMapper<TT> mapper) throws TorqueException {
        try (TorqueConnection connection = Transaction.begin(criteria.getDbName());){
            List<TT> result = this.doSelect(criteria, mapper, (Connection)connection);
            Transaction.commit(connection);
            List<TT> list = result;
            return list;
        }
    }

    public List<T> doSelect(String query) throws TorqueException {
        return this.doSelect(query, this.getRecordMapper(), this.getDatabaseName());
    }

    public List<T> doSelect(String query, Connection connection) throws TorqueException {
        return this.doSelect(query, this.getRecordMapper(), connection);
    }

    public Stream<T> doSelectAsStream(String query, Connection connection) throws TorqueException {
        return this.doSelectAsStream(query, this.getRecordMapper(), connection);
    }

    public <TT> List<TT> doSelect(String query, RecordMapper<TT> mapper, String dbName) throws TorqueException {
        try (TorqueConnection connection = Transaction.begin(dbName == null ? Torque.getDefaultDB() : dbName);){
            List<TT> result = this.doSelect(query, mapper, (Connection)connection);
            Transaction.commit(connection);
            List<TT> list = result;
            return list;
        }
    }

    public <TT> List<TT> doSelect(String query, RecordMapper<TT> mapper, Connection connection) throws TorqueException {
        try (Stream<TT> resultStream = this.doSelectAsStream(query, mapper, connection);){
            List list = resultStream.collect(Collectors.toList());
            return list;
        }
    }

    public <TT> Stream<TT> doSelectAsStream(String query, RecordMapper<TT> mapper, Connection connection) throws TorqueException {
        if (connection == null) {
            throw new NullPointerException("connection is null");
        }
        try {
            Statement statement = connection.createStatement();
            StopWatch stopWatch = new StopWatch();
            log.debug("Executing query {}", (Object)query);
            stopWatch.start();
            ResultSet resultSet = statement.executeQuery(query.toString());
            ResultsetSpliterator<TT> spliterator = new ResultsetSpliterator<TT>(mapper, null, statement, resultSet);
            log.trace("Query took {} milliseconds", new Supplier[]{() -> stopWatch.getTime()});
            return (Stream)StreamSupport.stream(spliterator, false).onClose(spliterator);
        }
        catch (SQLException e) {
            throw ExceptionMapper.getInstance().toTorqueException(e);
        }
    }

    public <TT> List<TT> doSelect(Criteria criteria, RecordMapper<TT> mapper, Connection connection) throws TorqueException {
        try (Stream<TT> resultStream = this.doSelectAsStream(criteria, mapper, connection);){
            List result = resultStream.collect(Collectors.toList());
            if (criteria.isSingleRecord() && result.size() > 1) {
                throw new TooManyRowsException("Criteria expected single Record and Multiple Records were selected");
            }
            List list = result;
            return list;
        }
    }

    public <TT> Stream<TT> doSelectAsStream(Criteria criteria, RecordMapper<TT> mapper, Connection connection) throws TorqueException {
        if (connection == null) {
            throw new NullPointerException("connection is null");
        }
        this.correctBooleans(criteria);
        Query query = SqlBuilder.buildQuery(criteria);
        if (query.getFromClause().isEmpty()) {
            String tableName = SqlBuilder.getFullTableName(this.getTableMap().getFullyQualifiedTableName(), criteria.getDbName());
            query.getFromClause().add(new FromElement(tableName));
        }
        try {
            PreparedStatement statement = connection.prepareStatement(query.toString());
            if (query.getFetchSize() != null) {
                statement.setFetchSize(query.getFetchSize());
            }
            List<Object> replacements = this.setPreparedStatementReplacements(statement, query.getPreparedStatementReplacements(), 0);
            StopWatch stopWatch = new StopWatch();
            log.debug("Executing query {}, parameters = {}", (Object)query, replacements);
            stopWatch.start();
            ResultSet resultSet = statement.executeQuery();
            ResultsetSpliterator<TT> spliterator = new ResultsetSpliterator<TT>(mapper, criteria, statement, resultSet);
            log.trace("Query took {} milliseconds", new Supplier[]{() -> stopWatch.getTime()});
            return (Stream)StreamSupport.stream(spliterator, false).onClose(spliterator);
        }
        catch (SQLException e) {
            throw ExceptionMapper.getInstance().toTorqueException(e);
        }
    }

    public <TT> TT doSelectSingleRecord(Criteria criteria, RecordMapper<TT> mapper) throws TorqueException {
        List<TT> resultList = this.doSelect(criteria, mapper);
        TT result = null;
        if (resultList.size() > 1) {
            throw new TooManyRowsException("Criteria " + criteria + " matched more than one record");
        }
        if (!resultList.isEmpty()) {
            result = resultList.get(0);
        }
        return result;
    }

    public <TT> TT doSelectSingleRecord(Criteria criteria, RecordMapper<TT> mapper, Connection connection) throws TorqueException {
        List<TT> resultList = this.doSelect(criteria, mapper, connection);
        TT result = null;
        if (resultList.size() > 1) {
            throw new TooManyRowsException("Criteria " + criteria + " matched more than one record");
        }
        if (!resultList.isEmpty()) {
            result = resultList.get(0);
        }
        return result;
    }

    public int doUpdate(ColumnValues updateValues) throws TorqueException {
        String databaseNameFromUpdateValues = updateValues.getDbName();
        if (databaseNameFromUpdateValues == null) {
            databaseNameFromUpdateValues = this.getDatabaseName();
        }
        try (TorqueConnection connection = Transaction.begin(databaseNameFromUpdateValues);){
            int result = this.doUpdate(updateValues, connection);
            Transaction.commit(connection);
            int n = result;
            return n;
        }
    }

    public int doUpdate(ColumnValues updateValues, Connection connection) throws TorqueException {
        ColumnMap pk = this.getTableMap().getPrimaryKey();
        Criteria selectCriteria = null;
        if (pk == null || !updateValues.containsKey(pk)) {
            throw new TorqueException("No PK specified for database update");
        }
        selectCriteria = new Criteria();
        selectCriteria.where(pk, updateValues.remove(pk).getValue());
        return this.doUpdate(selectCriteria, updateValues, connection);
    }

    public int doUpdate(Criteria selectCriteria, ColumnValues updateValues) throws TorqueException {
        String databaseNameFromUpdateValues = updateValues.getDbName();
        if (databaseNameFromUpdateValues == null) {
            databaseNameFromUpdateValues = this.getDatabaseName();
        }
        try (TorqueConnection connection = Transaction.begin(databaseNameFromUpdateValues);){
            int result = this.doUpdate(selectCriteria, updateValues, connection);
            Transaction.commit(connection);
            int n = result;
            return n;
        }
    }

    public int doUpdate(Criteria criteria, ColumnValues updateValues, Connection connection) throws TorqueException {
        int n;
        block11: {
            Query query = SqlBuilder.buildQuery(criteria);
            query.setType(Query.Type.UPDATE);
            query.getFromClause().clear();
            String fullTableName = SqlBuilder.getFullTableName(this.getTableMap().getFullyQualifiedTableName(), criteria.getDbName());
            query.getFromClause().add(new FromElement(fullTableName));
            query.getUpdateValues().putAll(updateValues);
            PreparedStatement preparedStatement = connection.prepareStatement(query.toString());
            try {
                int position = 1;
                ArrayList<JdbcTypedValue> replacementObjects = new ArrayList<JdbcTypedValue>();
                for (Map.Entry<Column, JdbcTypedValue> updateValue : updateValues.entrySet()) {
                    JdbcTypedValue replacementObject = updateValue.getValue();
                    if (replacementObject.getSqlExpression() != null) continue;
                    Object value = replacementObject.getValue();
                    if (value != null) {
                        preparedStatement.setObject(position, value);
                    } else {
                        preparedStatement.setNull(position, replacementObject.getJdbcType());
                    }
                    replacementObjects.add(replacementObject);
                    ++position;
                }
                List<Object> replacements = this.setPreparedStatementReplacements(preparedStatement, query.getPreparedStatementReplacements(), position - 1);
                StopWatch stopWatch = new StopWatch();
                log.debug("Executing update {} using update parameters {} and query parameters {}", new Supplier[]{() -> query.toString(), () -> replacementObjects, () -> replacements});
                stopWatch.start();
                int affectedRows = preparedStatement.executeUpdate();
                log.trace("Update took {} milliseconds", new Supplier[]{() -> stopWatch.getTime()});
                n = affectedRows;
                if (preparedStatement == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw ExceptionMapper.getInstance().toTorqueException(e);
                }
            }
            preparedStatement.close();
        }
        return n;
    }

    public int executeStatement(String statementString) throws TorqueException {
        return this.executeStatement(statementString, Torque.getDefaultDB(), (List<JdbcTypedValue>)null);
    }

    public int executeStatement(String statementString, List<JdbcTypedValue> replacementValues) throws TorqueException {
        return this.executeStatement(statementString, Torque.getDefaultDB(), replacementValues);
    }

    public int executeStatement(String statementString, String dbName, List<JdbcTypedValue> replacementValues) throws TorqueException {
        try (TorqueConnection con = Transaction.begin(dbName);){
            int rowCount = this.executeStatement(statementString, (Connection)con, replacementValues);
            Transaction.commit(con);
            int n = rowCount;
            return n;
        }
    }

    public int executeStatement(String statementString, Connection con, List<JdbcTypedValue> replacementValues) throws TorqueException {
        int rowCount = -1;
        try (PreparedStatement statement = con.prepareStatement(statementString);){
            if (replacementValues != null) {
                int position = 1;
                for (JdbcTypedValue replacementValue : replacementValues) {
                    if (replacementValue.getValue() == null) {
                        statement.setNull(position, replacementValue.getJdbcType());
                    } else {
                        statement.setObject(position, replacementValue.getValue(), replacementValue.getJdbcType());
                    }
                    ++position;
                }
            }
            rowCount = statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new TorqueException(e);
        }
        return rowCount;
    }

    public int executeStatement(String statementString, Map<String, JdbcTypedValue> replacementValues) throws TorqueException {
        return this.executeStatement(statementString, Torque.getDefaultDB(), replacementValues);
    }

    public int executeStatement(String statementString, String dbName, Map<String, JdbcTypedValue> replacementValues) throws TorqueException {
        try (TorqueConnection con = Transaction.begin(dbName);){
            int rowCount = this.executeStatement(statementString, (Connection)con, replacementValues);
            Transaction.commit(con);
            int n = rowCount;
            return n;
        }
    }

    public int executeStatement(String statementString, Connection con, Map<String, JdbcTypedValue> replacementValues) throws TorqueException {
        StringBuilder changedStatement = new StringBuilder();
        ArrayList<JdbcTypedValue> replacementValueList = new ArrayList<JdbcTypedValue>();
        Pattern pattern = Pattern.compile(":(\\w+)(?: |$)");
        Matcher matcher = pattern.matcher(statementString);
        int statementPosition = 0;
        while (matcher.find()) {
            int groupStart = matcher.start();
            if (groupStart > statementPosition) {
                changedStatement.append(statementString.substring(statementPosition, groupStart));
            }
            String group = matcher.group();
            String key = group.substring(1);
            String replacement = "?";
            if (key.endsWith(" ")) {
                key = key.substring(0, key.length() - 1);
                replacement = replacement + " ";
            }
            if (replacementValues != null && replacementValues.containsKey(key)) {
                changedStatement.append(replacement);
                replacementValueList.add(replacementValues.get(key));
            } else {
                changedStatement.append(group);
            }
            statementPosition = matcher.end();
        }
        if (statementPosition != statementString.length() - 1) {
            changedStatement.append(statementString.substring(statementPosition));
        }
        return this.executeStatement(changedStatement.toString(), con, replacementValueList);
    }

    private List<Object> setPreparedStatementReplacements(PreparedStatement statement, List<Object> replacements, int offset) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>(replacements.size());
        int i = 1 + offset;
        for (Object param : replacements) {
            if (param instanceof Timestamp) {
                statement.setTimestamp(i, (Timestamp)param);
                result.add(param);
            } else if (param instanceof Date) {
                statement.setDate(i, (Date)param);
                result.add(param);
            } else if (param instanceof Time) {
                statement.setTime(i, (Time)param);
                result.add(param);
            } else if (param instanceof java.util.Date) {
                Timestamp sqlDate = new Timestamp(((java.util.Date)param).getTime());
                statement.setTimestamp(i, sqlDate);
                result.add(sqlDate);
            } else if (param instanceof NumberKey) {
                BigDecimal bigDecimal = (BigDecimal)((NumberKey)param).getValue();
                statement.setBigDecimal(i, bigDecimal);
                result.add(bigDecimal);
            } else if (param instanceof Integer) {
                statement.setInt(i, (Integer)param);
                result.add(param);
            } else if (param instanceof Long) {
                statement.setLong(i, (Long)param);
                result.add(param);
            } else if (param instanceof BigDecimal) {
                statement.setBigDecimal(i, (BigDecimal)param);
                result.add(param);
            } else if (param instanceof Boolean) {
                statement.setBoolean(i, (Boolean)param);
                result.add(param);
            } else if (param instanceof Short) {
                statement.setShort(i, (Short)param);
                result.add(param);
            } else if (param instanceof Byte) {
                statement.setByte(i, (Byte)param);
                result.add(param);
            } else if (param instanceof Float) {
                statement.setFloat(i, ((Float)param).floatValue());
                result.add(param);
            } else if (param instanceof Double) {
                statement.setDouble(i, (Double)param);
                result.add(param);
            } else {
                statement.setString(i, param.toString());
                result.add(param.toString());
            }
            ++i;
        }
        return result;
    }

    public void correctBooleans(Criteria criteria) throws TorqueException {
        this.correctBooleans(criteria, criteria.getTopLevelCriterion());
    }

    private void correctBooleans(Criteria criteria, Criterion criterion) throws TorqueException {
        if (criterion == null) {
            return;
        }
        if (criterion.isComposite()) {
            for (Criterion part : criterion.getParts()) {
                this.correctBooleans(criteria, part);
            }
            return;
        }
        Object possibleColumn = criterion.getLValue();
        TableMap tableMapForColumn = MapHelper.getTableMap(possibleColumn, criteria, this.tableMap);
        if (tableMapForColumn == null) {
            return;
        }
        String columnName = ((Column)possibleColumn).getColumnName();
        ColumnMap columnMap = tableMapForColumn.getColumn(columnName);
        if (columnMap != null) {
            if ("BOOLEANINT".equals(columnMap.getTorqueType())) {
                this.replaceBooleanValues(criterion, 1, 0);
            } else if ("BOOLEANCHAR".equals(columnMap.getTorqueType())) {
                this.replaceBooleanValues(criterion, "Y", "N");
            }
        }
    }

    private void replaceBooleanValues(Criterion criterion, Object trueValue, Object falseValue) {
        Object lValue;
        Object rValue = criterion.getRValue();
        if (rValue instanceof Boolean) {
            Boolean booleanValue = (Boolean)rValue;
            criterion.setRValue(Boolean.TRUE.equals(booleanValue) ? trueValue : falseValue);
        }
        if ((lValue = criterion.getLValue()) instanceof Boolean) {
            Boolean booleanValue = (Boolean)lValue;
            criterion.setLValue(Boolean.TRUE.equals(booleanValue) ? trueValue : falseValue);
        }
    }

    public void correctBooleans(ColumnValues columnValues) throws TorqueException {
        for (Map.Entry<Column, JdbcTypedValue> entry : columnValues.entrySet()) {
            String columnName = entry.getKey().getColumnName();
            ColumnMap column = this.getTableMap().getColumn(columnName);
            if (column == null) continue;
            JdbcTypedValue columnValue = entry.getValue();
            if ("BOOLEANINT".equals(column.getTorqueType())) {
                if (Boolean.TRUE.equals(columnValue.getValue())) {
                    entry.setValue(new JdbcTypedValue(1, 4));
                    continue;
                }
                if (Boolean.FALSE.equals(columnValue.getValue())) {
                    entry.setValue(new JdbcTypedValue(0, 4));
                    continue;
                }
                if (columnValue.getValue() != null) continue;
                entry.setValue(new JdbcTypedValue(null, 4));
                continue;
            }
            if (!"BOOLEANCHAR".equals(column.getTorqueType())) continue;
            if (Boolean.TRUE.equals(columnValue.getValue())) {
                entry.setValue(new JdbcTypedValue("Y", 1));
                continue;
            }
            if (Boolean.FALSE.equals(columnValue.getValue())) {
                entry.setValue(new JdbcTypedValue("N", 1));
                continue;
            }
            if (columnValue.getValue() != null) continue;
            entry.setValue(new JdbcTypedValue(null, 1));
        }
    }

    protected void setDbName(Criteria crit) throws TorqueException {
        if (crit.getDbName() == null) {
            crit.setDbName(this.getDatabaseName());
        }
    }
}

