/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.transform;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.processor.string.Camelbacker;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.transform.SourceTargetAttributeTransformer;

public class BeanPropertyMethodNameTransformer
extends SourceTargetAttributeTransformer {
    private static Logger log = Logger.getLogger(BeanPropertyMethodNameTransformer.class);
    private final Camelbacker camelbacker = new Camelbacker();
    private String prefix = "";
    private String suffix = "";

    public BeanPropertyMethodNameTransformer() {
        super("name", null);
    }

    public String getTargetNamePrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        this.prefix = prefix;
        log.debug((Object)("prefix set to " + prefix));
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
        log.debug((Object)("suffix set to " + suffix));
    }

    public SourceElement transform(SourceElement sourceElement, ControllerState controllerState) {
        String targetAttributeName = this.getTargetAttributeName();
        if (targetAttributeName == null) {
            throw new IllegalStateException("targetAttributeName is not set");
        }
        String sourceAttributeName = this.getSourceAttributeName();
        Object attributeValue = sourceElement.getAttribute(sourceAttributeName);
        if (attributeValue == null) {
            log.debug((Object)("Attribute " + sourceAttributeName + " is not set, no changes made"));
            return sourceElement;
        }
        String attributeValueString = attributeValue.toString();
        if (StringUtils.isBlank((String)attributeValueString)) {
            log.debug((Object)("Attribute " + sourceAttributeName + " is blank, no changes made"));
            return sourceElement;
        }
        if (!this.isOverwrite() && sourceElement.getAttribute(targetAttributeName) != null) {
            log.trace((Object)("Attribute " + targetAttributeName + " is filled and overwrite is false, no changes made"));
            return sourceElement;
        }
        this.camelbacker.setDefaultLowerCase(false);
        if (StringUtils.isEmpty((String)this.prefix)) {
            this.camelbacker.setFirstCharUppercase(false);
        }
        String result = this.prefix + this.camelbacker.process(attributeValueString) + this.suffix;
        sourceElement.setAttribute(targetAttributeName, (Object)result);
        return sourceElement;
    }
}

