/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims;

import org.apache.cxf.sts.claims.ClaimsManager;
import org.apache.cxf.sts.claims.ClaimsParameters;
import org.apache.cxf.sts.claims.ProcessedClaimCollection;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;

public final class ClaimsUtils {
    private ClaimsUtils() {
    }

    public static ProcessedClaimCollection processClaims(TokenProviderParameters providerParameters) {
        ClaimsManager claimsManager = providerParameters.getClaimsManager();
        ProcessedClaimCollection retrievedClaims = new ProcessedClaimCollection();
        if (claimsManager != null) {
            ClaimsParameters params = new ClaimsParameters();
            params.setAdditionalProperties(providerParameters.getAdditionalProperties());
            params.setAppliesToAddress(providerParameters.getAppliesToAddress());
            params.setEncryptionProperties(providerParameters.getEncryptionProperties());
            params.setKeyRequirements(providerParameters.getKeyRequirements());
            if (providerParameters.getTokenRequirements().getOnBehalfOf() != null) {
                params.setPrincipal(providerParameters.getTokenRequirements().getOnBehalfOf().getPrincipal());
                params.setRoles(providerParameters.getTokenRequirements().getOnBehalfOf().getRoles());
            } else if (providerParameters.getTokenRequirements().getActAs() != null) {
                params.setPrincipal(providerParameters.getTokenRequirements().getActAs().getPrincipal());
                params.setRoles(providerParameters.getTokenRequirements().getActAs().getRoles());
            } else {
                params.setPrincipal(providerParameters.getPrincipal());
            }
            params.setRealm(providerParameters.getRealm());
            params.setStsProperties(providerParameters.getStsProperties());
            params.setTokenRequirements(providerParameters.getTokenRequirements());
            params.setTokenStore(providerParameters.getTokenStore());
            params.setMessageContext(providerParameters.getMessageContext());
            retrievedClaims = claimsManager.retrieveClaimValues(providerParameters.getRequestedPrimaryClaims(), providerParameters.getRequestedSecondaryClaims(), params);
        }
        return retrievedClaims;
    }
}

